/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.service.base.ListTypeLocalServiceBaseImpl;
import java.util.List;
import java.util.Objects;

public class ListTypeLocalServiceImpl
extends ListTypeLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;

    public ListType addListType(long companyId, String name, String type) {
        ListType listType = this.listTypePersistence.fetchByC_N_T(companyId, name, type);
        if (listType != null) {
            return listType;
        }
        long listTypeId = this.counterLocalService.increment(ListType.class.getName());
        listType = this.listTypePersistence.create(listTypeId);
        listType.setCompanyId(companyId);
        listType.setName(name);
        listType.setType(type);
        return (ListType)this.listTypePersistence.update((BaseModel)listType);
    }

    public void deleteListTypes(long companyId) {
        List listTypes = this.listTypePersistence.findByCompanyId(companyId);
        for (ListType listType : listTypes) {
            this.listTypeLocalService.deleteListType(listType);
        }
    }

    public ListType getListType(long companyId, String name, String type) {
        return this.listTypePersistence.fetchByC_N_T(companyId, name, type);
    }

    public long getListTypeId(long companyId, String name, String type) {
        ListType listType = this.getListType(companyId, name, type);
        return listType.getListTypeId();
    }

    public List<ListType> getListTypes(long companyId, String type) {
        return this.listTypePersistence.findByC_T(companyId, type);
    }

    @Transactional(readOnly=true)
    public void validate(long listTypeId, long classNameId, String type) throws PortalException {
        ClassName className = this._classNameLocalService.getClassName(classNameId);
        this.validate(listTypeId, className.getValue() + type);
    }

    @Transactional(readOnly=true)
    public void validate(long listTypeId, String type) throws PortalException {
        ListType listType = this.listTypePersistence.fetchByPrimaryKey(listTypeId);
        if (listType == null || !Objects.equals(listType.getType(), type)) {
            NoSuchListTypeException noSuchListTypeException = new NoSuchListTypeException();
            noSuchListTypeException.setType(type);
            throw noSuchListTypeException;
        }
    }
}

