/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchPortletException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletTable;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.PortletPersistence;
import com.liferay.portal.kernel.service.persistence.PortletUtil;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.model.impl.PortletImpl;
import com.liferay.portal.model.impl.PortletModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PortletPersistenceImpl
extends BasePersistenceImpl<Portlet>
implements PortletPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = PortletImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "portlet.companyId = ?";
    private FinderPath _finderPathFetchByC_P;
    private static final String _FINDER_COLUMN_C_P_COMPANYID_2 = "portlet.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_P_PORTLETID_2 = "portlet.portletId = ?";
    private static final String _FINDER_COLUMN_C_P_PORTLETID_3 = "(portlet.portletId IS NULL OR portlet.portletId = '')";
    private int _valueObjectFinderCacheListThreshold;
    private static final String _SQL_SELECT_PORTLET = "SELECT portlet FROM Portlet portlet";
    private static final String _SQL_SELECT_PORTLET_WHERE = "SELECT portlet FROM Portlet portlet WHERE ";
    private static final String _SQL_COUNT_PORTLET = "SELECT COUNT(portlet) FROM Portlet portlet";
    private static final String _SQL_COUNT_PORTLET_WHERE = "SELECT COUNT(portlet) FROM Portlet portlet WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "portlet.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Portlet exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Portlet exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(PortletPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"id", "active"});

    public List<Portlet> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<Portlet> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<Portlet> findByCompanyId(long companyId, int start, int end, OrderByComparator<Portlet> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<Portlet> findByCompanyId(long companyId, int start, int end, OrderByComparator<Portlet> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (Portlet portlet : list) {
                if (companyId == portlet.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_PORTLET_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY portlet.id ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Portlet findByCompanyId_First(long companyId, OrderByComparator<Portlet> orderByComparator) throws NoSuchPortletException {
        Portlet portlet = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (portlet != null) {
            return portlet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchPortletException(sb.toString());
    }

    public Portlet fetchByCompanyId_First(long companyId, OrderByComparator<Portlet> orderByComparator) {
        List<Portlet> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Portlet findByCompanyId_Last(long companyId, OrderByComparator<Portlet> orderByComparator) throws NoSuchPortletException {
        Portlet portlet = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (portlet != null) {
            return portlet;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchPortletException(sb.toString());
    }

    public Portlet fetchByCompanyId_Last(long companyId, OrderByComparator<Portlet> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<Portlet> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Portlet[] findByCompanyId_PrevAndNext(long id, long companyId, OrderByComparator<Portlet> orderByComparator) throws NoSuchPortletException {
        Portlet portlet = this.findByPrimaryKey(id);
        Session session = null;
        try {
            session = this.openSession();
            Portlet[] array = new PortletImpl[]{this.getByCompanyId_PrevAndNext(session, portlet, companyId, orderByComparator, true), portlet, this.getByCompanyId_PrevAndNext(session, portlet, companyId, orderByComparator, false)};
            Portlet[] portletArray = array;
            return portletArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Portlet getByCompanyId_PrevAndNext(Session session, Portlet portlet, long companyId, OrderByComparator<Portlet> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_PORTLET_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY portlet.id ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)portlet)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Portlet)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (Portlet portlet : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)portlet);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_PORTLET_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Portlet findByC_P(long companyId, String portletId) throws NoSuchPortletException {
        Portlet portlet = this.fetchByC_P(companyId, portletId);
        if (portlet == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", portletId=");
            sb.append(portletId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchPortletException(sb.toString());
        }
        return portlet;
    }

    public Portlet fetchByC_P(long companyId, String portletId) {
        return this.fetchByC_P(companyId, portletId, true);
    }

    public Portlet fetchByC_P(long companyId, String portletId, boolean useFinderCache) {
        Portlet portlet;
        portletId = Objects.toString(portletId, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, portletId};
        }
        Object result = null;
        if (useFinderCache) {
            result = FinderCacheUtil.getResult((FinderPath)this._finderPathFetchByC_P, finderArgs, (BasePersistence)this);
        }
        if (result instanceof Portlet && (companyId != (portlet = (Portlet)result).getCompanyId() || !Objects.equals(portletId, portlet.getPortletId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_PORTLET_WHERE);
            sb.append(_FINDER_COLUMN_C_P_COMPANYID_2);
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                sb.append(_FINDER_COLUMN_C_P_PORTLETID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindPortletId) {
                    queryPos.add(portletId);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByC_P, (Object[])finderArgs, (Object)list);
                    }
                } else {
                    Portlet portlet2 = (Portlet)list.get(0);
                    result = portlet2;
                    this.cacheResult(portlet2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Portlet)result;
    }

    public Portlet removeByC_P(long companyId, String portletId) throws NoSuchPortletException {
        Portlet portlet = this.findByC_P(companyId, portletId);
        return (Portlet)this.remove((BaseModel)portlet);
    }

    public int countByC_P(long companyId, String portletId) {
        Portlet portlet = this.fetchByC_P(companyId, portletId);
        if (portlet == null) {
            return 0;
        }
        return 1;
    }

    public PortletPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("id", "id_");
        dbColumnNames.put("active", "active_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Portlet.class);
        this.setModelImplClass(PortletImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)PortletTable.INSTANCE);
    }

    public void cacheResult(Portlet portlet) {
        EntityCacheUtil.putResult(PortletImpl.class, (Serializable)Long.valueOf(portlet.getPrimaryKey()), (Serializable)portlet);
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByC_P, (Object[])new Object[]{portlet.getCompanyId(), portlet.getPortletId()}, (Object)portlet);
    }

    public void cacheResult(List<Portlet> portlets) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && portlets.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Portlet portlet : portlets) {
            if (EntityCacheUtil.getResult(PortletImpl.class, (Serializable)Long.valueOf(portlet.getPrimaryKey())) != null) continue;
            this.cacheResult(portlet);
        }
    }

    public void clearCache() {
        EntityCacheUtil.clearCache(PortletImpl.class);
        FinderCacheUtil.clearCache(PortletImpl.class);
    }

    public void clearCache(Portlet portlet) {
        EntityCacheUtil.removeResult(PortletImpl.class, (BaseModel)portlet);
    }

    public void clearCache(List<Portlet> portlets) {
        for (Portlet portlet : portlets) {
            EntityCacheUtil.removeResult(PortletImpl.class, (BaseModel)portlet);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        FinderCacheUtil.clearCache(PortletImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            EntityCacheUtil.removeResult(PortletImpl.class, (Serializable)primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(PortletModelImpl portletModelImpl) {
        Object[] args = new Object[]{portletModelImpl.getCompanyId(), portletModelImpl.getPortletId()};
        FinderCacheUtil.putResult((FinderPath)this._finderPathFetchByC_P, (Object[])args, (Object)((Object)portletModelImpl));
    }

    public Portlet create(long id) {
        PortletImpl portlet = new PortletImpl();
        portlet.setNew(true);
        portlet.setPrimaryKey(id);
        portlet.setCompanyId(CompanyThreadLocal.getCompanyId());
        return portlet;
    }

    public Portlet remove(long id) throws NoSuchPortletException {
        return this.remove(Long.valueOf(id));
    }

    public Portlet remove(Serializable primaryKey) throws NoSuchPortletException {
        Session session = null;
        try {
            session = this.openSession();
            Portlet portlet = (Portlet)session.get(PortletImpl.class, primaryKey);
            if (portlet == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchPortletException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Portlet portlet2 = (Portlet)this.remove((BaseModel)portlet);
            return portlet2;
        }
        catch (NoSuchPortletException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Portlet removeImpl(Portlet portlet) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)portlet)) {
                portlet = (Portlet)session.get(PortletImpl.class, portlet.getPrimaryKeyObj());
            }
            if (portlet != null) {
                session.delete((Object)portlet);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (portlet != null) {
            this.clearCache(portlet);
        }
        return portlet;
    }

    public Portlet updateImpl(Portlet portlet) {
        boolean isNew = portlet.isNew();
        if (!(portlet instanceof PortletModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(portlet.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)portlet);
                throw new IllegalArgumentException("Implement ModelWrapper in portlet proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Portlet implementation " + portlet.getClass());
        }
        PortletModelImpl portletModelImpl = (PortletModelImpl)portlet;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)portlet);
            } else {
                portlet = (Portlet)session.merge((Object)portlet);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        EntityCacheUtil.putResult(PortletImpl.class, (BaseModel)portletModelImpl, (boolean)false, (boolean)true);
        this.cacheUniqueFindersCache(portletModelImpl);
        if (isNew) {
            portlet.setNew(false);
        }
        portlet.resetOriginalValues();
        return portlet;
    }

    public Portlet findByPrimaryKey(Serializable primaryKey) throws NoSuchPortletException {
        Portlet portlet = (Portlet)this.fetchByPrimaryKey(primaryKey);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchPortletException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return portlet;
    }

    public Portlet findByPrimaryKey(long id) throws NoSuchPortletException {
        return this.findByPrimaryKey(Long.valueOf(id));
    }

    public Portlet fetchByPrimaryKey(long id) {
        return (Portlet)this.fetchByPrimaryKey(Long.valueOf(id));
    }

    public List<Portlet> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Portlet> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Portlet> findAll(int start, int end, OrderByComparator<Portlet> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Portlet> findAll(int start, int end, OrderByComparator<Portlet> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_PORTLET);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_PORTLET;
                sql = sql.concat(" ORDER BY portlet.id ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Portlet portlet : this.findAll()) {
            this.remove((BaseModel)portlet);
        }
    }

    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_PORTLET);
                count = (Long)query.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)this._finderPathCountAll, (Object[])FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    protected String getPKDBName() {
        return "id_";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_PORTLET;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return PortletModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathFetchByC_P = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_P", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "portletId"}, true);
        PortletUtil.setPersistence((PortletPersistence)this);
    }

    public void destroy() {
        PortletUtil.setPersistence(null);
        EntityCacheUtil.removeCache((String)PortletImpl.class.getName());
    }

    protected FinderCache getFinderCache() {
        return FinderCacheUtil.getFinderCache();
    }
}

