/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdHttpSession;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import com.liferay.portal.util.PropsValues;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class PortalSessionListener
implements HttpSessionListener {
    private static final Log _log = LogFactoryUtil.getLog(PortalSessionListener.class);
    private final AtomicInteger _counter = new AtomicInteger();

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession;
        block7: {
            httpSession = httpSessionEvent.getSession();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Session " + httpSession.getId() + " was created"));
            }
            if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
                httpSession = new CompoundSessionIdHttpSession(httpSessionEvent.getSession());
            }
            try {
                PortalSessionContext.put((String)httpSession.getId(), (HttpSession)httpSession);
            }
            catch (IllegalStateException illegalStateException) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Throwable)illegalStateException);
            }
        }
        try {
            EventsProcessorUtil.process("servlet.session.create.events", PropsValues.SERVLET_SESSION_CREATE_EVENTS, httpSession);
        }
        catch (ActionException actionException) {
            _log.error((Throwable)actionException);
        }
        if (PropsValues.SESSION_MAX_ALLOWED > 0 && this._counter.incrementAndGet() > PropsValues.SESSION_MAX_ALLOWED) {
            httpSession.setAttribute("SESSION_MAX_ALLOWED", (Object)Boolean.TRUE);
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Exceeded maximum number of ", PropsValues.SESSION_MAX_ALLOWED, " sessions allowed. You may be experiencing a DoS ", "attack."}));
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Session " + httpSession.getId() + " was destroyed"));
        }
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            httpSession = new CompoundSessionIdHttpSession(httpSessionEvent.getSession());
        }
        PortalSessionContext.remove((String)httpSession.getId());
        Long userIdObj = (Long)httpSession.getAttribute("USER_ID");
        if (userIdObj == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"User id is not in the session");
            }
        } else {
            try {
                if (PropsValues.LIVE_USERS_ENABLED) {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                    ClusterNode clusterNode = ClusterExecutorUtil.getLocalClusterNode();
                    if (clusterNode != null) {
                        jsonObject.put("clusterNodeId", clusterNode.getClusterNodeId());
                    }
                    jsonObject.put("command", "signOut");
                    long userId = userIdObj;
                    long companyId = CompanyLocalServiceUtil.getCompanyIdByUserId((long)userId);
                    jsonObject.put("companyId", companyId).put("sessionId", httpSession.getId()).put("userId", userId);
                    MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
                }
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            try {
                EventsProcessorUtil.process("servlet.session.destroy.events", PropsValues.SERVLET_SESSION_DESTROY_EVENTS, httpSession);
            }
            catch (ActionException actionException) {
                _log.error((Throwable)actionException);
            }
        }
        if (PropsValues.SESSION_MAX_ALLOWED > 0) {
            this._counter.decrementAndGet();
        }
    }
}

