/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.nio.ByteBuffer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagUtil {
    public static boolean processETag(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ByteBuffer byteBuffer) {
        String ifNoneMatch;
        if (httpServletResponse.isCommitted()) {
            return false;
        }
        String eTag = httpServletResponse.getHeader("ETag");
        if (eTag == null) {
            int hashCode = ETagUtil._hashCode(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
            eTag = StringBundler.concat((String[])new String[]{"\"", StringUtil.toHexString((int)hashCode), "\""});
            httpServletResponse.setHeader("ETag", eTag);
        }
        if (eTag.equals(ifNoneMatch = httpServletRequest.getHeader("If-None-Match"))) {
            httpServletResponse.setStatus(304);
            httpServletResponse.setContentLength(0);
            return true;
        }
        return false;
    }

    private static int _hashCode(byte[] data, int offset, int length) {
        int hashCode = 0;
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + data[offset++];
        }
        return hashCode;
    }
}

