/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.spring.hibernate.LastSessionRecorderUtil;
import com.liferay.portal.spring.hibernate.PortalTransactionManager;
import com.liferay.portal.spring.hibernate.SpringHibernateThreadLocalUtil;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class PortletTransactionManager
implements PlatformTransactionManager {
    private final PortalTransactionManager _portalTransactionManager;
    private final Supplier<SessionFactoryImplementor> _portletSessionFactoryImplementorSupplier;

    public PortletTransactionManager(PortalTransactionManager portalTransactionManager, SessionFactoryImplementor sessionFactoryImplementor) {
        this(portalTransactionManager, () -> sessionFactoryImplementor);
    }

    public PortletTransactionManager(PortalTransactionManager portalTransactionManager, Supplier<SessionFactoryImplementor> portletSessionFactoryImplementorSupplier) {
        this._portalTransactionManager = portalTransactionManager;
        this._portletSessionFactoryImplementorSupplier = portletSessionFactoryImplementorSupplier;
    }

    public void commit(TransactionStatus transactionStatus) throws TransactionException {
        if (!(transactionStatus instanceof TransactionStatusWrapper)) {
            this._portalTransactionManager.commit(transactionStatus);
            return;
        }
        Throwable throwable1 = null;
        try {
            TransactionStatusWrapper transactionStatusWrapper = (TransactionStatusWrapper)transactionStatus;
            transactionStatus = transactionStatusWrapper._transactionStatus;
            transactionStatusWrapper.reset();
        }
        catch (Throwable throwable2) {
            throwable1 = throwable2;
            throw throwable2;
        }
        finally {
            if (throwable1 == null) {
                this._portalTransactionManager.commit(transactionStatus);
            } else {
                this._portalTransactionManager.rollback(transactionStatus);
            }
        }
    }

    public SessionFactory getPortletSessionFactory() {
        return (SessionFactory)this._portletSessionFactoryImplementorSupplier.get();
    }

    public TransactionStatus getTransaction(TransactionDefinition transactionDefinition) throws TransactionException {
        TransactionStatus portalTransactionStatus = this._portalTransactionManager.getTransaction(transactionDefinition);
        Map<Object, Object> resources = SpringHibernateThreadLocalUtil.getResources(false);
        SessionHolder portalSessionHolder = (SessionHolder)SpringHibernateThreadLocalUtil.getResource(this._portalTransactionManager.getSessionFactory(), resources);
        if (portalSessionHolder == null) {
            return portalTransactionStatus;
        }
        Connection portalConnection = this._getConnection(portalSessionHolder);
        SessionFactory portletSessionFactory = this.getPortletSessionFactory();
        SessionHolder portletSessionHolder = (SessionHolder)SpringHibernateThreadLocalUtil.getResource(portletSessionFactory, resources);
        if (portletSessionHolder != null) {
            if (portalConnection == this._getConnection(portletSessionHolder)) {
                return portalTransactionStatus;
            }
            Session portalSession = portalSessionHolder.getSession();
            portalSession.flush();
        }
        SessionBuilder sessionBuilder = portletSessionFactory.withOptions();
        sessionBuilder = sessionBuilder.connection(portalConnection);
        SessionImpl portletSession = new SessionImpl((SessionFactoryImpl)portletSessionFactory, (SessionCreationOptions)sessionBuilder){

            public boolean isTransactionInProgress() {
                if (TransactionSynchronizationManager.isActualTransactionActive()) {
                    return true;
                }
                return super.isTransactionInProgress();
            }
        };
        SpringHibernateThreadLocalUtil.setResource(portletSessionFactory, this._createSessionHolder((Session)portletSession, portalSessionHolder), resources);
        if (DBPartition.isPartitionEnabled()) {
            LastSessionRecorderUtil.addPortletSession((Session)portletSession);
        }
        return new TransactionStatusWrapper(portalTransactionStatus, portletSessionFactory, portletSessionHolder, (Session)portletSession);
    }

    public void rollback(TransactionStatus transactionStatus) throws TransactionException {
        if (!(transactionStatus instanceof TransactionStatusWrapper)) {
            this._portalTransactionManager.rollback(transactionStatus);
            return;
        }
        try {
            TransactionStatusWrapper transactionStatusWrapper = (TransactionStatusWrapper)transactionStatus;
            transactionStatus = transactionStatusWrapper._transactionStatus;
            transactionStatusWrapper.reset();
        }
        finally {
            this._portalTransactionManager.rollback(transactionStatus);
        }
    }

    private SessionHolder _createSessionHolder(Session session, SessionHolder templateSessionHolder) {
        SessionHolder sessionHolder = new SessionHolder(session);
        sessionHolder.setPreviousFlushMode(templateSessionHolder.getPreviousFlushMode());
        if (templateSessionHolder.isRollbackOnly()) {
            sessionHolder.setRollbackOnly();
        }
        sessionHolder.setSynchronizedWithTransaction(templateSessionHolder.isSynchronizedWithTransaction());
        if (templateSessionHolder.hasTimeout()) {
            Date deadline = templateSessionHolder.getDeadline();
            sessionHolder.setTimeoutInMillis(deadline.getTime() - System.currentTimeMillis());
        }
        sessionHolder.setTransaction(templateSessionHolder.getTransaction());
        if (templateSessionHolder.isVoid()) {
            sessionHolder.unbound();
        }
        return sessionHolder;
    }

    private Connection _getConnection(SessionHolder sessionHolder) {
        Session session = sessionHolder.getSession();
        final ConnectionReference connectionHolder = new ConnectionReference();
        session.doWork(new Work(){

            public void execute(Connection connection) {
                connectionHolder.setConnection(connection);
            }
        });
        return connectionHolder.getConnection();
    }

    private static class TransactionStatusWrapper
    implements TransactionStatus {
        private final Session _portletSession;
        private final SessionFactory _portletSessionFactory;
        private final SessionHolder _previousPortletSessionHolder;
        private final TransactionStatus _transactionStatus;

        public Object createSavepoint() throws TransactionException {
            return this._transactionStatus.createSavepoint();
        }

        public void flush() {
            this._transactionStatus.flush();
        }

        public boolean hasSavepoint() {
            return this._transactionStatus.hasSavepoint();
        }

        public boolean isCompleted() {
            return this._transactionStatus.isCompleted();
        }

        public boolean isNewTransaction() {
            return this._transactionStatus.isNewTransaction();
        }

        public boolean isRollbackOnly() {
            return this._transactionStatus.isRollbackOnly();
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
            this._transactionStatus.releaseSavepoint(savepoint);
        }

        public void reset() {
            try {
                this._portletSession.flush();
                if (DBPartition.isPartitionEnabled()) {
                    LastSessionRecorderUtil.removePortletSession(this._portletSession);
                }
            }
            finally {
                SpringHibernateThreadLocalUtil.setResource(this._portletSessionFactory, this._previousPortletSessionHolder, SpringHibernateThreadLocalUtil.getResources(true));
            }
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this._transactionStatus.rollbackToSavepoint(savepoint);
        }

        public void setRollbackOnly() {
            this._transactionStatus.setRollbackOnly();
        }

        private TransactionStatusWrapper(TransactionStatus transactionStatus, SessionFactory portletSessionFactory, SessionHolder previousPortletSessionHolder, Session portletSession) {
            this._transactionStatus = transactionStatus;
            this._portletSessionFactory = portletSessionFactory;
            this._previousPortletSessionHolder = previousPortletSessionHolder;
            this._portletSession = portletSession;
        }
    }

    private static class ConnectionReference {
        private Connection _connection;

        private ConnectionReference() {
        }

        public Connection getConnection() {
            return this._connection;
        }

        public void setConnection(Connection connection) {
            this._connection = connection;
        }
    }
}

