/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.db.index.IndexUpdaterUtil;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.module.util.ServiceLatch;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.transaction.TransactionsUtil;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.upgrade.log.UpgradeLogContext;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyProcessSuite;
import com.liferay.portal.verify.VerifyProperties;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Connection;
import java.util.Collection;
import java.util.Dictionary;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.core.Appender;
import org.osgi.framework.BundleContext;

public class DBUpgrader {
    private static final Version _VERSION_7010 = new Version(0, 0, 6);
    private static final Log _log = LogFactoryUtil.getLog(DBUpgrader.class);
    private static volatile Appender _appender;
    private static volatile StopWatch _stopWatch;
    private static volatile boolean _upgradeClient;
    private static Boolean _upgradeDatabaseAutoRun;

    public static void checkReleaseState() throws Exception {
        try (Connection connection = DataAccess.getConnection();){
            if (PortalUpgradeProcess.getCurrentState(connection) == 0) {
                return;
            }
            if (StartupHelperUtil.isUpgrading() && PortalUpgradeProcess.supportsRetry(connection)) {
                System.out.println("Retrying upgrade");
                return;
            }
        }
        throw new IllegalStateException(StringBundler.concat((String[])new String[]{"The database contains changes from a previous upgrade ", "attempt that failed. Please restore the old database and ", "file system and retry the upgrade. A patch may be required ", "if the upgrade failed due to a bug or an unforeseen data ", "permutation that resulted from a corrupt database."}));
    }

    public static void checkRequiredBuildNumber(int requiredBuildNumber) throws Exception {
        int buildNumber = DBUpgrader._getBuildNumber();
        if (buildNumber > ReleaseInfo.getParentBuildNumber()) {
            throw new IllegalStateException(StringBundler.concat((Object[])new Object[]{"Attempting to deploy an older Liferay Portal version. ", "Current build number is ", buildNumber, " and attempting to deploy number ", ReleaseInfo.getParentBuildNumber(), "."}));
        }
        if (buildNumber < requiredBuildNumber) {
            String msg = "You must first upgrade to Liferay Portal " + requiredBuildNumber;
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
    }

    public static long getUpgradeTime() {
        if (_stopWatch == null) {
            return 0L;
        }
        return _stopWatch.getTime();
    }

    public static boolean isUpgradeClient() {
        return _upgradeClient;
    }

    public static boolean isUpgradeDatabaseAutoRunEnabled() {
        if (PortalRunMode.isTestMode()) {
            return GetterUtil.getBoolean((String)PropsUtil.get("upgrade.database.auto.run"));
        }
        if (_upgradeDatabaseAutoRun != null) {
            return _upgradeDatabaseAutoRun;
        }
        _upgradeDatabaseAutoRun = DBManagerUtil.getDBType() == DBType.HYPERSONIC ? Boolean.valueOf(false) : Boolean.valueOf(GetterUtil.getBoolean((String)PropsUtil.get("upgrade.database.auto.run")));
        return _upgradeDatabaseAutoRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String result;
        block4: {
            result = "Completed";
            _upgradeClient = true;
            try {
                DBUpgrader._initUpgradeStopwatch();
                PortalClassPathUtil.initializeClassPaths(null);
                InitUtil.initWithSpring(ListUtil.fromArray((Object[])PropsUtil.getArray("spring.configs")), true, false, () -> StartupHelperUtil.setUpgrading(true));
                StartupHelperUtil.printPatchLevel();
                DBUpgrader.upgradePortal();
                InitUtil.registerContext();
                DBUpgrader.upgradeModules();
                BundleContext bundleContext = SystemBundleUtil.getBundleContext();
                Collection collection = bundleContext.getServiceReferences(Store.class, "(default=true)");
                if (!collection.isEmpty()) break block4;
                throw new IllegalStateException("Missing default Store");
            }
            catch (Exception exception) {
                try {
                    _log.error((Throwable)exception);
                    result = "Failed";
                }
                catch (Throwable throwable) {
                    StartupHelperUtil.setUpgrading(false);
                    System.out.println(StringBundler.concat((Object[])new Object[]{"\n", result, " Liferay upgrade process in ", _stopWatch.getTime() / 1000L, " seconds"}));
                    throw throwable;
                }
                StartupHelperUtil.setUpgrading(false);
                System.out.println(StringBundler.concat((Object[])new Object[]{"\n", result, " Liferay upgrade process in ", _stopWatch.getTime() / 1000L, " seconds"}));
            }
        }
        StartupHelperUtil.setUpgrading(false);
        System.out.println(StringBundler.concat((Object[])new Object[]{"\n", result, " Liferay upgrade process in ", _stopWatch.getTime() / 1000L, " seconds"}));
        System.out.println("Exiting DBUpgrader#main(String[]).");
    }

    public static void startUpgradeLogAppender() {
        if (_stopWatch == null) {
            DBUpgrader._initUpgradeStopwatch();
        }
        ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
        serviceLatch.waitFor(StringBundler.concat((String[])new String[]{"(&(appender.name=UpgradeLogAppender)(objectClass=", Appender.class.getName(), "))"}), appender -> {
            _appender = appender;
            _appender.start();
        });
        serviceLatch.openOn(() -> {});
    }

    public static void stopUpgradeLogAppender() {
        if (_appender != null) {
            _stopWatch.stop();
            _appender.stop();
        }
    }

    public static void upgradeModules() {
        DBUpgrader._registerModuleServiceLifecycle("portal.initialized");
        if (_upgradeClient) {
            DependencyManagerSyncUtil.sync();
        }
        PortalCacheHelperUtil.clearPortalCaches((String)"MULTI_VM_PORTAL_CACHE_MANAGER");
        DBUpgrader._registerModuleServiceLifecycle("portlets.initialized");
        if (_upgradeClient && DBUpgrader.isUpgradeDatabaseAutoRunEnabled() || StartupHelperUtil.isNewRelease()) {
            IndexUpdaterUtil.updateAllIndexes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradePortal() throws Exception {
        try {
            UpgradeLogContext.setContext("portal");
            VerifyProperties.verify();
            if (FeatureFlagManagerUtil.isEnabled((String)"LPS-157670")) {
                DBUpgrader.checkRequiredBuildNumber(6100);
            } else {
                DBUpgrader.checkRequiredBuildNumber(6200);
            }
            DBUpgrader.checkReleaseState();
            int buildNumber = DBUpgrader._getBuildNumber();
            try (Connection connection = DataAccess.getConnection();){
                if (PortalUpgradeProcess.isInLatestSchemaVersion(connection) && buildNumber == ReleaseInfo.getParentBuildNumber()) {
                    DBUpgrader._checkClassNamesAndResourceActions();
                    return;
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Disable cache registry");
            }
            CacheRegistryUtil.setActive((boolean)false);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Update build " + buildNumber));
            }
            if (PropsValues.UPGRADE_DATABASE_TRANSACTIONS_DISABLED) {
                TransactionsUtil.disableTransactions();
            }
            try {
                buildNumber = DBUpgrader._getBuildNumberForMissedUpgradeProcesses(buildNumber);
                StartupHelperUtil.upgradeProcess(buildNumber);
                connection = DataAccess.getConnection();
                var2_3 = null;
                try {
                    PortalUpgradeProcess.updateState(connection, 0);
                }
                catch (Throwable throwable) {
                    var2_3 = throwable;
                    throw throwable;
                }
                finally {
                    if (connection != null) {
                        if (var2_3 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable) {
                                var2_3.addSuppressed(throwable);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                try (Connection connection = DataAccess.getConnection();){
                    PortalUpgradeProcess.updateState(connection, 1);
                }
                throw exception;
            }
            finally {
                if (PropsValues.UPGRADE_DATABASE_TRANSACTIONS_DISABLED) {
                    TransactionsUtil.enableTransactions();
                }
            }
            IndexUpdaterUtil.updatePortalIndexes();
            connection = DataAccess.getConnection();
            var2_3 = null;
            try {
                PortalUpgradeProcess.updateBuildInfo(connection);
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (connection != null) {
                    if (var2_3 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
            CustomSQLUtil.reloadCustomSQL();
            SQLTransformer.reloadSQLTransformer();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Update company key");
            }
            DBUpgrader._updateCompanyKey();
            PortalCacheHelperUtil.clearPortalCaches((String)"MULTI_VM_PORTAL_CACHE_MANAGER");
            CacheRegistryUtil.setActive((boolean)true);
            DBUpgrader._checkClassNamesAndResourceActions();
            DBUpgrader.verify();
            DLFileEntryTypeLocalServiceUtil.getBasicDocumentDLFileEntryType();
        }
        finally {
            UpgradeLogContext.clearContext();
        }
    }

    public static void verify() throws Exception {
        VerifyProcessSuite verifyProcessSuite = new VerifyProcessSuite();
        verifyProcessSuite.verify();
    }

    private static void _checkClassNamesAndResourceActions() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check class names");
        }
        try {
            DBPartitionUtil.forEachCompanyId((UnsafeConsumer<Long, Exception>)((UnsafeConsumer)companyId -> {
                ClassNameLocalServiceUtil.checkClassNames();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Check resource actions");
                }
                StartupHelperUtil.initResourceActions();
            }));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static int _getBuildNumber() throws Exception {
        try (Connection connection = DataAccess.getConnection();){
            int n = PortalUpgradeProcess.getCurrentBuildNumber(connection);
            return n;
        }
    }

    private static int _getBuildNumberForMissedUpgradeProcesses(int buildNumber) throws Exception {
        if (buildNumber == 7010) {
            try (Connection connection = DataAccess.getConnection();){
                Version schemaVersion = PortalUpgradeProcess.getCurrentSchemaVersion(connection);
                if (!schemaVersion.equals((Object)_VERSION_7010)) {
                    int n = 7001;
                    return n;
                }
            }
        }
        return buildNumber;
    }

    private static void _initUpgradeStopwatch() {
        _stopWatch = new StopWatch();
        _stopWatch.start();
    }

    private static void _registerModuleServiceLifecycle(String moduleServiceLifecycle) {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        bundleContext.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, (Dictionary)HashMapDictionaryBuilder.put((Object)"module.service.lifecycle", (Object)moduleServiceLifecycle).put((Object)"service.vendor", (Object)ReleaseInfo.getVendor()).put((Object)"service.version", (Object)ReleaseInfo.getVersion()).build());
    }

    private static void _updateCompanyKey() throws Exception {
        DB db = DBManagerUtil.getDB();
        db.runSQL("update CompanyInfo set key_ = null");
    }
}

