/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.ProcessingInstruction;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolDependencies;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class SPDXBuilder {
    private static final Log _log = LogFactoryUtil.getLog(SPDXBuilder.class);
    private static final Map<String, QName> _qNameMap = new HashMap<String, QName>();

    public static void main(String[] args) throws IOException {
        ToolDependencies.wireBasic();
        String xmls = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));){
            xmls = bufferedReader.readLine();
        }
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String spdxFileName = ArgumentsUtil.getString(arguments, "spdx.file", null);
        String licenseOverridePropertiesFileName = ArgumentsUtil.getString(arguments, "license.override.properties.file", null);
        new SPDXBuilder(StringUtil.split((String)xmls), spdxFileName, licenseOverridePropertiesFileName);
    }

    public SPDXBuilder(String[] xmls, String spdxFileName, String licenseOverridePropertiesFileName) {
        try {
            File licenseOverridePropertiesfile;
            System.setProperty("line.separator", "\n");
            File spdxFile = new File(spdxFileName);
            Properties licenseOverrideProperties = new Properties();
            if (Validator.isNotNull((String)licenseOverridePropertiesFileName) && (licenseOverridePropertiesfile = new File(licenseOverridePropertiesFileName)).exists()) {
                licenseOverrideProperties.load(new FileInputStream(licenseOverridePropertiesfile));
            }
            Document document = this._getDocument(xmls, spdxFile, licenseOverrideProperties);
            String xml = document.formattedString();
            this._write(new File(spdxFile.getParentFile(), "versions-spdx.xml"), xml);
            this._write(new File(spdxFile.getParentFile(), "versions-spdx.csv"), this._toCSV(document));
            TransformerFactory transformerFactory = SecureXMLFactoryProviderUtil.newTransformerFactory();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new File(spdxFile.getParentFile(), "versions.xsl")));
            File versionHtmlFile = new File(spdxFile.getParentFile(), "versions-spdx.html");
            transformer.transform(new StreamSource(new ByteArrayInputStream(xml.getBytes())), new StreamResult(new FileOutputStream(versionHtmlFile)));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private List<Element> _createLibraryElements(Element packageElement, Properties licenseOverrideProperties) {
        ArrayList<Element> libraryElements = new ArrayList<Element>();
        String downloadLocation = packageElement.elementText(this._getQName("downloadLocation"));
        String name = packageElement.elementText(this._getQName("name"));
        String versionInfo = packageElement.elementText(this._getQName("versionInfo"));
        Element hasFileElement = packageElement.element(this._getQName("hasFile"));
        List fileElements = hasFileElement.elements(this._getQName("File"));
        for (Element fileElement : fileElements) {
            String licenseName;
            String fileName = fileElement.elementText(this._getQName("fileName"));
            String dirName = fileName.substring(0, fileName.indexOf(47) + 1);
            if (dirName.endsWith("portal/") || dirName.endsWith("portal-ee/")) {
                fileName = fileName.substring(dirName.length());
            }
            Element libraryElement = SAXReaderUtil.createElement((String)"library");
            Element fileNameElement = libraryElement.addElement("file-name");
            fileNameElement.addText(fileName);
            Element versionElement = libraryElement.addElement("version");
            versionElement.addText(versionInfo);
            Element projectNameElement = libraryElement.addElement("project-name");
            projectNameElement.addText(name);
            if (downloadLocation != null && downloadLocation.startsWith("http")) {
                Element element = libraryElement.addElement("project-url");
                element.addText(downloadLocation);
            }
            if ((licenseName = this._getLicenseName(packageElement, fileName, licenseOverrideProperties)) != null) {
                Element licensesElement = libraryElement.addElement("licenses");
                Element licenseElement = licensesElement.addElement("license");
                Element element = licenseElement.addElement("license-name");
                element.addText(licenseName);
                String licenseURL = this._getLicenseURL(packageElement, fileName, licenseOverrideProperties);
                if (licenseURL != null) {
                    element = licenseElement.addElement("license-url");
                    element.addText(licenseURL);
                }
            }
            libraryElements.add(libraryElement);
        }
        return libraryElements;
    }

    private String _encode(Node node) {
        if (node == null) {
            return "";
        }
        String text = node.getText();
        text = StringUtil.trim((String)text.replaceAll("\\s+", " "));
        return CSVUtil.encode((String)text);
    }

    private Document _getDocument(String[] xmls, File spdxFile, Properties licenseOverrideProperties) throws Exception {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        TreeMap<String, Element> libraryElementMap = new TreeMap<String, Element>(comparator);
        for (String xml : xmls) {
            Document xmlDocument = SAXReaderUtil.read((File)new File(xml));
            List fileNameNodes = xmlDocument.selectNodes("//file-name");
            for (Node fileNameNode : fileNameNodes) {
                Element libraryElement = fileNameNode.getParent();
                libraryElementMap.put(this._getKey("portal", libraryElement), libraryElement);
            }
        }
        Document spdxDocument = SAXReaderUtil.read((File)spdxFile);
        Element spdxRootElement = spdxDocument.getRootElement();
        Element spdxDocumentElement = spdxRootElement.element(this._getQName("SpdxDocument"));
        List elements = spdxDocumentElement.elements(this._getQName("relationship"));
        for (Element element : elements) {
            Element relationshipElement = element.element(this._getQName("Relationship"));
            Element relatedSPDXElement = relationshipElement.element(this._getQName("relatedSpdxElement"));
            Element packageElement = relatedSPDXElement.element(this._getQName("Package"));
            List<Element> libraryElements = this._createLibraryElements(packageElement, licenseOverrideProperties);
            for (Element libraryElement : libraryElements) {
                libraryElementMap.put(this._getKey("spdx", libraryElement), libraryElement);
            }
        }
        Document document = SAXReaderUtil.createDocument();
        ProcessingInstruction processingInstruction = SAXReaderUtil.createProcessingInstruction((String)"xml-stylesheet", (Map)HashMapBuilder.put((Object)"href", (Object)"versions.xsl").put((Object)"type", (Object)"text/xsl").build());
        document.add(processingInstruction);
        Element versionsElement = document.addElement("versions");
        Element versionElement = versionsElement.addElement("version");
        Element librariesElement = versionElement.addElement("libraries");
        for (Element libraryElement : libraryElementMap.values()) {
            librariesElement.add(libraryElement.detach());
        }
        return document;
    }

    private String _getKey(String type, Element libraryElement) {
        StringBundler sb = new StringBundler(5);
        sb.append(StringUtil.upperCase((String)type));
        sb.append(":");
        Node fileNameNode = libraryElement.selectSingleNode("file-name");
        sb.append(fileNameNode.getText());
        sb.append(":");
        Node versionNode = libraryElement.selectSingleNode("version");
        sb.append(versionNode.getText());
        return sb.toString();
    }

    private String _getLicenseName(Element packageElement, String fileName, Properties licenseOverrideProperties) {
        String key = "license.name[" + fileName + "]";
        if (licenseOverrideProperties.containsKey(key)) {
            return licenseOverrideProperties.getProperty(key);
        }
        Element licenseConcludedElement = packageElement.element(this._getQName("licenseConcluded"));
        if (licenseConcludedElement == null) {
            return null;
        }
        String resource = licenseConcludedElement.attributeValue(this._getQName("resource"));
        if (resource.startsWith("http://spdx.org/licenses/")) {
            return resource.substring(25);
        }
        if (resource.startsWith("LicenseRef-")) {
            return resource.substring(11);
        }
        return null;
    }

    private String _getLicenseURL(Element packageElement, String fileName, Properties licenseProperties) {
        String key = "license.url[" + fileName + "]";
        if (licenseProperties.containsKey(key)) {
            return licenseProperties.getProperty(key);
        }
        Element licenseConcludedElement = packageElement.element(this._getQName("licenseConcluded"));
        String resource = licenseConcludedElement.attributeValue(this._getQName("resource"));
        if (!resource.startsWith("http")) {
            return null;
        }
        return resource;
    }

    private QName _getQName(String name) {
        if (!_qNameMap.containsKey(name)) {
            QName qName = SAXReaderUtil.createQName((String)name, (Namespace)SAXReaderUtil.createNamespace((String)"spdx", (String)"http://spdx.org/rdf/terms#"));
            if (Objects.equals(name, "resource")) {
                qName = SAXReaderUtil.createQName((String)name, (Namespace)SAXReaderUtil.createNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
            }
            _qNameMap.put(name, qName);
        }
        return _qNameMap.get(name);
    }

    private String _toCSV(Document document) {
        StringBundler sb = new StringBundler();
        sb.append("File Name,Version,Project,License,Comments");
        List libraryNodes = document.selectNodes("//library");
        for (Node libraryNode : libraryNodes) {
            sb.append('\n');
            sb.append(this._encode(libraryNode.selectSingleNode("file-name")));
            sb.append(',');
            sb.append(this._encode(libraryNode.selectSingleNode("version")));
            sb.append(',');
            sb.append(this._encode(libraryNode.selectSingleNode("project-name")));
            sb.append(',');
            Object[] licenses = new String[]{};
            List licenseNameNodes = libraryNode.selectNodes("./licenses/license/license-name");
            if (!licenseNameNodes.isEmpty()) {
                String text = "";
                if (licenseNameNodes.get(0) != null) {
                    Node node = (Node)licenseNameNodes.get(0);
                    text = node.getText();
                    text = StringUtil.trim((String)text.replaceAll("\\s+", " "));
                }
                licenses = (String[])ArrayUtil.append((Object[])licenses, (Object)text);
            }
            sb.append(CSVUtil.encode((Object)licenses));
            sb.append(',');
            sb.append(this._encode(libraryNode.selectSingleNode("comments")));
        }
        return sb.toString();
    }

    private void _write(File file, String s) throws Exception {
        Files.write(file.toPath(), s.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

