/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpgradeListTypeCompanyId
extends UpgradeProcess {
    private static final Map<String, List<String>> _listTypeReferences = HashMapBuilder.put((Object)"Address", Collections.singletonList("listTypeId")).put((Object)"Contact_", Arrays.asList("prefixListTypeId", "suffixListTypeId")).put((Object)"EmailAddress", Collections.singletonList("listTypeId")).put((Object)"Organization_", Collections.singletonList("statusListTypeId")).put((Object)"OrgLabor", Collections.singletonList("listTypeId")).put((Object)"Phone", Collections.singletonList("listTypeId")).put((Object)"Website", Collections.singletonList("listTypeId")).build();

    protected void doUpgrade() throws Exception {
        long defaultCompanyId = PortalInstancePool.getDefaultCompanyId();
        this._resetCounter(defaultCompanyId);
        if (DBPartition.isPartitionEnabled()) {
            this._upgradeDBPartition(defaultCompanyId);
            return;
        }
        this._upgrade(defaultCompanyId);
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"ListType", (String[])new String[]{"companyId LONG"})};
    }

    private List<ListTypeEntry> _getListTypes() throws Exception {
        ArrayList<ListTypeEntry> listTypeEntries = new ArrayList<ListTypeEntry>();
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select listTypeId, name, type_ from ListType");){
            while (resultSet.next()) {
                listTypeEntries.add(new ListTypeEntry(resultSet.getLong(1), resultSet.getString(2), resultSet.getString(3)));
            }
        }
        return listTypeEntries;
    }

    private HashMap<Long, Long> _insertListTypes(List<ListTypeEntry> listTypeEntries, long companyId) throws Exception {
        HashMap<Long, Long> listTypeIds = new HashMap<Long, Long>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("insert into ListType (mvccVersion, listTypeId, companyId, name, type_) values (?, ?, ?, ?, ?)");){
            for (ListTypeEntry listTypeEntry : listTypeEntries) {
                long newListTypeId = this.increment(ListType.class.getName());
                preparedStatement.setLong(1, 0L);
                preparedStatement.setLong(2, newListTypeId);
                preparedStatement.setLong(3, companyId);
                preparedStatement.setString(4, listTypeEntry.getName());
                preparedStatement.setString(5, listTypeEntry.getType());
                listTypeIds.put(listTypeEntry.getListTypeId(), newListTypeId);
                preparedStatement.execute();
            }
        }
        return listTypeIds;
    }

    private void _resetCounter(long defaultCompanyId) throws Exception {
        if (!DBPartition.isPartitionEnabled() || CompanyThreadLocal.getCompanyId() == defaultCompanyId) {
            try (Statement statement = this.connection.createStatement();
                 ResultSet resultSet1 = statement.executeQuery(StringBundler.concat((String[])new String[]{"select currentId from Counter where name = '", ListType.class.getName(), "'"}));){
                long counter = 0L;
                if (resultSet1.next()) {
                    counter = resultSet1.getLong("currentId");
                }
                try (ResultSet resultSet2 = statement.executeQuery("select max(listTypeId) from ListType");){
                    long increment;
                    if (resultSet2.next() && (increment = Math.max(0L, resultSet2.getLong(1) - counter)) > 0L) {
                        this.increment(ListType.class.getName(), (int)increment);
                    }
                }
            }
        }
    }

    private void _updateListTypeReferences(HashMap<Long, Long> listTypeIds, long companyId) throws Exception {
        for (Map.Entry<String, List<String>> listTypeReference : _listTypeReferences.entrySet()) {
            String tableName = listTypeReference.getKey();
            List<String> columnNames = listTypeReference.getValue();
            for (String columnName : columnNames) {
                PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update ", tableName, " set ", columnName, " = ? where ", columnName, " = ? and companyId = ?"}));
                Throwable throwable = null;
                try {
                    for (Map.Entry<Long, Long> entry : listTypeIds.entrySet()) {
                        preparedStatement.setLong(1, entry.getValue());
                        preparedStatement.setLong(2, entry.getKey());
                        preparedStatement.setLong(3, companyId);
                        preparedStatement.executeUpdate();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (preparedStatement == null) continue;
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    preparedStatement.close();
                }
            }
        }
    }

    private void _upgrade(long defaultCompanyId) throws Exception {
        this.dropIndexes("ListType", "name");
        this.runSQL("update ListType set companyId = " + defaultCompanyId);
        long[] companyIds = PortalInstancePool.getCompanyIds();
        List<ListTypeEntry> listTypeEntries = this._getListTypes();
        for (long companyId : companyIds) {
            if (companyId == defaultCompanyId) continue;
            HashMap<Long, Long> listTypeIds = this._insertListTypes(listTypeEntries, companyId);
            this._updateListTypeReferences(listTypeIds, companyId);
        }
    }

    private void _upgradeDBPartition(long defaultCompanyId) throws Exception {
        if (CompanyThreadLocal.getCompanyId() == defaultCompanyId) {
            this.runSQL("update ListType set companyId = " + defaultCompanyId);
        } else {
            DBPartitionUtil.replaceByTable(this.connection, true, "ListType");
            this.runSQL("update ListType set companyId = " + CompanyThreadLocal.getCompanyId());
        }
    }

    private static class ListTypeEntry {
        private final long _listTypeId;
        private final String _name;
        private final String _type;

        public ListTypeEntry(long listTypeId, String name, String type) {
            this._listTypeId = listTypeId;
            this._name = name;
            this._type = type;
        }

        public long getListTypeId() {
            return this._listTypeId;
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }
    }
}

