/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.verify.model.VerifiableResourcedModel;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.model.GroupVerifiableResourcedModel;
import com.liferay.portal.verify.model.LayoutBranchVerifiableResourcedModel;
import java.util.concurrent.atomic.AtomicInteger;

public class VerifyResourcePermissions
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyResourcePermissions.class);
    private static VerifiableResourcedModel[] _verifiableResourcedModels;

    public static void verify(VerifiableResourcedModel ... verifiableResourcedModels) throws Exception {
        VerifyResourcePermissions verifyResourcePermissions = new VerifyResourcePermissions();
        _verifiableResourcedModels = verifiableResourcedModels;
        verifyResourcePermissions.verify();
    }

    @Override
    protected void doVerify() throws Exception {
        if (ArrayUtil.isNotEmpty((Object[])_verifiableResourcedModels)) {
            this.doVerify(_verifiableResourcedModels);
            return;
        }
        this.doVerify(new GroupVerifiableResourcedModel(), new LayoutBranchVerifiableResourcedModel());
    }

    protected void doVerify(VerifiableResourcedModel ... verifiableResourcedModels) throws Exception {
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Owner");
            for (VerifiableResourcedModel verifiableResourcedModel : verifiableResourcedModels) {
                this._verifyResourcedModel(role, verifiableResourcedModel);
            }
        });
    }

    /*
     * Exception decompiling
     */
    private int _getVerifiableResourcedModelsCount(Role role, VerifiableResourcedModel verifiableResourcedModel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String _getVerifyResourcedModelSQL(boolean count, VerifiableResourcedModel verifiableResourcedModel, Role role) {
        StringBundler sb = new StringBundler(28);
        sb.append("select ");
        if (count) {
            sb.append("count(*)");
        } else {
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(".");
            sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
            sb.append(", ");
            sb.append(verifiableResourcedModel.getTableName());
            sb.append(".");
            sb.append(verifiableResourcedModel.getUserIdColumnName());
        }
        sb.append(" from ");
        sb.append(verifiableResourcedModel.getTableName());
        sb.append(" left join ResourcePermission on (ResourcePermission.");
        sb.append("companyId = ");
        sb.append(role.getCompanyId());
        sb.append(" and ResourcePermission.name = '");
        sb.append(verifiableResourcedModel.getModelName());
        sb.append("' and ResourcePermission.scope = ");
        sb.append(4);
        sb.append(" and ResourcePermission.primKeyId = ");
        sb.append(verifiableResourcedModel.getTableName());
        sb.append(".");
        sb.append(verifiableResourcedModel.getPrimaryKeyColumnName());
        sb.append(" and ResourcePermission.roleId = ");
        sb.append(role.getRoleId());
        sb.append(") where ");
        sb.append(verifiableResourcedModel.getTableName());
        sb.append(".companyId = ");
        sb.append(role.getCompanyId());
        sb.append(" and ResourcePermission.primKeyId is NULL");
        return SQLTransformer.transform(sb.toString());
    }

    private void _verifyResourcedModel(Role role, VerifiableResourcedModel verifiableResourcedModel) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableResourcedModel.getTableName());){
            AtomicInteger atomicInteger = new AtomicInteger();
            DCLSingleton verifiableResourcedModelsCount = new DCLSingleton();
            this.processConcurrently(this._getVerifyResourcedModelSQL(false, verifiableResourcedModel, role), resultSet -> new Object[]{resultSet.getLong(verifiableResourcedModel.getPrimaryKeyColumnName()), resultSet.getLong(verifiableResourcedModel.getUserIdColumnName())}, values -> {
                long primKey = (Long)values[0];
                long ownerId = (Long)values[1];
                long companyId = role.getCompanyId();
                long roleId = role.getRoleId();
                String modelName = verifiableResourcedModel.getModelName();
                int processedCount = atomicInteger.getAndIncrement();
                if (_log.isInfoEnabled() && processedCount % 100000 == 0) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Processed ", processedCount, " of ", verifiableResourcedModelsCount.getSingleton(() -> this._getVerifiableResourcedModelsCount(role, verifiableResourcedModel)), " resource permissions for company ", companyId, " and model ", modelName}));
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"No resource found for {", companyId, ", ", modelName, ", ", 4, ", ", primKey, ", ", roleId, "}"}));
                }
                try {
                    ResourceLocalServiceUtil.addResources((long)companyId, (long)0L, (long)ownerId, (String)modelName, (String)String.valueOf(primKey), (boolean)false, (boolean)false, (boolean)false);
                }
                catch (Exception exception) {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to add resource for {", companyId, ", ", modelName, ", ", 4, ", ", primKey, ", ", roleId, "}"}), (Throwable)exception);
                }
            }, null);
        }
    }
}

