/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.webdav.BaseWebDAVStorageImpl;
import java.util.ArrayList;
import java.util.List;

public class GroupWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    private static final Log _log = LogFactoryUtil.getLog(GroupWebDAVStorageImpl.class);

    public Resource getResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        this.verifyGroup(webDAVRequest);
        String path = this.getRootPath() + webDAVRequest.getPath();
        return new BaseResourceImpl(path, "", "");
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        this.verifyGroup(webDAVRequest);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        String path = this.getRootPath() + webDAVRequest.getPath();
        for (String token : WebDAVUtil.getStorageTokens()) {
            resources.add((Resource)new BaseResourceImpl(path, token, token));
        }
        return resources;
    }

    protected void verifyGroup(WebDAVRequest webDAVRequest) throws WebDAVException {
        String path;
        block3: {
            path = webDAVRequest.getPath();
            try {
                List groups = WebDAVUtil.getGroups((long)webDAVRequest.getUserId());
                for (Group group : groups) {
                    if (!path.equals(group.getFriendlyURL())) continue;
                    return;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        throw new WebDAVException("Invalid group for given credentials " + webDAVRequest.getRootPath() + path);
    }
}

