/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.PortalPreferenceValueUtil;
import com.liferay.portal.kernel.service.persistence.PortalPreferencesUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.simple.Element;
import com.liferay.portal.service.impl.PortalPreferenceValueLocalServiceImpl;
import com.liferay.portlet.PortalPreferenceKey;
import com.liferay.portlet.PreferencesValueUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.StaleStateException;
import org.hibernate.exception.ConstraintViolationException;

public class PortalPreferencesImpl
implements Cloneable,
PortalPreferences,
Serializable {
    public static final TransactionConfig SUPPORTS_TRANSACTION_CONFIG;
    private static final String _RANDOM_KEY = "r";
    private static final Log _log;
    private Map<PortalPreferenceKey, String[]> _modifiedPreferences;
    private Map<PortalPreferenceKey, String[]> _originalPreferences;
    private final long _ownerId;
    private final int _ownerType;
    private boolean _signedIn;
    private long _userId;

    public PortalPreferencesImpl() {
        this(0L, 0, Collections.emptyMap(), false);
    }

    public PortalPreferencesImpl(long ownerId, int ownerType, Map<PortalPreferenceKey, String[]> preferences, boolean signedIn) {
        this._ownerId = ownerId;
        this._ownerType = ownerType;
        this._signedIn = signedIn;
        this._originalPreferences = preferences;
    }

    public PortalPreferencesImpl clone() {
        return new PortalPreferencesImpl(this.getOwnerId(), this.getOwnerType(), new HashMap<PortalPreferenceKey, String[]>(this.getPreferences()), this.isSignedIn());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PortalPreferencesImpl)) {
            return false;
        }
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)object;
        return this.getOwnerId() == portalPreferencesImpl.getOwnerId() && this.getOwnerType() == portalPreferencesImpl.getOwnerType() && Objects.equals(this.getPreferences(), portalPreferencesImpl.getPreferences());
    }

    public Map<String, String[]> getMap(String namespace) {
        Map<PortalPreferenceKey, String[]> preferences = this.getPreferences();
        if (preferences.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String[]> preferenceMap = new HashMap<String, String[]>();
        for (Map.Entry<PortalPreferenceKey, String[]> entry : preferences.entrySet()) {
            PortalPreferenceKey portalPreferenceKey = entry.getKey();
            if (!portalPreferenceKey.matchNamespace(namespace)) continue;
            preferenceMap.put(portalPreferenceKey.getKey(), entry.getValue());
        }
        return preferenceMap;
    }

    public Enumeration<String> getNames(String namespace) {
        Map<String, String[]> preferences = this.getMap(namespace);
        return Collections.enumeration(preferences.keySet());
    }

    public long getOwnerId() {
        return this._ownerId;
    }

    public int getOwnerType() {
        return this._ownerType;
    }

    public Map<PortalPreferenceKey, String[]> getPreferences() {
        if (this._modifiedPreferences != null) {
            return this._modifiedPreferences;
        }
        return this._originalPreferences;
    }

    public long getUserId() {
        return this._userId;
    }

    public String getValue(String namespace, String key) {
        return this.getValue(namespace, key, null);
    }

    public String getValue(String namespace, String key, String defaultValue) {
        Map<PortalPreferenceKey, String[]> preferences = this.getPreferences();
        String[] values = preferences.get(new PortalPreferenceKey(namespace, key));
        if (PreferencesValueUtil.isNull(values)) {
            return defaultValue;
        }
        return PreferencesValueUtil.getActualValue(values[0]);
    }

    public String[] getValues(String namespace, String key) {
        return this.getValues(namespace, key, null);
    }

    public String[] getValues(String namespace, String key, String[] defaultValue) {
        return this._getValues(new PortalPreferenceKey(namespace, key), defaultValue);
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (long)this.getOwnerId());
        hashCode = HashUtil.hash((int)hashCode, (int)this.getOwnerType());
        hashCode = HashUtil.hash((int)hashCode, this.getPreferences());
        return hashCode;
    }

    public boolean isSignedIn() {
        return this._signedIn;
    }

    public void reset(String namespace, String key) {
        PortalPreferenceKey portalPreferenceKey = new PortalPreferenceKey(namespace, key);
        String[] values = this._getValues(portalPreferenceKey, null);
        if (values == null) {
            return;
        }
        Runnable runnable = () -> {
            Map<PortalPreferenceKey, String[]> modifiedPreferences = this._getModifiedPreferences();
            modifiedPreferences.remove(portalPreferenceKey);
        };
        try {
            this._retryableStore(runnable, portalPreferenceKey);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            throw concurrentModificationException;
        }
        catch (Throwable throwable) {
            _log.error((Object)throwable, throwable);
        }
    }

    public void resetValues(String namespace) {
        Map<PortalPreferenceKey, String[]> preferences = this.getPreferences();
        try {
            for (Map.Entry<PortalPreferenceKey, String[]> entry : preferences.entrySet()) {
                PortalPreferenceKey portalPreferenceKey = entry.getKey();
                if (!portalPreferenceKey.matchNamespace(namespace)) continue;
                this.reset(namespace, portalPreferenceKey.getKey());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            throw concurrentModificationException;
        }
        catch (Throwable throwable) {
            _log.error((Object)throwable, throwable);
        }
    }

    public void setSignedIn(boolean signedIn) {
        this._signedIn = signedIn;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setValue(String namespace, String key, String value) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        try {
            if (value == null) {
                this.reset(namespace, key);
                return;
            }
            PortalPreferenceKey portalPreferenceKey = new PortalPreferenceKey(namespace, key);
            String[] oldValues = this._getValues(portalPreferenceKey, null);
            if (oldValues != null && oldValues.length == 1 && value.equals(oldValues[0])) {
                return;
            }
            Runnable runnable = () -> {
                Map<PortalPreferenceKey, String[]> modifiedPreferences = this._getModifiedPreferences();
                modifiedPreferences.put(portalPreferenceKey, new String[]{PreferencesValueUtil.getXMLSafeValue(value)});
            };
            if (this._signedIn) {
                this._retryableStore(runnable, portalPreferenceKey);
            } else {
                runnable.run();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            throw concurrentModificationException;
        }
        catch (Throwable throwable) {
            _log.error((Object)throwable, throwable);
        }
    }

    public void setValues(String namespace, String key, String[] values) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        try {
            Set oldValuesSet;
            Set valuesSet;
            if (values == null) {
                this.reset(namespace, key);
                return;
            }
            if (values.length == 1) {
                this.setValue(namespace, key, values[0]);
                return;
            }
            PortalPreferenceKey keyEntry = new PortalPreferenceKey(namespace, key);
            Object[] oldValues = this._getValues(keyEntry, null);
            if (oldValues != null && (valuesSet = SetUtil.fromArray((Object[])values)).equals(oldValuesSet = SetUtil.fromArray((Object[])oldValues))) {
                return;
            }
            Runnable runnable = () -> {
                Map<PortalPreferenceKey, String[]> modifiedPreferences = this._getModifiedPreferences();
                modifiedPreferences.put(keyEntry, PreferencesValueUtil.getXMLSafeValues(values));
            };
            if (this._signedIn) {
                this._retryableStore(runnable, keyEntry);
            } else {
                runnable.run();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            throw concurrentModificationException;
        }
        catch (Throwable throwable) {
            _log.error((Object)throwable, throwable);
        }
    }

    public int size() {
        Map<PortalPreferenceKey, String[]> preferences = this.getPreferences();
        return preferences.size();
    }

    public void store() throws IOException {
        try {
            PortalPreferencesLocalServiceUtil.updatePreferences((long)this.getOwnerId(), (int)this.getOwnerType(), (PortalPreferences)this);
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public String toXML() {
        Map<PortalPreferenceKey, String[]> preferences = this.getPreferences();
        if (preferences == null || preferences.isEmpty()) {
            return "<portlet-preferences />";
        }
        Element portletPreferencesElement = new Element("portlet-preferences", false);
        for (Map.Entry<PortalPreferenceKey, String[]> entry : preferences.entrySet()) {
            PortalPreferenceKey portalPreferenceKey = entry.getKey();
            Element preferenceElement = portletPreferencesElement.addElement("preference");
            preferenceElement.addElement("name", portalPreferenceKey.getNamespacedKey());
            for (String value : entry.getValue()) {
                preferenceElement.addElement("value", value);
            }
        }
        return portletPreferencesElement.toXMLString();
    }

    private Map<PortalPreferenceKey, String[]> _getModifiedPreferences() {
        if (this._modifiedPreferences == null) {
            this._modifiedPreferences = new ConcurrentHashMap<PortalPreferenceKey, String[]>(this._originalPreferences);
        }
        return this._modifiedPreferences;
    }

    private String[] _getValues(PortalPreferenceKey portalPreferenceKey, String[] def) {
        Map<PortalPreferenceKey, String[]> preferences = this.getPreferences();
        String[] values = preferences.get(portalPreferenceKey);
        if (PreferencesValueUtil.isNull(values)) {
            return def;
        }
        return PreferencesValueUtil.getActualValues(values);
    }

    private boolean _isCausedByConcurrentModification(Throwable throwable) {
        Throwable causeThrowable = throwable.getCause();
        while (throwable != causeThrowable) {
            if (throwable instanceof ConstraintViolationException || throwable instanceof StaleStateException) {
                return true;
            }
            if (causeThrowable == null) {
                return false;
            }
            throwable = causeThrowable;
            causeThrowable = throwable.getCause();
        }
        return false;
    }

    private Map<PortalPreferenceKey, String[]> _reloadPreferenceMap() {
        com.liferay.portal.kernel.model.PortalPreferences portalPreferences = PortalPreferencesUtil.fetchByO_O((long)this.getOwnerId(), (int)this.getOwnerType(), (boolean)false);
        if (portalPreferences == null) {
            return null;
        }
        return PortalPreferenceValueLocalServiceImpl.getPreferenceMap(PortalPreferenceValueUtil.getPersistence(), portalPreferences.getPortalPreferencesId(), false);
    }

    private void _retryableStore(Runnable runnable, PortalPreferenceKey portalPreferenceKey) throws Throwable {
        Object[] originalValues = this._getValues(portalPreferenceKey, null);
        while (true) {
            try {
                runnable.run();
                this.store();
                return;
            }
            catch (Exception exception) {
                if (this._isCausedByConcurrentModification(exception)) {
                    Map preferenceMap = (Map)TransactionInvokerUtil.invoke((TransactionConfig)SUPPORTS_TRANSACTION_CONFIG, this::_reloadPreferenceMap);
                    if (preferenceMap == null) continue;
                    Object values = (String[])preferenceMap.get(portalPreferenceKey);
                    values = PreferencesValueUtil.isNull((String[])values) ? null : PreferencesValueUtil.getActualValues((String[])values);
                    if (!Arrays.equals(originalValues, values)) {
                        throw new ConcurrentModificationException();
                    }
                    this._modifiedPreferences = null;
                    this._originalPreferences = preferenceMap;
                    continue;
                }
                throw exception;
            }
            break;
        }
    }

    static {
        TransactionConfig.Builder builder = new TransactionConfig.Builder();
        builder.setPropagation(Propagation.SUPPORTS);
        builder.setReadOnly(true);
        builder.setRollbackForClasses(new Class[]{PortalException.class, SystemException.class});
        SUPPORTS_TRANSACTION_CONFIG = builder.build();
        _log = LogFactoryUtil.getLog(PortalPreferencesImpl.class);
    }
}

