/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence.impl;

import com.liferay.asset.kernel.configuration.provider.AssetCategoryConfigurationProviderUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryFinder;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.model.impl.AssetEntryImpl;
import com.liferay.portlet.asset.service.persistence.impl.AssetEntryFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class AssetEntryFinderImpl
extends AssetEntryFinderBaseImpl
implements AssetEntryFinder {
    public static final String FIND_BY_AND_CATEGORY_IDS = AssetEntryFinder.class.getName() + ".findByAndCategoryIds";
    public static final String FIND_BY_AND_TAG_IDS = AssetEntryFinder.class.getName() + ".findByAndTagIds";

    public int countEntries(AssetEntryQuery entryQuery) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            SQLQuery sqlQuery = this.buildAssetQuerySQL(entryQuery, true, session);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AssetEntry> findEntries(AssetEntryQuery entryQuery) {
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = this.buildAssetQuerySQL(entryQuery, false, session);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)entryQuery.getStart(), (int)entryQuery.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected void buildAllCategoriesSQL(long[] categoryIds, StringBundler sb) {
        String findByAndCategoryIdsSQL = CustomSQLUtil.get((String)FIND_BY_AND_CATEGORY_IDS);
        sb.append(" AND (");
        for (int i = 0; i < categoryIds.length; ++i) {
            List<Long> treeCategoryIds;
            String sql = null;
            if (AssetCategoryConfigurationProviderUtil.isSearchHierarchical((long)CompanyThreadLocal.getCompanyId()) && (treeCategoryIds = this.getSubcategoryIds(categoryIds[i])).size() > 1) {
                sql = StringUtil.replace((String)findByAndCategoryIdsSQL, (String)"[$CATEGORY_ID$]", (String)StringUtil.merge(treeCategoryIds));
            }
            if (sql == null) {
                sql = StringUtil.replace((String)findByAndCategoryIdsSQL, (String)" IN ([$CATEGORY_ID$])", (String)(" = " + categoryIds[i]));
            }
            sb.append(sql);
            if (i + 1 >= categoryIds.length) continue;
            sb.append(" AND ");
        }
        sb.append(")");
    }

    protected void buildAllTagsSQL(long[][] tagIds, StringBundler sb) {
        int i;
        sb.append(" AND AssetEntry.entryId IN (");
        for (i = 0; i < tagIds.length; ++i) {
            String sql = CustomSQLUtil.get((String)FIND_BY_AND_TAG_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$TAG_ID$]", (String)this.getTagIds(tagIds[i]));
            sb.append(sql);
            if (i + 1 >= tagIds.length) continue;
            sb.append(" AND AssetEntry.entryId IN (");
        }
        for (i = 0; i < tagIds.length; ++i) {
            if (i + 1 >= tagIds.length) continue;
            sb.append(")");
        }
        sb.append(")");
    }

    protected void buildAnyCategoriesSQL(long[] categoryIds, StringBundler sb) {
        String categoryIdsString = null;
        if (AssetCategoryConfigurationProviderUtil.isSearchHierarchical((long)CompanyThreadLocal.getCompanyId())) {
            ArrayList<Long> categoryIdsList = new ArrayList<Long>();
            for (long categoryId : categoryIds) {
                categoryIdsList.addAll(this.getSubcategoryIds(categoryId));
            }
            if (categoryIdsList.isEmpty()) {
                return;
            }
            categoryIdsString = StringUtil.merge(categoryIdsList);
        } else {
            categoryIdsString = StringUtil.merge((long[])categoryIds);
        }
        sb.append(" AND (");
        String sql = CustomSQLUtil.get((String)FIND_BY_AND_CATEGORY_IDS);
        sb.append(StringUtil.replace((String)sql, (String)"[$CATEGORY_ID$]", (String)categoryIdsString));
        sb.append(")");
    }

    protected String buildAnyTagsSQL(long[] tagIds, StringBundler sb) {
        sb.append(" AND (");
        for (int i = 0; i < tagIds.length; ++i) {
            sb.append("AssetTag.tagId = ");
            sb.append(tagIds[i]);
            if (i + 1 == tagIds.length) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }

    protected SQLQuery buildAssetQuerySQL(AssetEntryQuery entryQuery, boolean count, Session session) {
        String where;
        String linkedAssetEntryIdsSQL;
        StringBundler sb = new StringBundler(77);
        if (count) {
            sb.append("SELECT COUNT(DISTINCT AssetEntry.entryId) AS ");
            sb.append("COUNT_VALUE ");
        } else {
            sb.append("SELECT {AssetEntry.*} ");
            boolean selectRatings = false;
            boolean selectViewCount = false;
            String orderByCol1 = entryQuery.getOrderByCol1();
            String[] orderByCol2 = entryQuery.getOrderByCol2();
            if (orderByCol1.equals("ratings") || orderByCol2.equals("ratings") || orderByCol1.equals("ratingsTotalScore") || orderByCol2.equals("ratingsTotalScore")) {
                selectRatings = true;
                sb.append(", TEMP_TABLE_ASSET_ENTRY.averageScore, ");
                sb.append("TEMP_TABLE_ASSET_ENTRY.totalScore ");
            }
            if (orderByCol1.equals("viewCount") || orderByCol2.equals("viewCount")) {
                selectViewCount = true;
                sb.append(", TEMP_TABLE_ASSET_ENTRY.viewCount ");
            }
            sb.append("FROM (SELECT DISTINCT AssetEntry.entryId ");
            if (selectRatings) {
                sb.append(", RatingsStats.averageScore, ");
                sb.append(" RatingsStats.totalScore ");
            }
            if (selectViewCount) {
                sb.append(", ViewCountEntry.viewCount ");
            }
        }
        sb.append("FROM AssetEntry ");
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getAnyTagIds())) {
            sb.append("INNER JOIN AssetEntries_AssetTags ON ");
            sb.append("(AssetEntries_AssetTags.entryId = AssetEntry.entryId) ");
            sb.append("INNER JOIN AssetTag ON (AssetTag.tagId = ");
            sb.append("AssetEntries_AssetTags.tagId) ");
        }
        if (Validator.isNotNull((String)(linkedAssetEntryIdsSQL = this._getLinkedAssetEntryIdsSQL(entryQuery)))) {
            sb.append("INNER JOIN (SELECT AssetLink.entryId1 AS entryId ");
            sb.append("FROM AssetLink WHERE AssetLink.entryId2 IN ");
            sb.append(linkedAssetEntryIdsSQL);
            sb.append("AND AssetLink.entryId1 NOT IN ");
            sb.append(linkedAssetEntryIdsSQL);
            sb.append("UNION SELECT AssetLink.entryId2 AS entryId FROM ");
            sb.append("AssetLink WHERE AssetLink.entryId1 IN ");
            sb.append(linkedAssetEntryIdsSQL);
            sb.append(" AND AssetLink.entryId2 NOT IN ");
            sb.append(linkedAssetEntryIdsSQL);
            sb.append(" ) TEMP_TABLE_ASSET_LINK ON ");
            sb.append("(TEMP_TABLE_ASSET_LINK.entryId = AssetEntry.entryId) ");
        }
        if (entryQuery.isExcludeZeroViewCount()) {
            sb.append("INNER JOIN ViewCountEntry ON (");
            sb.append("ViewCountEntry.companyId = AssetEntry.companyId) AND ");
            sb.append("(ViewCountEntry.classNameId = ");
            sb.append(ClassNameLocalServiceUtil.getClassNameId(AssetEntry.class));
            sb.append(") AND (ViewCountEntry.classPK = AssetEntry.entryId) ");
            sb.append("AND (ViewCountEntry.viewCount > 0) ");
        }
        String orderByCol1 = AssetEntryQuery.ORDER_BY_COLUMNS[2];
        String orderByCol2 = AssetEntryQuery.ORDER_BY_COLUMNS[2];
        for (String orderByColumn : AssetEntryQuery.ORDER_BY_COLUMNS) {
            if (orderByColumn.equals(entryQuery.getOrderByCol1())) {
                orderByCol1 = orderByColumn;
            }
            if (!orderByColumn.equals(entryQuery.getOrderByCol2())) continue;
            orderByCol2 = orderByColumn;
        }
        if (orderByCol1.equals("ratings") || orderByCol2.equals("ratings") || orderByCol1.equals("ratingsTotalScore") || orderByCol2.equals("ratingsTotalScore")) {
            sb.append(" LEFT JOIN RatingsStats ON (RatingsStats.classNameId ");
            sb.append("= AssetEntry.classNameId) AND (RatingsStats.classPK = ");
            sb.append("AssetEntry.classPK)");
        }
        if (!entryQuery.isExcludeZeroViewCount() && (orderByCol1.equals("viewCount") || orderByCol2.equals("viewCount"))) {
            sb.append(" LEFT JOIN ViewCountEntry ON ");
            sb.append("(ViewCountEntry.companyId = AssetEntry.companyId) AND ");
            sb.append("(ViewCountEntry.classNameId = ");
            sb.append(ClassNameLocalServiceUtil.getClassNameId(AssetEntry.class));
            sb.append(") AND (ViewCountEntry.classPK = AssetEntry.entryId) ");
        }
        sb.append("WHERE ");
        int whereIndex = sb.index();
        if (Validator.isNotNull((String)linkedAssetEntryIdsSQL)) {
            sb.append(" AND (AssetEntry.entryId NOT IN ");
            sb.append(linkedAssetEntryIdsSQL);
            sb.append(" )");
        }
        if (entryQuery.isListable() != null) {
            sb.append(" AND (listable = ?)");
        }
        if (entryQuery.isVisible() != null) {
            sb.append(" AND (visible = ?)");
        }
        if (Validator.isNotNull((String)entryQuery.getKeywords())) {
            sb.append(" AND ((AssetEntry.userName LIKE ?) OR ");
            sb.append("(AssetEntry.title LIKE ?) OR (AssetEntry.description ");
            sb.append("LIKE ?))");
        } else if (Validator.isNotNull((String)entryQuery.getUserName()) || Validator.isNotNull((String)entryQuery.getTitle()) || Validator.isNotNull((String)entryQuery.getDescription())) {
            sb.append(" AND (");
            boolean requiresOperator = false;
            if (Validator.isNotNull((String)entryQuery.getUserName())) {
                sb.append("(AssetEntry.userName LIKE ?)");
                requiresOperator = true;
            }
            if (Validator.isNotNull((String)entryQuery.getTitle())) {
                if (requiresOperator) {
                    sb.append(entryQuery.isAndOperator() ? " AND " : " OR ");
                }
                sb.append("(AssetEntry.title LIKE ?)");
                requiresOperator = true;
            }
            if (Validator.isNotNull((String)entryQuery.getDescription())) {
                if (requiresOperator) {
                    sb.append(entryQuery.isAndOperator() ? " AND " : " OR ");
                }
                sb.append("(AssetEntry.description LIKE ?)");
            }
            sb.append(")");
        }
        Layout layout = entryQuery.getLayout();
        if (layout != null) {
            sb.append(" AND (AssetEntry.layoutUuid = ?)");
        }
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getAllCategoryIds())) {
            this.buildAllCategoriesSQL(entryQuery.getAllCategoryIds(), sb);
        }
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getAnyCategoryIds())) {
            this.buildAnyCategoriesSQL(entryQuery.getAnyCategoryIds(), sb);
        }
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getNotAllCategoryIds())) {
            this.buildNotAllCategoriesSQL(entryQuery.getNotAllCategoryIds(), sb);
        }
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getNotAnyCategoryIds())) {
            this.buildNotAnyCategoriesSQL(entryQuery.getNotAnyCategoryIds(), sb);
        }
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getClassTypeIds())) {
            this.buildClassTypeIdsSQL(entryQuery.getClassTypeIds(), sb);
        }
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getAllTagIds())) {
            this.buildAllTagsSQL(entryQuery.getAllTagIdsArray(), sb);
        }
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getAnyTagIds())) {
            this.buildAnyTagsSQL(entryQuery.getAnyTagIds(), sb);
        }
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getNotAllTagIds())) {
            this.buildNotAllTagsSQL(entryQuery.getNotAllTagIdsArray(), sb);
        }
        if (ArrayUtil.isNotEmpty((long[])entryQuery.getNotAnyTagIds())) {
            this.buildNotAnyTagsSQL(entryQuery.getNotAnyTagIds(), sb);
        }
        sb.append(this.getDates(entryQuery.getPublishDate(), entryQuery.getExpirationDate()));
        sb.append(this.getGroupIds(entryQuery.getGroupIds()));
        sb.append(this.getClassNameIds(entryQuery.getClassNameIds()));
        if (!count) {
            sb.append(") TEMP_TABLE_ASSET_ENTRY INNER JOIN ");
            sb.append("AssetEntry AssetEntry ON ");
            sb.append("TEMP_TABLE_ASSET_ENTRY.entryId = ");
            sb.append("AssetEntry.entryId ORDER BY ");
            if (orderByCol1.equals("ratings")) {
                sb.append("CASE WHEN TEMP_TABLE_ASSET_ENTRY.averageScore ");
                sb.append("IS NULL THEN 0 ");
                sb.append("ELSE TEMP_TABLE_ASSET_ENTRY.averageScore END ");
                sb.append(entryQuery.getOrderByType1());
                sb.append(", CASE WHEN TEMP_TABLE_ASSET_ENTRY.totalScore ");
                sb.append("IS NULL THEN 0 ");
                sb.append("ELSE TEMP_TABLE_ASSET_ENTRY.totalScore END");
            } else if (orderByCol1.equals("ratingsTotalScore")) {
                sb.append("CASE WHEN TEMP_TABLE_ASSET_ENTRY.totalScore ");
                sb.append("IS NULL THEN 0 ");
                sb.append("ELSE TEMP_TABLE_ASSET_ENTRY.totalScore END ");
                sb.append(entryQuery.getOrderByType1());
                sb.append(", CASE WHEN TEMP_TABLE_ASSET_ENTRY.averageScore ");
                sb.append("IS NULL THEN 0 ");
                sb.append("ELSE TEMP_TABLE_ASSET_ENTRY.averageScore END");
            } else if (orderByCol1.equals("title")) {
                sb.append("CAST_CLOB_TEXT(AssetEntry.title)");
            } else if (orderByCol1.equals("viewCount")) {
                sb.append("CASE WHEN TEMP_TABLE_ASSET_ENTRY.viewCount ");
                sb.append("IS NULL THEN 0 ");
                sb.append("ELSE TEMP_TABLE_ASSET_ENTRY.viewCount END");
            } else {
                sb.append("AssetEntry.");
                sb.append(orderByCol1);
            }
            sb.append(" ");
            sb.append(entryQuery.getOrderByType1());
            if (Validator.isNotNull((String)orderByCol2) && !orderByCol1.equals(orderByCol2)) {
                if (orderByCol2.equals("ratings")) {
                    sb.append(", CASE WHEN ");
                    sb.append("TEMP_TABLE_ASSET_ENTRY.averageScore IS NULL ");
                    sb.append("THEN 0 ELSE ");
                    sb.append("TEMP_TABLE_ASSET_ENTRY.averageScore END ");
                    sb.append(entryQuery.getOrderByType2());
                    sb.append(", CASE WHEN TEMP_TABLE_ASSET_ENTRY.totalScore ");
                    sb.append("IS NULL THEN 0 ");
                    sb.append("ELSE TEMP_TABLE_ASSET_ENTRY.totalScore END");
                } else if (orderByCol2.equals("ratingsTotalScore")) {
                    sb.append(", CASE WHEN TEMP_TABLE_ASSET_ENTRY.totalScore ");
                    sb.append("IS NULL THEN 0 ");
                    sb.append("ELSE TEMP_TABLE_ASSET_ENTRY.totalScore END ");
                    sb.append(entryQuery.getOrderByType2());
                    sb.append(", CASE WHEN ");
                    sb.append("TEMP_TABLE_ASSET_ENTRY.averageScore IS NULL ");
                    sb.append("THEN 0 ELSE ");
                    sb.append("TEMP_TABLE_ASSET_ENTRY.averageScore END");
                } else if (orderByCol2.equals("title")) {
                    sb.append(", CAST_CLOB_TEXT(AssetEntry.title)");
                } else if (orderByCol2.equals("viewCount")) {
                    sb.append(", CASE WHEN ");
                    sb.append("TEMP_TABLE_ASSET_ENTRY.viewCount IS NULL ");
                    sb.append("THEN 0 ELSE ");
                    sb.append("TEMP_TABLE_ASSET_ENTRY.viewCount END");
                } else {
                    sb.append(", AssetEntry.");
                    sb.append(orderByCol2);
                }
                sb.append(" ");
                sb.append(entryQuery.getOrderByType2());
            }
        }
        if (sb.index() > whereIndex && (where = sb.stringAt(whereIndex)).startsWith(" AND")) {
            sb.setStringAt(where.substring(4), whereIndex);
        }
        String sql = sb.toString();
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        if (count) {
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
        } else {
            sqlQuery.addEntity("AssetEntry", AssetEntryImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        if (entryQuery.isListable() != null) {
            queryPos.add(entryQuery.isListable());
        }
        if (entryQuery.isVisible() != null) {
            queryPos.add(entryQuery.isVisible());
        }
        if (Validator.isNotNull((String)entryQuery.getKeywords())) {
            queryPos.add(StringUtil.quote((String)entryQuery.getKeywords(), (String)"%"));
            queryPos.add(StringUtil.quote((String)entryQuery.getKeywords(), (String)"%"));
            queryPos.add(StringUtil.quote((String)entryQuery.getKeywords(), (String)"%"));
        } else {
            if (Validator.isNotNull((String)entryQuery.getUserName())) {
                queryPos.add(StringUtil.quote((String)entryQuery.getUserName(), (String)"%"));
            }
            if (Validator.isNotNull((String)entryQuery.getTitle())) {
                queryPos.add(StringUtil.quote((String)entryQuery.getTitle(), (String)"%"));
            }
            if (Validator.isNotNull((String)entryQuery.getDescription())) {
                queryPos.add(StringUtil.quote((String)entryQuery.getDescription(), (String)"%"));
            }
        }
        if (layout != null) {
            queryPos.add(layout.getUuid());
        }
        this.setDates(queryPos, entryQuery.getPublishDate(), entryQuery.getExpirationDate());
        queryPos.add(entryQuery.getGroupIds());
        queryPos.add(entryQuery.getClassNameIds());
        return sqlQuery;
    }

    protected void buildClassTypeIdsSQL(long[] classTypeIds, StringBundler sb) {
        sb.append(" AND (");
        for (int i = 0; i < classTypeIds.length; ++i) {
            sb.append(" AssetEntry.classTypeId = ");
            sb.append(classTypeIds[i]);
            if (i + 1 < classTypeIds.length) {
                sb.append(" OR ");
                continue;
            }
            sb.append(")");
        }
    }

    protected void buildNotAllCategoriesSQL(long[] categoryIds, StringBundler sb) {
        String findByAndCategoryIdsSQL = CustomSQLUtil.get((String)FIND_BY_AND_CATEGORY_IDS);
        sb.append(" AND (");
        for (int i = 0; i < categoryIds.length; ++i) {
            List<Long> treeCategoryIds;
            sb.append("NOT ");
            String sql = null;
            if (AssetCategoryConfigurationProviderUtil.isSearchHierarchical((long)CompanyThreadLocal.getCompanyId()) && (treeCategoryIds = this.getSubcategoryIds(categoryIds[i])).size() > 1) {
                sql = StringUtil.replace((String)findByAndCategoryIdsSQL, (String)"[$CATEGORY_ID$]", (String)StringUtil.merge(treeCategoryIds));
            }
            if (sql == null) {
                sql = StringUtil.replace((String)findByAndCategoryIdsSQL, (String)" IN ([$CATEGORY_ID$])", (String)(" = " + categoryIds[i]));
            }
            sb.append(sql);
            if (i + 1 >= categoryIds.length) continue;
            sb.append(" OR ");
        }
        sb.append(")");
    }

    protected void buildNotAllTagsSQL(long[][] tagIds, StringBundler sb) {
        sb.append(" AND (");
        for (int i = 0; i < tagIds.length; ++i) {
            sb.append("AssetEntry.entryId NOT IN (");
            String sql = CustomSQLUtil.get((String)FIND_BY_AND_TAG_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$TAG_ID$]", (String)this.getTagIds(tagIds[i]));
            sb.append(sql);
            sb.append(")");
            if (i + 1 >= tagIds.length || tagIds[i + 1].length <= 0) continue;
            sb.append(" OR ");
        }
        sb.append(")");
    }

    protected void buildNotAnyCategoriesSQL(long[] notCategoryIds, StringBundler sb) {
        sb.append(" AND (NOT ");
        String sql = CustomSQLUtil.get((String)FIND_BY_AND_CATEGORY_IDS);
        String notCategoryIdsString = null;
        if (AssetCategoryConfigurationProviderUtil.isSearchHierarchical((long)CompanyThreadLocal.getCompanyId())) {
            ArrayList<Long> notCategoryIdsList = new ArrayList<Long>();
            for (long notCategoryId : notCategoryIds) {
                notCategoryIdsList.addAll(this.getSubcategoryIds(notCategoryId));
            }
            notCategoryIdsString = StringUtil.merge(notCategoryIdsList);
        } else {
            notCategoryIdsString = StringUtil.merge((long[])notCategoryIds);
        }
        sb.append(StringUtil.replace((String)sql, (String)"[$CATEGORY_ID$]", (String)notCategoryIdsString));
        sb.append(")");
    }

    protected String buildNotAnyTagsSQL(long[] notTagIds, StringBundler sb) {
        sb.append(" AND (");
        for (int i = 0; i < notTagIds.length; ++i) {
            sb.append("AssetEntry.entryId NOT IN (");
            String sql = CustomSQLUtil.get((String)FIND_BY_AND_TAG_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$TAG_ID$]", (String)this.getTagIds(notTagIds));
            sb.append(sql);
            sb.append(")");
            if (i + 1 >= notTagIds.length) continue;
            sb.append(" AND ");
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getClassNameIds(long[] classNameIds) {
        if (classNameIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(classNameIds.length + 1);
        sb.append(" AND (AssetEntry.classNameId = ?");
        for (int i = 0; i < classNameIds.length - 1; ++i) {
            sb.append(" OR AssetEntry.classNameId = ?");
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getDates(Date publishDate, Date expirationDate) {
        StringBundler sb = new StringBundler(4);
        if (publishDate != null) {
            sb.append(" AND (AssetEntry.publishDate IS NULL OR ");
            sb.append("AssetEntry.publishDate < ?)");
        }
        if (expirationDate != null) {
            sb.append(" AND (AssetEntry.expirationDate IS NULL OR ");
            sb.append("AssetEntry.expirationDate > ?)");
        }
        return sb.toString();
    }

    protected String getGroupIds(long[] groupIds) {
        if (groupIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(groupIds.length + 1);
        sb.append(" AND (AssetEntry.groupId = ?");
        for (int i = 0; i < groupIds.length - 1; ++i) {
            sb.append(" OR AssetEntry.groupId = ?");
        }
        sb.append(")");
        return sb.toString();
    }

    protected List<Long> getSubcategoryIds(long parentCategoryId) {
        AssetCategory parentAssetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)parentCategoryId);
        if (parentAssetCategory == null) {
            return Collections.emptyList();
        }
        return ListUtil.toList((List)AssetCategoryLocalServiceUtil.getDescendantCategories((AssetCategory)parentAssetCategory), (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    protected String getTagIds(long[] tagIds) {
        StringBundler sb = new StringBundler(tagIds.length * 3 - 1);
        for (int i = 0; i < tagIds.length; ++i) {
            sb.append("tagId = ");
            sb.append(tagIds[i]);
            if (i + 1 == tagIds.length) continue;
            sb.append(" OR ");
        }
        return sb.toString();
    }

    protected void setDates(QueryPos queryPos, Date publishDate, Date expirationDate) {
        if (publishDate != null) {
            Timestamp publishDate_TS = CalendarUtil.getTimestamp((Date)publishDate);
            queryPos.add(publishDate_TS);
        }
        if (expirationDate != null) {
            Timestamp expirationDate_TS = CalendarUtil.getTimestamp((Date)expirationDate);
            queryPos.add(expirationDate_TS);
        }
    }

    private String _getLinkedAssetEntryIdsSQL(AssetEntryQuery entryQuery) {
        if (ArrayUtil.isEmpty((long[])entryQuery.getLinkedAssetEntryIds())) {
            return null;
        }
        StringBundler sb = new StringBundler();
        sb.append(" (");
        long[] linkedAssetEntryIds = entryQuery.getLinkedAssetEntryIds();
        for (int i = 0; i < linkedAssetEntryIds.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(linkedAssetEntryIds[i]);
        }
        sb.append(") ");
        return sb.toString();
    }
}

