/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureLinkManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryMetadataLocalServiceBaseImpl;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DLFileEntryMetadataLocalServiceImpl
extends DLFileEntryMetadataLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=DLFileEntryTypeLocalService.class)
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;

    public void deleteFileEntryMetadata(DLFileEntryMetadata fileEntryMetadata) throws PortalException {
        this.dlFileEntryMetadataPersistence.remove((BaseModel)fileEntryMetadata);
        StorageEngineManagerUtil.deleteByClass((long)fileEntryMetadata.getDDMStorageId());
        DDMStructureLinkManagerUtil.deleteStructureLinks((long)this._classNameLocalService.getClassNameId(DLFileEntryMetadata.class), (long)fileEntryMetadata.getFileEntryMetadataId());
    }

    public void deleteFileEntryMetadata(long fileEntryId) throws PortalException {
        List fileEntryMetadatas = this.dlFileEntryMetadataPersistence.findByFileEntryId(fileEntryId);
        for (DLFileEntryMetadata fileEntryMetadata : fileEntryMetadatas) {
            this.deleteFileEntryMetadata(fileEntryMetadata);
        }
    }

    public void deleteFileEntryMetadataByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        this.deleteFileEntryMetadata(this.dlFileEntryMetadataLocalService.getDLFileEntryMetadataByExternalReferenceCode(externalReferenceCode, companyId));
    }

    public void deleteFileVersionFileEntryMetadata(long fileVersionId) throws PortalException {
        List fileEntryMetadatas = this.dlFileEntryMetadataPersistence.findByFileVersionId(fileVersionId);
        for (DLFileEntryMetadata fileEntryMetadata : fileEntryMetadatas) {
            this.deleteFileEntryMetadata(fileEntryMetadata);
        }
    }

    public DLFileEntryMetadata fetchFileEntryMetadata(long fileEntryMetadataId) {
        return this.dlFileEntryMetadataPersistence.fetchByPrimaryKey(fileEntryMetadataId);
    }

    public DLFileEntryMetadata fetchFileEntryMetadata(long ddmStructureId, long fileVersionId) {
        return this.dlFileEntryMetadataPersistence.fetchByD_F(ddmStructureId, fileVersionId);
    }

    public DLFileEntryMetadata getFileEntryMetadata(long fileEntryMetadataId) throws PortalException {
        return this.dlFileEntryMetadataPersistence.findByPrimaryKey(fileEntryMetadataId);
    }

    public DLFileEntryMetadata getFileEntryMetadata(long ddmStructureId, long fileVersionId) throws PortalException {
        return this.dlFileEntryMetadataPersistence.findByD_F(ddmStructureId, fileVersionId);
    }

    public List<DLFileEntryMetadata> getFileVersionFileEntryMetadatas(long fileVersionId) {
        return this.dlFileEntryMetadataPersistence.findByFileVersionId(fileVersionId);
    }

    public long getFileVersionFileEntryMetadatasCount(long fileVersionId) {
        return this.dlFileEntryMetadataPersistence.countByFileVersionId(fileVersionId);
    }

    public List<DLFileEntryMetadata> getMismatchedCompanyIdFileEntryMetadatas() {
        return this.dlFileEntryMetadataFinder.findByMismatchedCompanyId();
    }

    public List<DLFileEntryMetadata> getNoStructuresFileEntryMetadatas() {
        return this.dlFileEntryMetadataFinder.findByNoStructures();
    }

    public void updateFileEntryMetadata(String externalReferenceCode, long companyId, List<DDMStructure> ddmStructures, long fileEntryId, long fileVersionId, Map<String, DDMFormValues> ddmFormValuesMap, ServiceContext serviceContext) throws PortalException {
        for (DDMStructure ddmStructure : ddmStructures) {
            DDMFormValues ddmFormValues = ddmFormValuesMap.get(ddmStructure.getStructureKey());
            if (ddmFormValues == null) continue;
            this.updateFileEntryMetadata(externalReferenceCode, companyId, ddmStructure, fileEntryId, fileVersionId, ddmFormValues, serviceContext);
        }
    }

    public void updateFileEntryMetadata(String externalReferenceCode, long fileEntryTypeId, long fileEntryId, long fileVersionId, Map<String, DDMFormValues> ddmFormValuesMap, ServiceContext serviceContext) throws PortalException {
        DLFileEntryType fileEntryType = this._dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
        this.updateFileEntryMetadata(externalReferenceCode, fileEntryType.getCompanyId(), fileEntryType.getDDMStructures(), fileEntryId, fileVersionId, ddmFormValuesMap, serviceContext);
    }

    protected void updateFileEntryMetadata(String externalReferenceCode, long companyId, DDMStructure ddmStructure, long fileEntryId, long fileVersionId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        DLFileEntryMetadata fileEntryMetadata = this.dlFileEntryMetadataPersistence.fetchByD_F(ddmStructure.getStructureId(), fileVersionId);
        if (fileEntryMetadata != null) {
            if (!Objects.equals(fileEntryMetadata.getExternalReferenceCode(), externalReferenceCode)) {
                fileEntryMetadata.setExternalReferenceCode(externalReferenceCode);
                fileEntryMetadata = (DLFileEntryMetadata)this.dlFileEntryMetadataPersistence.update((BaseModel)fileEntryMetadata);
            }
            StorageEngineManagerUtil.update((long)fileEntryMetadata.getDDMStorageId(), (DDMFormValues)ddmFormValues, (ServiceContext)serviceContext);
        } else {
            long fileEntryMetadataId = this.counterLocalService.increment();
            fileEntryMetadata = this.dlFileEntryMetadataPersistence.create(fileEntryMetadataId);
            fileEntryMetadata.setExternalReferenceCode(externalReferenceCode);
            fileEntryMetadata.setDDMStorageId(StorageEngineManagerUtil.create((long)companyId, (long)ddmStructure.getStructureId(), (DDMFormValues)ddmFormValues, (ServiceContext)serviceContext));
            fileEntryMetadata.setDDMStructureId(ddmStructure.getStructureId());
            fileEntryMetadata.setFileEntryId(fileEntryId);
            fileEntryMetadata.setFileVersionId(fileVersionId);
            fileEntryMetadata = (DLFileEntryMetadata)this.dlFileEntryMetadataPersistence.update((BaseModel)fileEntryMetadata);
            DDMStructureLinkManagerUtil.addStructureLink((long)this._classNameLocalService.getClassNameId(DLFileEntryMetadata.class), (long)fileEntryMetadata.getFileEntryMetadataId(), (long)ddmStructure.getStructureId());
        }
    }
}

