/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.TicketLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.DefaultAdminUtil;
import com.liferay.portal.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.security.pwd.PwdToolkitUtilThreadLocal;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UpdatePasswordAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(UpdatePasswordAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Ticket ticket = this.getTicket(httpServletRequest);
        if (ticket != null && StringUtil.equals((String)httpServletRequest.getMethod(), (String)"GET")) {
            this.resendAsPost(httpServletRequest, httpServletResponse);
            return null;
        }
        httpServletRequest.setAttribute("TICKET", (Object)ticket);
        String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
        if (Validator.isNull((String)cmd)) {
            String reminderQueryAnswer;
            User user;
            if (ticket != null) {
                user = UserLocalServiceUtil.getUser((long)ticket.getClassPK());
                UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)true);
            }
            if ((user = PortalUtil.getUser((HttpServletRequest)httpServletRequest)) != null && this._isUserDefaultAdmin(user) && Validator.isNotNull((String)(reminderQueryAnswer = user.getReminderQueryAnswer())) && reminderQueryAnswer.equals("pending")) {
                httpServletRequest.setAttribute("TITLE_SET_PASSWORD", (Object)"set-password");
            }
            return actionMapping.getActionForward("portal.update_password");
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            this.updatePassword(httpServletRequest, httpServletResponse, themeDisplay, ticket);
            String redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"referer");
            if (Validator.isNotNull((String)redirect)) {
                redirect = PortalUtil.escapeRedirect((String)redirect);
            }
            if (Validator.isNull((String)redirect)) {
                redirect = themeDisplay.getPathMain();
            }
            httpServletResponse.sendRedirect(redirect);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof UserPasswordException) {
                SessionErrors.add((HttpServletRequest)httpServletRequest, exception.getClass(), (Object)exception);
                return actionMapping.getActionForward("portal.update_password");
            }
            if (exception instanceof NoSuchUserException || exception instanceof PrincipalException) {
                SessionErrors.add((HttpServletRequest)httpServletRequest, exception.getClass());
                return actionMapping.getActionForward("portal.error");
            }
            PortalUtil.sendError((Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return null;
        }
    }

    protected Ticket getTicket(HttpServletRequest httpServletRequest) throws PortalException {
        block5: {
            String ticketId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"ticketId");
            String ticketKey = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"ticketKey");
            if (Validator.isNull((String)ticketId) || Validator.isNull((String)ticketKey)) {
                return null;
            }
            try {
                Ticket ticket = TicketLocalServiceUtil.fetchTicket((long)GetterUtil.getLong((String)ticketId));
                if (ticket == null || ticket.getType() != 3) {
                    return null;
                }
                String encryptedTicketKey = PasswordEncryptorUtil.encrypt((String)ticketKey, (String)ticket.getKey());
                if (!ticket.isExpired() && encryptedTicketKey.equals(ticket.getKey())) {
                    return ticket;
                }
                TicketLocalServiceUtil.deleteTicket((Ticket)ticket);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        return null;
    }

    protected boolean isValidatePassword(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        Boolean setupWizardPasswordUpdated = (Boolean)httpSession.getAttribute("SETUP_WIZARD_PASSWORD_UPDATED");
        return setupWizardPasswordUpdated == null || setupWizardPasswordUpdated == false;
    }

    protected void resendAsPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpServletResponse.setHeader("Expires", "0");
        httpServletResponse.setHeader("Pragma", "no-cache");
        PrintWriter printWriter = httpServletResponse.getWriter();
        Map parameterMap = httpServletRequest.getParameterMap();
        StringBundler sb = new StringBundler(8 + parameterMap.size() * 5);
        sb.append("<html><body onload=\"document.fm.submit();\">");
        sb.append("<form action=\"");
        sb.append(PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest));
        sb.append(PortalUtil.getPathContext());
        sb.append("/c/portal/update_password\" method=\"post\" name=\"fm\">");
        for (String name : parameterMap.keySet()) {
            String value = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)name);
            sb.append("<input name=\"");
            sb.append(HtmlUtil.escapeAttribute((String)name));
            sb.append("\" type=\"hidden\" value=\"");
            sb.append(HtmlUtil.escapeAttribute((String)value));
            sb.append("\"/>");
        }
        sb.append("<noscript>");
        sb.append("<input type=\"submit\" value=\"Please continue here...\"/>");
        sb.append("</noscript></form></body></html>");
        printWriter.write(sb.toString());
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePassword(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ThemeDisplay themeDisplay, Ticket ticket) throws Exception {
        AuthTokenUtil.checkCSRFToken((HttpServletRequest)httpServletRequest, (String)UpdatePasswordAction.class.getName());
        HttpSession httpSession = httpServletRequest.getSession();
        long userId = 0L;
        userId = ticket != null ? ticket.getClassPK() : themeDisplay.getUserId();
        String password1 = httpServletRequest.getParameter("password1");
        String password2 = httpServletRequest.getParameter("password2");
        boolean passwordReset = false;
        boolean previousValidate = PwdToolkitUtilThreadLocal.isValidate();
        try {
            boolean currentValidate = this.isValidatePassword(httpServletRequest);
            PwdToolkitUtilThreadLocal.setValidate(currentValidate);
            User user = UserLocalServiceUtil.updatePassword((long)userId, (String)password1, (String)password2, (boolean)passwordReset);
            String reminderQueryAnswer = user.getReminderQueryAnswer();
            if (this._isUserDefaultAdmin(user) && reminderQueryAnswer.equals("pending") && Validator.isNull((String)user.getReminderQueryQuestion())) {
                user.setReminderQueryAnswer(null);
                user = UserLocalServiceUtil.updateUser((User)user);
            }
            Date passwordModifiedDate = user.getPasswordModifiedDate();
            httpSession.setAttribute("USER_PASSWORD_MODIFIED_TIME", (Object)passwordModifiedDate.getTime());
        }
        finally {
            PwdToolkitUtilThreadLocal.setValidate(previousValidate);
        }
        User user = UserLocalServiceUtil.getUser((long)userId);
        Company company = CompanyLocalServiceUtil.getCompanyById((long)user.getCompanyId());
        if (ticket != null) {
            TicketLocalServiceUtil.deleteTickets((long)user.getCompanyId(), (String)User.class.getName(), (long)userId, (int)ticket.getType());
            user = UserLocalServiceUtil.updateLastLogin((User)user, (String)httpServletRequest.getRemoteAddr());
            UserLocalServiceUtil.updateLockout((User)user, (boolean)false);
            UserLocalServiceUtil.updatePasswordReset((long)userId, (boolean)false);
            if (company.isStrangersVerify()) {
                UserLocalServiceUtil.updateEmailAddressVerified((long)userId, (boolean)true);
            }
        }
        if (GetterUtil.getBoolean((Object)httpSession.getAttribute("MFA_ENABLED"))) {
            return;
        }
        String login = null;
        String authType = company.getAuthType();
        if (authType.equals("emailAddress")) {
            login = user.getEmailAddress();
        } else if (authType.equals("screenName")) {
            login = user.getScreenName();
        } else if (authType.equals("userId")) {
            login = String.valueOf(userId);
        }
        AuthenticatedSessionManagerUtil.login(httpServletRequest, httpServletResponse, login, password1, false, null);
    }

    private boolean _isUserDefaultAdmin(User user) {
        User defaultAdminUser = DefaultAdminUtil.fetchDefaultAdmin(user.getCompanyId());
        return defaultAdminUser != null && defaultAdminUser.getUserId() == user.getUserId();
    }
}

