/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class VelocityBeanHandler
implements InvocationHandler {
    private static final Log _log = LogFactoryUtil.getLog(VelocityBeanHandler.class);
    private final Object _bean;
    private final ClassLoader _classLoader;

    public VelocityBeanHandler(Object bean, ClassLoader classLoader) {
        this._bean = bean;
        this._classLoader = classLoader;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object object;
        block9: {
            SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)this._classLoader);
            try {
                object = method.invoke(this._bean, arguments);
                if (safeCloseable == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (safeCloseable != null) {
                        try {
                            safeCloseable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)invocationTargetException);
                    }
                    return null;
                }
            }
            safeCloseable.close();
        }
        return object;
    }
}

