/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.jdbc.util.DBInfo;
import com.liferay.portal.dao.jdbc.util.DBInfoUtil;
import com.liferay.portal.dao.orm.hibernate.DialectImpl;
import com.liferay.portal.dao.orm.hibernate.MariaDBDialect;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactory;
import com.liferay.portal.kernel.dao.db.DBManager;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.PropsValues;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.sql.DataSource;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.SQLServerDialect;

public class DBManagerImpl
implements DBManager {
    private static final Log _log = LogFactoryUtil.getLog(DBManagerImpl.class);
    private int _databaseInMaxParameters;
    private int _databaseMaxParameters;
    private DB _db;
    private final EnumMap<DBType, DBFactory> _dbFactories = new EnumMap(DBType.class);

    public DBManagerImpl() {
        ServiceLoader<DBFactory> serviceLoader = ServiceLoader.load(DBFactory.class, DBManagerImpl.class.getClassLoader());
        for (DBFactory dbFactory : serviceLoader) {
            this._dbFactories.put(dbFactory.getDBType(), dbFactory);
        }
    }

    public DB getDB() {
        if (this._db == null) {
            try {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Using dialect " + PropsValues.HIBERNATE_DIALECT));
                }
                Dialect dialect = (Dialect)InstanceFactory.newInstance((String)PropsValues.HIBERNATE_DIALECT);
                this.setDB(this.getDB(this.getDBType(dialect), InfrastructureUtil.getDataSource()));
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        return this._db;
    }

    public DB getDB(DBType dbType, DataSource dataSource) {
        DBFactory dbCreator = this._dbFactories.get(dbType);
        if (dbCreator == null) {
            throw new IllegalArgumentException("Unsupported database type " + dbType);
        }
        if (dataSource == null) {
            return dbCreator.create(0, 0);
        }
        DBInfo dbInfo = DBInfoUtil.getDBInfo(dataSource);
        return dbCreator.create(dbInfo.getMajorVersion(), dbInfo.getMinorVersion());
    }

    public int getDBInMaxParameters() {
        if (this._databaseInMaxParameters != 0) {
            return this._databaseInMaxParameters;
        }
        DBType dbType = this.getDBType();
        this._databaseInMaxParameters = GetterUtil.getInteger((String)PropsUtil.get((String)"database.in.max.parameters", (Filter)new Filter(dbType.getName())), (int)Integer.MAX_VALUE);
        return this._databaseInMaxParameters;
    }

    public int getDBMaxParameters() {
        if (this._databaseMaxParameters != 0) {
            return this._databaseMaxParameters;
        }
        DBType dbType = this.getDBType();
        this._databaseMaxParameters = GetterUtil.getInteger((String)PropsUtil.get((String)"database.max.parameters", (Filter)new Filter(dbType.getName())), (int)Integer.MAX_VALUE);
        return this._databaseMaxParameters;
    }

    public DBType getDBType() {
        if (this._db == null) {
            this.getDB();
        }
        return this._db.getDBType();
    }

    public DBType getDBType(DataSource dataSource) {
        return this.getDBType(DialectDetector.getDialect(dataSource));
    }

    public DBType getDBType(Object dialect) {
        if (dialect instanceof DialectImpl) {
            DialectImpl dialectImpl = (DialectImpl)dialect;
            dialect = dialectImpl.getWrappedDialect();
        }
        if (dialect instanceof DB2Dialect) {
            return DBType.DB2;
        }
        if (dialect instanceof HSQLDialect) {
            return DBType.HYPERSONIC;
        }
        if (dialect instanceof MariaDBDialect) {
            return DBType.MARIADB;
        }
        if (dialect instanceof MySQLDialect) {
            return DBType.MYSQL;
        }
        if (dialect instanceof Oracle8iDialect || dialect instanceof Oracle9Dialect) {
            return DBType.ORACLE;
        }
        if (dialect instanceof PostgreSQL82Dialect) {
            return DBType.POSTGRESQL;
        }
        if (dialect instanceof SQLServerDialect) {
            return DBType.SQLSERVER;
        }
        throw new IllegalArgumentException("Unknown dialect type " + dialect);
    }

    public Set<DBType> getDBTypes() {
        return new LinkedHashSet<DBType>(this._dbFactories.keySet());
    }

    public void setDB(DB db) {
        this._db = db;
        if (_log.isDebugEnabled()) {
            Class<?> clazz = this._db.getClass();
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Using DB implementation ", clazz.getName(), " for ", db.getDBType()}));
        }
    }
}

