/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.util.Map;

public class HypersonicDB
extends BaseDB {
    private static final String[] _HYPERSONIC = new String[]{"//", "true", "false", "'1970-01-01 00:00:00'", "now()", " blob", " blob", " decimal(30, 16)", " bit", " timestamp", " double", " int", " bigint", " longvarchar", " longvarchar", " varchar", "", "commit"};
    private static final int[] _SQL_TYPES = new int[]{2004, 2004, 3, -7, 93, 8, 4, -5, 12, 12, 12};

    public HypersonicDB(int majorVersion, int minorVersion) {
        super(DBType.HYPERSONIC, majorVersion, minorVersion);
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.replaceTemplate(template);
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    @Override
    public String getDefaultValue(String columnDef) {
        String defaultValue = super.getDefaultValue(columnDef);
        if (defaultValue.equals("NULL")) {
            return null;
        }
        return defaultValue;
    }

    public String getPopulateSQL(String databaseName, String sqlContent) {
        return "";
    }

    public String getRecreateSQL(String databaseName) {
        return "";
    }

    @Override
    protected void createSyncDeleteTrigger(Connection connection, String sourceTableName, String targetTableName, String triggerName, String[] sourcePrimaryKeyColumnNames, String[] targetPrimaryKeyColumnNames) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("create trigger ");
        sb.append(triggerName);
        sb.append(" after delete on ");
        sb.append(sourceTableName);
        sb.append(" referencing old row as old for each row delete from ");
        sb.append(targetTableName);
        sb.append(" where ");
        for (int i = 0; i < sourcePrimaryKeyColumnNames.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(targetPrimaryKeyColumnNames[i]);
            sb.append(" = old.");
            sb.append(sourcePrimaryKeyColumnNames[i]);
        }
        this.runSQL(connection, sb.toString());
    }

    @Override
    protected void createSyncInsertTrigger(Connection connection, String sourceTableName, String targetTableName, String triggerName, String[] sourceColumnNames, String[] targetColumnNames, String[] sourcePrimaryKeyColumnNames, String[] targetPrimaryKeyColumnNames, Map<String, String> defaultValuesMap) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("create trigger ");
        sb.append(triggerName);
        sb.append(" after insert on ");
        sb.append(sourceTableName);
        sb.append(" referencing new row as new for each row insert into ");
        sb.append(targetTableName);
        sb.append(" (");
        sb.append(StringUtil.merge((Object[])targetColumnNames, (String)", "));
        sb.append(") values (");
        for (int i = 0; i < sourceColumnNames.length; ++i) {
            String defaultValue;
            if (i > 0) {
                sb.append(", ");
            }
            if ((defaultValue = defaultValuesMap.get(targetColumnNames[i])) != null) {
                sb.append("COALESCE(");
            }
            sb.append("new.");
            sb.append(sourceColumnNames[i]);
            if (defaultValue == null) continue;
            sb.append(", ");
            sb.append(defaultValue);
            sb.append(")");
        }
        sb.append(")");
        this.runSQL(connection, sb.toString());
    }

    @Override
    protected void createSyncUpdateTrigger(Connection connection, String sourceTableName, String targetTableName, String triggerName, String[] sourceColumnNames, String[] targetColumnNames, String[] sourcePrimaryKeyColumnNames, String[] targetPrimaryKeyColumnNames, Map<String, String> defaultValuesMap) throws Exception {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("create trigger ");
        sb.append(triggerName);
        sb.append(" after update on ");
        sb.append(sourceTableName);
        sb.append(" referencing new row as new old row as old for each row ");
        sb.append("update ");
        sb.append(targetTableName);
        sb.append(" set ");
        for (i = 0; i < sourceColumnNames.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(targetColumnNames[i]);
            sb.append(" = ");
            String defaultValue = defaultValuesMap.get(targetColumnNames[i]);
            if (defaultValue != null) {
                sb.append("COALESCE(");
            }
            sb.append("new.");
            sb.append(sourceColumnNames[i]);
            if (defaultValue == null) continue;
            sb.append(", ");
            sb.append(defaultValue);
            sb.append(")");
        }
        sb.append(" where ");
        for (i = 0; i < sourcePrimaryKeyColumnNames.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(targetPrimaryKeyColumnNames[i]);
            sb.append(" = old.");
            sb.append(sourcePrimaryKeyColumnNames[i]);
        }
        this.runSQL(connection, sb.toString());
    }

    @Override
    protected String getCopyTableStructureSQL(String tableName, String newTableName) {
        return StringBundler.concat((String[])new String[]{"create table ", newTableName, " (like ", tableName, ")"});
    }

    @Override
    protected int[] getSQLTypes() {
        return _SQL_TYPES;
    }

    @Override
    protected Map<String, Integer> getSQLVarcharSizes() {
        return HashMapBuilder.put((Object)"STRING", (Object)Integer.MAX_VALUE).put((Object)"TEXT", (Object)Integer.MAX_VALUE).build();
    }

    @Override
    protected String[] getTemplate() {
        return _HYPERSONIC;
    }

    @Override
    protected boolean isSupportsDDLRollback() {
        return false;
    }

    @Override
    protected boolean isSupportsDuplicatedIndexName() {
        return false;
    }

    @Override
    protected String reword(String data) throws IOException {
        if (Validator.isNull((String)data)) {
            return null;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("alter_column_name ")) {
                    template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ rename to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_column_type ")) {
                    template = this.buildColumnTypeTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
                    String defaultValue = template[template.length - 2];
                    line = Validator.isBlank((String)defaultValue) ? line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ set default null;", (String[])REWORD_TEMPLATE, (String[])template)) : line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ set default @default@;", (String[])REWORD_TEMPLATE, (String[])template));
                    String nullable = template[template.length - 1];
                    line = !Validator.isBlank((String)nullable) ? line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ set @nullable@;", (String[])REWORD_TEMPLATE, (String[])template)) : line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ set null;", (String[])REWORD_TEMPLATE, (String[])template));
                } else if (line.startsWith("alter_table_name ")) {
                    template = this.buildTableNameTokens(line);
                    line = StringUtil.replace((String)"alter table @old-table@ rename to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
                } else if (line.contains("drop index")) {
                    String[] tokens = StringUtil.split((String)line, (char)' ');
                    line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
                }
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

