/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.util;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.dao.jdbc.util.DBInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public class DBInfoUtil {
    private static final ConcurrentMap<DataSource, DBInfo> _dbInfos = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);

    public static DBInfo getDBInfo(DataSource dataSource) {
        DBInfo dbInfo;
        if (dataSource instanceof DelegatingDataSource) {
            DelegatingDataSource delegatingDataSource = (DelegatingDataSource)dataSource;
            dataSource = delegatingDataSource.getTargetDataSource();
        }
        if ((dbInfo = (DBInfo)_dbInfos.get(dataSource)) == null) {
            dbInfo = DBInfoUtil._createDBInfo(dataSource);
            _dbInfos.put(dataSource, dbInfo);
        }
        return dbInfo;
    }

    private static DBInfo _createDBInfo(DataSource dataSource) {
        DBInfo dBInfo;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                dBInfo = new DBInfo(databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseMajorVersion(), databaseMetaData.getDatabaseMinorVersion());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    return (DBInfo)ReflectionUtil.throwException((Throwable)sqlException);
                }
            }
            connection.close();
        }
        return dBInfo;
    }
}

