/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.DB2SQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.DefaultSQLTransformer;
import com.liferay.portal.dao.sql.transformer.HypersonicSQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.MySQLSQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.OracleSQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.PostgreSQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.SQLServerSQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.SQLTransformer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBType;

public class SQLTransformerFactory {
    public static SQLTransformer getSQLTransformer(DB db) {
        DBType dbType = db.getDBType();
        BaseSQLTransformerLogic sqlTransformerLogic = null;
        if (dbType == DBType.DB2) {
            sqlTransformerLogic = new DB2SQLTransformerLogic(db);
        } else if (dbType == DBType.HYPERSONIC) {
            sqlTransformerLogic = new HypersonicSQLTransformerLogic(db);
        } else if (dbType == DBType.MARIADB || dbType == DBType.MYSQL) {
            sqlTransformerLogic = new MySQLSQLTransformerLogic(db);
        } else if (dbType == DBType.ORACLE) {
            sqlTransformerLogic = new OracleSQLTransformerLogic(db);
        } else if (dbType == DBType.POSTGRESQL) {
            sqlTransformerLogic = new PostgreSQLTransformerLogic(db);
        } else if (dbType == DBType.SQLSERVER) {
            sqlTransformerLogic = new SQLServerSQLTransformerLogic(db);
        } else {
            return sql -> sql;
        }
        return new DefaultSQLTransformer(sqlTransformerLogic.getFunctions());
    }
}

