/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.osgi.framework.Bundle;

public class DBResourceUtil {
    private static final Log _log = LogFactoryUtil.getLog(DBResourceUtil.class);

    public static String getModuleIndexesSQL(Bundle bundle) {
        return DBResourceUtil._read(bundle, "/META-INF/sql/indexes.sql");
    }

    public static String getModuleSequencesSQL(Bundle bundle) {
        return DBResourceUtil._read(bundle, "/META-INF/sql/sequences.sql");
    }

    public static String getModuleTablesSQL(Bundle bundle) {
        return DBResourceUtil._read(bundle, "/META-INF/sql/tables.sql");
    }

    public static String getPortalIndexesSQL() {
        return StringUtil.read(DBResourceUtil.class, (String)"/com/liferay/portal/tools/sql/dependencies/indexes.sql");
    }

    public static String getPortalTablesSQL() {
        return StringUtil.read(DBResourceUtil.class, (String)"/com/liferay/portal/tools/sql/dependencies/portal-tables.sql");
    }

    private static String _read(Bundle bundle, String path) {
        String string;
        block10: {
            URL resource = bundle.getResource(path);
            if (resource == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to locate SQL file " + path));
                }
                return null;
            }
            InputStream inputStream = resource.openStream();
            try {
                string = StringUtil.read((InputStream)inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    _log.error((Object)("Unable to read SQL file " + path), (Throwable)ioException);
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }
}

