/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.partition.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.PostgreSQLDB;
import com.liferay.portal.db.partition.db.DBPartitionDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBPartitionPostgreSQLDB
implements DBPartitionDB {
    private static String _defaultPartitionName;
    private static final Pattern _rulePattern;

    public static String[] getRuleTableColumn(String ruleSQL) {
        Matcher matcher = _rulePattern.matcher(ruleSQL);
        if (!matcher.find()) {
            return null;
        }
        String ruleName = matcher.group(1);
        String[] parts = ruleName.split("_", 3);
        return new String[]{parts[1], parts[2]};
    }

    @Override
    public String getCreatePartitionSQL(Connection connection, String partitionName) throws SQLException {
        return "create schema if not exists " + partitionName;
    }

    @Override
    public List<String> getCreateRulesSQL(String partitionName) throws SQLException {
        ArrayList<String> rules = new ArrayList<String>();
        try (Connection connection = DataAccess.getConnection();){
            String sql = StringBundler.concat((String[])new String[]{"select pg_catalog.pg_rewrite.rulename rulename, ", "pg_catalog.pg_get_ruledef(pg_catalog.pg_rewrite.oid, true) ", "ruledefinition from pg_catalog.pg_rewrite join pg_catalog.", "pg_class on pg_catalog.pg_rewrite.ev_class = ", "pg_catalog.pg_class.oid where ", "pg_catalog.pg_class.relnamespace ='", _defaultPartitionName, "'::regnamespace and (pg_catalog.pg_rewrite.rulename like ", "'delete_%' or pg_catalog.pg_rewrite.rulename like ", "'update_%')"});
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String[] ruleTableColumn;
                    String ruleDefinition = StringUtil.toLowerCase((String)resultSet.getString("ruledefinition"));
                    String ruleName = resultSet.getString("rulename");
                    if (!StringUtil.equals((String)ruleName, (String)StringBundler.concat((String[])new String[]{"delete_", (ruleTableColumn = DBPartitionPostgreSQLDB.getRuleTableColumn(ruleDefinition))[0], "_", ruleTableColumn[1]})) && !StringUtil.equals((String)ruleName, (String)StringBundler.concat((String[])new String[]{"update_", ruleTableColumn[0], "_", ruleTableColumn[1]}))) continue;
                    rules.add(PostgreSQLDB.getCreateRulesSQL(StringBundler.concat((String[])new String[]{partitionName, ".", ruleTableColumn[0]}), ruleTableColumn[1]));
                }
            }
        }
        return rules;
    }

    @Override
    public String getCreateTableSQL(Connection connection, String fromPartitionName, String toPartitionName, String fromTableName, String toTableName) throws SQLException {
        StringBundler sb = new StringBundler();
        sb.append(StringBundler.concat((String[])new String[]{"create table if not exists ", toPartitionName, ".", toTableName, " (like ", fromPartitionName, ".", fromTableName, " including all excluding indexes);\n"}));
        DB db = DBManagerUtil.getDB();
        Object[] primaryKeyColumnNames = db.getPrimaryKeyColumnNames(connection, fromTableName);
        if (ArrayUtil.isNotEmpty((Object[])primaryKeyColumnNames)) {
            sb.append("alter table ");
            sb.append(toPartitionName + "." + toTableName);
            sb.append(" add primary key (");
            for (Object columnName : primaryKeyColumnNames) {
                sb.append((String)columnName);
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            sb.append(");");
        }
        for (IndexMetadata indexMetadata : db.getIndexMetadatas(connection, fromTableName, null, false)) {
            sb.append("\n");
            sb.append(StringUtil.replace((String)indexMetadata.getCreateSQL(null), (String)("on " + fromTableName), (String)StringBundler.concat((String[])new String[]{"on ", toPartitionName, ".", toTableName})));
        }
        return sb.toString();
    }

    @Override
    public String getDefaultPartitionName(Connection connection) throws SQLException {
        if (_defaultPartitionName == null) {
            _defaultPartitionName = connection.getSchema();
        }
        return _defaultPartitionName;
    }

    @Override
    public String getDropPartitionSQL(String partitionName) {
        return "drop schema if exists " + partitionName + " cascade";
    }

    @Override
    public String getSafeAlterTable(String alterTableSQL) {
        String lowerCaseAlterTableSQL = StringUtil.toLowerCase((String)alterTableSQL);
        if (StringUtil.count((String)lowerCaseAlterTableSQL, (String)" cascade") == 0 && lowerCaseAlterTableSQL.matches("alter table \\S* drop.*$")) {
            return alterTableSQL + " cascade";
        }
        return alterTableSQL;
    }

    @Override
    public String getSchema(Connection connection, String partitionName) {
        return partitionName;
    }

    @Override
    public boolean isDDLTransactional() {
        return true;
    }

    @Override
    public void setPartition(Connection connection, String partitionName) throws SQLException {
        connection.setSchema(partitionName);
    }

    static {
        _rulePattern = Pattern.compile("create.* rule (.*?) as");
    }
}

