/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.partition.util;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.db.partition.db.DBPartitionDB;
import com.liferay.portal.db.partition.db.DBPartitionMySQLDB;
import com.liferay.portal.db.partition.db.DBPartitionPostgreSQLDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.jdbc.util.ConnectionWrapper;
import com.liferay.portal.kernel.dao.jdbc.util.StatementWrapper;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.module.framework.ThrowableCollector;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;

public class DBPartitionUtil {
    private static final String _DATABASE_PARTITION_SCHEMA_NAME_PREFIX = GetterUtil.get((String)PropsUtil.get((String)"database.partition.schema.name.prefix"), (String)"lpartition_");
    private static final boolean _DATABASE_PARTITION_THREAD_POOL_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"database.partition.thread.pool.enabled"), (boolean)true);
    private static final String _QUARTZ_TABLE_NAME_PREFIX = GetterUtil.get((String)PropsUtil.get((String)"persisted.scheduler.org.quartz.jobStore.tablePrefix"), (String)"QUARTZ_");
    private static final Log _log = LogFactoryUtil.getLog(DBPartitionUtil.class);
    private static DBPartitionDB _dbPartitionDB;
    private static volatile long _defaultCompanyId;
    private static String _defaultPartitionName;

    public static boolean addDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || companyId == _defaultCompanyId) {
            return false;
        }
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)_defaultCompanyId);){
            DBPartitionUtil._addDBPartition(companyId);
        }
        return true;
    }

    public static void checkDatabasePartitionSchemaNamePrefix() throws PortalException {
        if (DBPartition.isPartitionEnabled() && _DATABASE_PARTITION_SCHEMA_NAME_PREFIX.length() > 11) {
            throw new PortalException("The value for property \"database.partition.schema.name.prefix\" is greater than 11 characters");
        }
    }

    public static boolean copyDBPartition(long fromCompanyId, long toCompanyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || fromCompanyId == _defaultCompanyId) {
            return false;
        }
        DBPartitionUtil._copyDBPartition(fromCompanyId, toCompanyId);
        return true;
    }

    public static boolean extractDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || companyId == _defaultCompanyId) {
            return false;
        }
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)_defaultCompanyId);){
            DBPartitionUtil._extractDBPartition(companyId);
        }
        return true;
    }

    public static void forEachCompanyId(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        if (!DBPartition.isPartitionEnabled()) {
            unsafeConsumer.accept(null);
            return;
        }
        if (CompanyThreadLocal.isLocked()) {
            unsafeConsumer.accept((Object)CompanyThreadLocal.getCompanyId());
            return;
        }
        if (_DATABASE_PARTITION_THREAD_POOL_ENABLED) {
            DBPartitionUtil._forEachCompanyIdConcurrently(unsafeConsumer);
            return;
        }
        long[] companyIds = PortalInstancePool.getCompanyIds();
        if (ArrayUtil.isEmpty((long[])companyIds)) {
            unsafeConsumer.accept(null);
        } else {
            try (SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)_defaultCompanyId);){
                unsafeConsumer.accept((Object)_defaultCompanyId);
            }
            for (long companyId : companyIds) {
                if (companyId == _defaultCompanyId) continue;
                try (SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)companyId);){
                    unsafeConsumer.accept((Object)companyId);
                }
            }
        }
    }

    public static List<String> getConfigurationPids(long companyId) throws SQLException {
        ArrayList<String> pids = new ArrayList<String>();
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select configurationId from ", DBPartitionUtil.getPartitionName(companyId), ".Configuration_ where dictionary like ", "'%org.apache.felix.configadmin.revision%'"}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                pids.add(resultSet.getString(1));
            }
        }
        return pids;
    }

    public static Map<String, String> getConfigurations(long companyId) throws SQLException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select configurationId, dictionary from ", DBPartitionUtil.getPartitionName(companyId), ".Configuration_"}));){
            HashMap<String, String> hashMap;
            block13: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    HashMap<String, String> configurations = new HashMap<String, String>();
                    while (resultSet.next()) {
                        configurations.put(resultSet.getString(1), resultSet.getString(2));
                    }
                    hashMap = configurations;
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return hashMap;
        }
    }

    public static String getPartitionKey(Object key) {
        if (!DBPartition.isPartitionEnabled()) {
            return key.toString();
        }
        return key + "@" + CompanyThreadLocal.getNonsystemCompanyId();
    }

    public static String getPartitionName(long companyId) {
        if (companyId == 0L || companyId == _defaultCompanyId) {
            return _defaultPartitionName;
        }
        return _DATABASE_PARTITION_SCHEMA_NAME_PREFIX + companyId;
    }

    public static boolean insertDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled()) {
            return false;
        }
        DBPartitionUtil._insertDBPartition(companyId);
        return true;
    }

    public static boolean removeDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || companyId == _defaultCompanyId) {
            return false;
        }
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)_defaultCompanyId);){
            DBPartitionUtil._dropDBPartition(companyId);
        }
        return true;
    }

    public static void replaceByTable(Connection connection, boolean copyData, String viewName) throws Exception {
        long companyId = CompanyThreadLocal.getNonsystemCompanyId();
        if (companyId == _defaultCompanyId) {
            return;
        }
        String partitionName = DBPartitionUtil.getPartitionName(companyId);
        try (Statement statement = connection.createStatement();){
            statement.execute(_dbPartitionDB.getDropViewSQL(partitionName, viewName));
            statement.execute(_dbPartitionDB.getCreateTableSQL(connection, _defaultPartitionName, partitionName, viewName));
            if (copyData) {
                statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(_defaultPartitionName, partitionName, viewName, DBPartitionUtil._getColumnNames(connection, viewName), ""));
            }
        }
    }

    public static void setDefaultCompanyId(Connection connection) throws SQLException {
        if (DBPartition.isPartitionEnabled()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company where webId = '" + PropsValues.COMPANY_DEFAULT_WEB_ID + "'");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    _defaultCompanyId = resultSet.getLong(1);
                }
            }
        }
    }

    public static void setDefaultCompanyId(long companyId) {
        if (DBPartition.isPartitionEnabled()) {
            _defaultCompanyId = companyId;
        }
    }

    public static DataSource wrapDataSource(DataSource dataSource) throws SQLException {
        if (!DBPartition.isPartitionEnabled()) {
            return dataSource;
        }
        DB db = DBManagerUtil.getDB((DBType)DBManagerUtil.getDBType((Object)DialectDetector.getDialect(dataSource)), (DataSource)dataSource);
        if (!db.isSupportsDBPartition()) {
            throw new Error("Database partitioning is not supported for " + db.getDBType());
        }
        if (db.getDBType() == DBType.MYSQL) {
            _dbPartitionDB = new DBPartitionMySQLDB();
        } else if (db.getDBType() == DBType.POSTGRESQL) {
            _dbPartitionDB = new DBPartitionPostgreSQLDB();
        }
        try (Connection connection = dataSource.getConnection();){
            _defaultPartitionName = _dbPartitionDB.getDefaultPartitionName(connection);
        }
        return new DataSourceWrapper(dataSource){

            @Override
            public Connection getConnection() throws SQLException {
                return DBPartitionUtil._getConnectionWrapper(super.getConnection());
            }

            @Override
            public Connection getConnection(String userName, String password) throws SQLException {
                return DBPartitionUtil._getConnectionWrapper(super.getConnection());
            }
        };
    }

    private static void _addDBPartition(long companyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        String partitionName = DBPartitionUtil.getPartitionName(companyId);
        try (AutoCloseable autoCloseable = DBPartitionUtil._disableAutoCommit(connection);
             PreparedStatement preparedStatement = connection.prepareStatement(_dbPartitionDB.getCreatePartitionSQL(connection, partitionName));){
            preparedStatement.executeUpdate();
            List companyIds = ListUtil.fromArray((long[])PortalInstancePool.getCompanyIds());
            DBInspector dbInspector = new DBInspector(connection);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_dbPartitionDB.getCatalog(connection, _defaultPartitionName), _dbPartitionDB.getSchema(connection, _defaultPartitionName), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (dbInspector.isObjectTable(companyIds, tableName)) continue;
                    if (dbInspector.isControlTable(tableName)) {
                        statement.executeUpdate(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, partitionName, tableName));
                        continue;
                    }
                    statement.executeUpdate(_dbPartitionDB.getCreateTableSQL(connection, _defaultPartitionName, partitionName, tableName));
                    if (!dbInspector.isPartitionedControlTable(tableName)) continue;
                    statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(_defaultPartitionName, partitionName, tableName, DBPartitionUtil._getColumnNames(connection, tableName), ""));
                }
            }
            try (Statement statement = connection.createStatement();){
                for (String createRuleSQL : _dbPartitionDB.getCreateRulesSQL(partitionName)) {
                    statement.executeUpdate(createRuleSQL);
                }
            }
            connection.commit();
        }
        catch (Exception exception) {
            if (!_dbPartitionDB.isDDLTransactional()) {
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate(_dbPartitionDB.getDropPartitionSQL(partitionName));
                }
                catch (SQLException sqlException) {
                    throw new PortalException("Unable to roll back schema creation", (Throwable)sqlException);
                }
            }
            throw new PortalException((Throwable)exception);
        }
    }

    private static void _copyDBPartition(long fromCompanyId, long toCompanyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        DBInspector dbInspector = new DBInspector(connection);
        String fromPartitionName = DBPartitionUtil.getPartitionName(fromCompanyId);
        ArrayList<String> quartzTableNames = new ArrayList<String>();
        String toPartitionName = DBPartitionUtil.getPartitionName(toCompanyId);
        try (AutoCloseable autoCloseable = DBPartitionUtil._disableAutoCommit(connection);
             PreparedStatement preparedStatement = connection.prepareStatement(_dbPartitionDB.getCreatePartitionSQL(connection, toPartitionName));){
            preparedStatement.executeUpdate();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)fromCompanyId);
                 ResultSet resultSet = databaseMetaData.getTables(_dbPartitionDB.getCatalog(connection, fromPartitionName), _dbPartitionDB.getSchema(connection, fromPartitionName), null, new String[]{"TABLE", "VIEW"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String fromTableName = resultSet.getString("TABLE_NAME");
                    if (Objects.equals(resultSet.getString("TABLE_TYPE"), "VIEW")) {
                        statement.executeUpdate(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, toPartitionName, fromTableName));
                        if (!DBPartitionUtil._isCopyableQuartzTable(fromTableName)) continue;
                        DBPartitionUtil._copyQuartzTableRow(fromCompanyId, fromTableName, toCompanyId, statement);
                        quartzTableNames.add(fromTableName);
                        continue;
                    }
                    String toTableName = StringUtil.replace((String)fromTableName, (String)String.valueOf(fromCompanyId), (String)String.valueOf(toCompanyId));
                    statement.executeUpdate(_dbPartitionDB.getCreateTableSQL(connection, fromPartitionName, toPartitionName, fromTableName, toTableName));
                    if (StringUtil.equalsIgnoreCase((String)fromTableName, (String)"Configuration_")) continue;
                    statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(fromPartitionName, toPartitionName, fromTableName, toTableName, DBPartitionUtil._getColumnNames(connection, fromTableName), ""));
                    String partitionTableName = toPartitionName + "." + toTableName;
                    if (dbInspector.hasColumn(fromTableName, "companyId")) {
                        statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"update ", partitionTableName, " set ", "companyId = ", toCompanyId, " where ", "companyId = ", fromCompanyId}));
                    }
                    if (fromTableName.startsWith("Object") && dbInspector.hasColumn(fromTableName, "dbTableName")) {
                        statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"update ", partitionTableName, " set ", "dbTableName = REPLACE(dbTableName, ", fromCompanyId, ", ", toCompanyId, ") where dbTableName like '%", fromCompanyId, "%'"}));
                    }
                    if (StringUtil.equalsIgnoreCase((String)fromTableName, (String)"Group_")) {
                        statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"update ", partitionTableName, " set classPK ", "= ", toCompanyId, " where classPK = ", fromCompanyId}));
                        statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"update ", partitionTableName, " set groupKey ", "= '", toCompanyId, "' where groupKey = '", fromCompanyId, "'"}));
                    }
                    if (StringUtil.equalsIgnoreCase((String)fromTableName, (String)"PortalPreferences")) {
                        statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"update ", partitionTableName, " set ownerId ", "= ", toCompanyId, " where ownerId = ", fromCompanyId}));
                    }
                    if (StringUtil.equalsIgnoreCase((String)fromTableName, (String)"PortletPreferences")) {
                        statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"update ", partitionTableName, " set ownerId ", "= ", toCompanyId, " where ownerId = ", fromCompanyId}));
                    }
                    if (!StringUtil.equalsIgnoreCase((String)fromTableName, (String)"ResourcePermission")) continue;
                    statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"update ", partitionTableName, " set primKey ", "= '", toCompanyId, "', primKeyId = ", toCompanyId, " where primKey = '", fromCompanyId, "' and scope = ", 1}));
                }
            }
            try (Statement statement = connection.createStatement();){
                for (String createRuleSQL : _dbPartitionDB.getCreateRulesSQL(toPartitionName)) {
                    statement.executeUpdate(createRuleSQL);
                }
            }
            connection.commit();
            DBPartitionUtil._reloadQuartzJobs(fromCompanyId, toCompanyId);
        }
        catch (Exception exception1) {
            if (!_dbPartitionDB.isDDLTransactional() || exception1 instanceof SchedulerException) {
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate(_dbPartitionDB.getDropPartitionSQL(toPartitionName));
                    for (String tableName : quartzTableNames) {
                        DBPartitionUtil._deleteData(tableName, _defaultPartitionName, statement, DBPartitionUtil._getQuartzWhereClauseSQL(toCompanyId, tableName));
                    }
                }
                catch (Exception exception2) {
                    throw new PortalException("Unable to roll back schema creation", (Throwable)exception2);
                }
            }
            throw new PortalException((Throwable)exception1);
        }
    }

    private static void _copyQuartzTableRow(long fromCompanyId, String tableName, long toCompanyId, Statement statement) throws Exception {
        if (StringUtil.endsWith((String)tableName, (String)"JOB_DETAILS")) {
            DBPartitionUtil._replaceCompanyIdQuartzColumns(fromCompanyId, toCompanyId, tableName, statement, "job_name");
        } else if (StringUtil.equalsIgnoreCase((String)tableName, (String)"QUARTZ_TRIGGERS") || StringUtil.equalsIgnoreCase((String)tableName, (String)"QUARTZ_FIRED_TRIGGERS")) {
            DBPartitionUtil._replaceCompanyIdQuartzColumns(fromCompanyId, toCompanyId, tableName, statement, "job_name", "trigger_name");
        } else {
            DBPartitionUtil._replaceCompanyIdQuartzColumns(fromCompanyId, toCompanyId, tableName, statement, "trigger_name");
        }
    }

    private static void _deleteCompanyData(long companyId, String tableName, String fromPartitionName, Statement statement) throws Exception {
        DBPartitionUtil._deleteData(tableName, fromPartitionName, statement, " where companyId = " + companyId);
    }

    private static void _deleteData(String tableName, String fromPartitionName, Statement statement, String whereClause) throws Exception {
        statement.executeUpdate(StringBundler.concat((String[])new String[]{"delete from ", fromPartitionName, ".", tableName, whereClause}));
    }

    private static AutoCloseable _disableAutoCommit(Connection connection) throws Exception {
        boolean autoCommit = connection.getAutoCommit();
        connection.setAutoCommit(false);
        return () -> connection.setAutoCommit(autoCommit);
    }

    private static void _dropDBPartition(long companyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        DBInspector dbInspector = new DBInspector(connection);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_dbPartitionDB.getCatalog(connection, _defaultPartitionName), _dbPartitionDB.getSchema(connection, _defaultPartitionName), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!dbInspector.isControlTable(tableName)) continue;
                    if (dbInspector.hasColumn(tableName, "companyId")) {
                        DBPartitionUtil._deleteCompanyData(companyId, tableName, _defaultPartitionName, statement);
                        continue;
                    }
                    if (!DBPartitionUtil._isCopyableQuartzTable(tableName)) continue;
                    DBPartitionUtil._deleteData(tableName, _defaultPartitionName, statement, DBPartitionUtil._getQuartzWhereClauseSQL(companyId, tableName));
                }
                statement.executeUpdate(_dbPartitionDB.getDropPartitionSQL(DBPartitionUtil.getPartitionName(companyId)));
            }
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private static void _extractDBPartition(long companyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        ArrayList<String> controlTableNames = new ArrayList<String>();
        DBInspector dbInspector = new DBInspector(connection);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_dbPartitionDB.getCatalog(connection, _defaultPartitionName), _dbPartitionDB.getSchema(connection, _defaultPartitionName), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!dbInspector.isControlTable(tableName)) continue;
                    controlTableNames.add(tableName);
                    DBPartitionUtil._extractTable(companyId, connection, tableName, statement, dbInspector);
                }
            }
        }
        catch (Exception exception1) {
            if (ListUtil.isEmpty(controlTableNames) || _dbPartitionDB.isDDLTransactional()) {
                throw new PortalException((Throwable)exception1);
            }
            try (AutoCloseable autoCloseable = DBPartitionUtil._disableAutoCommit(connection);){
                for (String tableName : controlTableNames) {
                    Statement statement = connection.createStatement();
                    try {
                        DBPartitionUtil._restoreView(companyId, tableName, statement, dbInspector);
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
                connection.commit();
            }
            catch (Exception exception2) {
                throw new PortalException(StringBundler.concat((String[])new String[]{"Unable to roll back the extraction of database ", "partition. Recover a backup of the database ", "partition ", DBPartitionUtil.getPartitionName(companyId), "."}), (Throwable)exception2);
            }
            throw new PortalException("Removal of database partition extraction was rolled back", (Throwable)exception1);
        }
    }

    private static void _extractTable(long companyId, Connection connection, String tableName, Statement statement, DBInspector dbInspector) throws Exception {
        String partitionName = DBPartitionUtil.getPartitionName(companyId);
        statement.executeUpdate(_dbPartitionDB.getDropViewSQL(partitionName, tableName));
        statement.executeUpdate(_dbPartitionDB.getCreateTableSQL(connection, _defaultPartitionName, partitionName, tableName));
        if (dbInspector.hasColumn(tableName, "companyId")) {
            DBPartitionUtil._moveCompanyData(companyId, _defaultPartitionName, partitionName, tableName, statement);
        } else if (DBPartitionUtil._isCopyableQuartzTable(tableName)) {
            DBPartitionUtil._moveData(_defaultPartitionName, partitionName, tableName, DBPartitionUtil._getColumnNames(statement.getConnection(), tableName), statement, DBPartitionUtil._getQuartzWhereClauseSQL(companyId, tableName));
        } else {
            statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(_defaultPartitionName, partitionName, tableName, DBPartitionUtil._getColumnNames(statement.getConnection(), tableName), ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _forEachCompanyIdConcurrently(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        Object companyIds;
        Runtime runtime = Runtime.getRuntime();
        ExecutorService executorService = Executors.newFixedThreadPool(runtime.availableProcessors());
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ThrowableCollector throwableCollector = new ThrowableCollector();
        try {
            companyIds = PortalInstancePool.getCompanyIds();
            if (ArrayUtil.isEmpty((long[])companyIds)) {
                unsafeConsumer.accept(null);
            } else {
                try (SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)_defaultCompanyId);){
                    unsafeConsumer.accept((Object)_defaultCompanyId);
                }
                for (Object companyId : companyIds) {
                    if (companyId == _defaultCompanyId) continue;
                    Future<Void> future = executorService.submit(() -> DBPartitionUtil.lambda$_forEachCompanyIdConcurrently$1((long)companyId, unsafeConsumer, throwableCollector));
                    futures.add(future);
                }
            }
            executorService.shutdown();
        }
        catch (Throwable throwable) {
            executorService.shutdown();
            for (Future future : futures) {
                future.get();
            }
            throw throwable;
        }
        companyIds = futures.iterator();
        while (companyIds.hasNext()) {
            Future future = (Future)companyIds.next();
            future.get();
        }
        Throwable throwable = throwableCollector.getThrowable();
        if (throwable != null) {
            ReflectionUtil.throwException((Throwable)throwable);
        }
    }

    private static List<String> _getColumnNames(Connection connection, String tableName) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        DBInspector dbInspector = new DBInspector(connection);
        try (ResultSet resultSet = dbInspector.getColumnsResultSet(tableName);){
            while (resultSet.next()) {
                columnNames.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return columnNames;
    }

    private static Connection _getConnectionWrapper(final Connection connection) {
        return new ConnectionWrapper(connection){

            public Statement createStatement() throws SQLException {
                this._setPartition();
                return DBPartitionUtil._wrapStatement(super.createStatement());
            }

            public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
                this._setPartition();
                return DBPartitionUtil._wrapStatement(super.createStatement(resultSetType, resultSetConcurrency));
            }

            public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                this._setPartition();
                return DBPartitionUtil._wrapStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            }

            public String getCatalog() throws SQLException {
                return _dbPartitionDB.getCatalog(connection, DBPartitionUtil.getPartitionName(CompanyThreadLocal.getCompanyId()));
            }

            public String getSchema() {
                return _dbPartitionDB.getSchema(connection, DBPartitionUtil.getPartitionName(CompanyThreadLocal.getCompanyId()));
            }

            public PreparedStatement prepareStatement(String sql) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql);
            }

            public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, autoGeneratedKeys);
            }

            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }

            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }

            public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, columnIndexes);
            }

            public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
                this._setPartition();
                return super.prepareStatement(sql, columnNames);
            }

            private void _setPartition() throws SQLException {
                long companyId = CompanyThreadLocal.getCompanyId();
                String partitionName = DBPartitionUtil.getPartitionName(companyId);
                _dbPartitionDB.setPartition(connection, partitionName);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Using database partition ", partitionName, " and company ", companyId}));
                }
            }
        };
    }

    private static String _getCopyDataSQL(String fromPartitionName, String toPartitionName, String tableName, List<String> columnNames, String whereClause) {
        return DBPartitionUtil._getCopyDataSQL(fromPartitionName, toPartitionName, tableName, tableName, columnNames, whereClause);
    }

    private static String _getCopyDataSQL(String fromPartitionName, String toPartitionName, String fromTableName, String toTableName, List<String> columnNames, String whereClause) {
        return StringBundler.concat((String[])new String[]{"insert into ", toPartitionName, ".", toTableName, "(", StringUtil.merge(columnNames), ") select ", StringUtil.merge(columnNames), " from ", fromPartitionName, ".", fromTableName, whereClause});
    }

    private static String _getQuartzWhereClauseSQL(long companyId, String tableName) {
        if (StringUtil.endsWith((String)tableName, (String)"JOB_DETAILS")) {
            return " where job_name like '%@" + companyId + "'";
        }
        return " where trigger_name like '%@" + companyId + "'";
    }

    private static void _insertDBPartition(long companyId) throws PortalException {
        AutoCloseable autoCloseable = null;
        ArrayList<String> copiedTableNames = new ArrayList<String>();
        String partitionName = DBPartitionUtil.getPartitionName(companyId);
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        try (Statement statement = connection.createStatement();){
            autoCloseable = DBPartitionUtil._disableAutoCommit(connection);
            DBInspector dbInspector = new DBInspector(connection);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_dbPartitionDB.getCatalog(connection, _defaultPartitionName), _dbPartitionDB.getSchema(connection, _defaultPartitionName), null, new String[]{"TABLE"});){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!dbInspector.isControlTable(tableName)) continue;
                    if (dbInspector.hasColumn(tableName, "companyId")) {
                        statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(partitionName, _defaultPartitionName, tableName, DBPartitionUtil._getColumnNames(connection, tableName), " where companyId = " + companyId));
                        copiedTableNames.add(tableName);
                    } else if (DBPartitionUtil._isCopyableQuartzTable(tableName)) {
                        statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(partitionName, _defaultPartitionName, tableName, DBPartitionUtil._getColumnNames(connection, tableName), DBPartitionUtil._getQuartzWhereClauseSQL(companyId, tableName)));
                        copiedTableNames.add(tableName);
                    }
                    statement.executeUpdate(_dbPartitionDB.getDropTableSQL(partitionName, tableName));
                    statement.executeUpdate(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, partitionName, tableName));
                }
                connection.commit();
            }
        }
        catch (Exception exception1) {
            if (_dbPartitionDB.isDDLTransactional()) {
                throw new PortalException((Throwable)exception1);
            }
            try (Statement statement2 = connection.createStatement();){
                DBInspector dbInspector = new DBInspector(connection);
                for (String copiedTableName : copiedTableNames) {
                    DBPartitionUtil._extractTable(companyId, connection, copiedTableName, statement2, dbInspector);
                }
                connection.commit();
            }
            catch (Exception exception2) {
                throw new PortalException(StringBundler.concat((Object[])new Object[]{"Unable to roll back the data inserted into the ", "default schema for tables ", copiedTableNames, " and company ID ", companyId}), (Throwable)exception2);
            }
            throw new PortalException(StringBundler.concat((String[])new String[]{"Unable to roll back the insertion of database partition. ", "Recover a backup of the database schema ", partitionName, "."}), (Throwable)exception1);
        }
        finally {
            if (autoCloseable != null) {
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {
                    throw new PortalException((Throwable)exception);
                }
            }
        }
    }

    private static boolean _isCopyableQuartzTable(String tableName) {
        return StringUtil.startsWith((String)tableName, (String)_QUARTZ_TABLE_NAME_PREFIX) && (StringUtil.endsWith((String)tableName, (String)"JOB_DETAILS") || StringUtil.endsWith((String)tableName, (String)"TRIGGERS"));
    }

    private static boolean _isSkip(Connection connection, String tableName) throws SQLException {
        try {
            DBInspector dbInspector = new DBInspector(connection);
            if (dbInspector.isControlTable(tableName) && CompanyThreadLocal.getNonsystemCompanyId() != _defaultCompanyId || dbInspector.hasView(tableName)) {
                return true;
            }
        }
        catch (Exception exception) {
            throw new SQLException("Unable to check if the table " + tableName + " is a control table", exception);
        }
        return false;
    }

    private static void _moveCompanyData(long companyId, String fromPartitionName, String toPartitionName, String tableName, Statement statement) throws Exception {
        DBPartitionUtil._moveData(fromPartitionName, toPartitionName, tableName, DBPartitionUtil._getColumnNames(statement.getConnection(), tableName), statement, " where companyId = " + companyId);
    }

    private static void _moveData(String fromPartitionName, String toPartitionName, String tableName, List<String> columnNames, Statement statement, String whereClause) throws Exception {
        statement.executeUpdate(DBPartitionUtil._getCopyDataSQL(fromPartitionName, toPartitionName, tableName, columnNames, whereClause));
        DBPartitionUtil._deleteData(tableName, fromPartitionName, statement, whereClause);
    }

    private static void _reloadQuartzJobs(long fromCompanyId, long toCompanyId) throws SchedulerException {
        for (SchedulerResponse schedulerResponse : SchedulerEngineHelperUtil.getScheduledJobs()) {
            Message message = schedulerResponse.getMessage();
            String jobName = schedulerResponse.getJobName();
            if (message.getLong("companyId") != fromCompanyId || !jobName.contains(String.valueOf(toCompanyId))) continue;
            SchedulerEngineHelperUtil.delete((String)jobName, (String)schedulerResponse.getGroupName(), (StorageType)schedulerResponse.getStorageType());
            message.remove("JOB_STATE");
            message.put("companyId", (Object)toCompanyId);
            SchedulerEngineHelperUtil.schedule((Trigger)schedulerResponse.getTrigger(), (StorageType)schedulerResponse.getStorageType(), (String)schedulerResponse.getDescription(), (String)schedulerResponse.getDestinationName(), (Message)message);
        }
    }

    private static void _replaceCompanyIdQuartzColumns(long fromCompanyId, long toCompanyId, String tableName, Statement statement, String ... replaceColumnNames) throws Exception {
        List<String> columnNames = DBPartitionUtil._getColumnNames(statement.getConnection(), tableName);
        ArrayList<String> replaceSQLs = new ArrayList<String>();
        for (String replaceColumnName : replaceColumnNames) {
            replaceSQLs.add(StringBundler.concat((Object[])new Object[]{"replace (", replaceColumnName, ", '@", fromCompanyId, "', '@", toCompanyId, "') as ", replaceColumnName}));
            columnNames.removeIf(value -> value.equalsIgnoreCase(replaceColumnName));
        }
        statement.executeUpdate(StringBundler.concat((String[])new String[]{"insert into ", tableName, "(", StringUtil.merge((Object[])replaceColumnNames), ", ", StringUtil.merge(columnNames), ") select ", StringUtil.merge(replaceSQLs), ", ", StringUtil.merge(columnNames), " from ", tableName, DBPartitionUtil._getQuartzWhereClauseSQL(fromCompanyId, tableName)}));
    }

    private static void _restoreView(long companyId, String tableName, Statement statement, DBInspector dbInspector) throws Exception {
        String partitionName = DBPartitionUtil.getPartitionName(companyId);
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)companyId);){
            if (!dbInspector.hasTable(tableName)) {
                statement.executeUpdate(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, partitionName, tableName));
                return;
            }
        }
        if (dbInspector.hasColumn(tableName, "companyId")) {
            DBPartitionUtil._moveCompanyData(companyId, partitionName, _defaultPartitionName, tableName, statement);
        } else if (DBPartitionUtil._isCopyableQuartzTable(tableName)) {
            DBPartitionUtil._moveData(partitionName, _defaultPartitionName, tableName, DBPartitionUtil._getColumnNames(statement.getConnection(), tableName), statement, DBPartitionUtil._getQuartzWhereClauseSQL(companyId, tableName));
        }
        statement.executeUpdate(_dbPartitionDB.getDropTableSQL(partitionName, tableName));
        statement.executeUpdate(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, partitionName, tableName));
    }

    private static Statement _wrapStatement(final Statement statement) {
        return new StatementWrapper(statement){

            public int executeUpdate(String sql) throws SQLException {
                Connection connection = statement.getConnection();
                String lowerCaseSQL = StringUtil.toLowerCase((String)sql);
                String[] query = sql.split(" ");
                if (StringUtil.startsWith((String)lowerCaseSQL, (String)"alter table") && DBPartitionUtil._isSkip(connection, query[2]) || StringUtil.startsWith((String)lowerCaseSQL, (String)"create index") && DBPartitionUtil._isSkip(connection, query[4]) || StringUtil.startsWith((String)lowerCaseSQL, (String)"create unique index") && DBPartitionUtil._isSkip(connection, query[5])) {
                    return 0;
                }
                if (StringUtil.startsWith((String)lowerCaseSQL, (String)"drop index")) {
                    if (query.length >= 5 && DBPartitionUtil._isSkip(connection, query[4])) {
                        return 0;
                    }
                    if (query.length <= 4) {
                        sql = StringUtil.replace((String)sql, (String)"drop index ", (String)"drop index if exists ");
                        sql = StringUtil.replace((String)sql, (String)"DROP INDEX ", (String)"DROP INDEX IF EXISTS ");
                    }
                }
                if (!StringUtil.startsWith((String)lowerCaseSQL, (String)"alter table")) {
                    return super.executeUpdate(sql);
                }
                sql = _dbPartitionDB.getSafeAlterTable(sql);
                int returnValue = super.executeUpdate(sql);
                try {
                    DBInspector dbInspector = new DBInspector(connection);
                    String tableName = query[2];
                    if (!dbInspector.isControlTable(tableName)) {
                        return returnValue;
                    }
                    for (long companyId : PortalInstancePool.getCompanyIds()) {
                        if (companyId == _defaultCompanyId) continue;
                        super.execute(_dbPartitionDB.getCreateViewSQL(_defaultPartitionName, DBPartitionUtil.getPartitionName(companyId), tableName));
                    }
                    return returnValue;
                }
                catch (Exception exception) {
                    throw new SQLException(exception);
                }
            }
        };
    }

    private static /* synthetic */ Void lambda$_forEachCompanyIdConcurrently$1(long companyId, UnsafeConsumer unsafeConsumer, ThrowableCollector throwableCollector) throws Exception {
        try (SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)companyId);){
            unsafeConsumer.accept((Object)companyId);
        }
        catch (Exception exception) {
            throwableCollector.collect((Throwable)exception);
        }
        return null;
    }
}

