/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginPostAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(LoginPostAction.class);

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            User user;
            PasswordPolicy passwordPolicy;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Running " + httpServletRequest.getRemoteUser()));
            }
            HttpSession httpSession = httpServletRequest.getSession();
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
            long userId = 0L;
            httpSession.removeAttribute("LOCALE");
            if (PropsValues.LIVE_USERS_ENABLED) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                ClusterNode clusterNode = ClusterExecutorUtil.getLocalClusterNode();
                if (clusterNode != null) {
                    jsonObject.put("clusterNodeId", clusterNode.getClusterNodeId());
                }
                jsonObject.put("command", "signIn").put("companyId", companyId).put("remoteAddr", httpServletRequest.getRemoteAddr()).put("remoteHost", httpServletRequest.getRemoteHost()).put("sessionId", httpSession.getId());
                String userAgent = httpServletRequest.getHeader("User-Agent");
                jsonObject.put("userAgent", userAgent);
                userId = PortalUtil.getUserId((HttpServletRequest)httpServletRequest);
                jsonObject.put("userId", userId);
                MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
            }
            if (PrefsPropsUtil.getBoolean((long)companyId, (String)"admin.sync.default.associations")) {
                if (userId == 0L) {
                    userId = PortalUtil.getUserId((HttpServletRequest)httpServletRequest);
                }
                boolean reindex = false;
                if (UserLocalServiceUtil.addDefaultGroups((long)userId) | UserLocalServiceUtil.addDefaultRoles((long)userId) | UserLocalServiceUtil.addDefaultUserGroups((long)userId)) {
                    reindex = true;
                }
                if (reindex) {
                    Indexer userIndexer = IndexerRegistryUtil.getIndexer((String)User.class.getName());
                    userIndexer.reindex(User.class.getName(), userId);
                }
            }
            if ((passwordPolicy = (user = PortalUtil.getUser((HttpServletRequest)httpServletRequest)).getPasswordPolicy()) != null && passwordPolicy.isExpireable() && passwordPolicy.getWarningTime() > 0L) {
                this._setPasswordExpirationMessage(httpServletRequest, passwordPolicy, user);
            }
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    private void _setPasswordExpirationMessage(HttpServletRequest httpServletRequest, PasswordPolicy passwordPolicy, User user) throws PortalException {
        Date date = new Date();
        if (user.getPasswordModifiedDate() == null) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                date = new Date(httpSession.getCreationTime());
            }
            user.setPasswordModifiedDate(date);
            user = UserLocalServiceUtil.updateUser((User)user);
        }
        Date passwordModifiedDate = user.getPasswordModifiedDate();
        long passwordExpirationTime = passwordPolicy.getMaxAge() * 1000L + passwordModifiedDate.getTime();
        long startWarningTime = passwordExpirationTime - passwordPolicy.getWarningTime() * 1000L;
        if (date.getTime() > startWarningTime) {
            int passwordExpiresInXDays = (int)((passwordExpirationTime - date.getTime()) / 86400000L);
            if (passwordExpiresInXDays >= 0) {
                SessionMessages.add((HttpServletRequest)httpServletRequest, (String)"passwordExpiresInXDays", (Object)passwordExpiresInXDays);
            } else {
                int remainingGraceLogins = passwordPolicy.getGraceLimit() - user.getGraceLoginCount();
                SessionMessages.add((HttpServletRequest)httpServletRequest, (String)"remainingGraceLogins", (Object)remainingGraceLogins);
            }
        }
    }
}

