/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.increment;

import com.liferay.portal.internal.increment.BufferedIncreasableEntry;
import com.liferay.portal.internal.increment.BufferedIncrementProcessor;
import com.liferay.portal.internal.increment.BufferedIncrementProcessorUtil;
import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.Increment;
import com.liferay.portal.kernel.increment.IncrementFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

public class BufferedIncrementAdvice
extends ChainableMethodAdvice {
    private static final Log _log = LogFactoryUtil.getLog(BufferedIncrementAdvice.class);

    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        BufferedIncrement bufferedIncrement = (BufferedIncrement)annotations.get(BufferedIncrement.class);
        if (bufferedIncrement == null) {
            return null;
        }
        BufferedIncrementProcessor bufferedIncrementProcessor = BufferedIncrementProcessorUtil.getBufferedIncrementProcessor(bufferedIncrement.configuration());
        return new BufferedIncrementContext(bufferedIncrementProcessor, bufferedIncrement.incrementClass());
    }

    protected Object before(AopMethodInvocation aopMethodInvocation, Object[] arguments) {
        block3: {
            BufferedIncrementContext bufferedIncrementContext = (BufferedIncrementContext)aopMethodInvocation.getAdviceMethodContext();
            BufferedIncrementProcessor bufferedIncrementProcessor = bufferedIncrementContext._bufferedIncrementProcessor;
            Class<? extends Increment<?>> incrementClass = bufferedIncrementContext._incrementClass;
            Object value = arguments[arguments.length - 1];
            CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)BufferedIncrementAdvice.class.getName());
            for (int i = 0; i < arguments.length - 1; ++i) {
                cacheKeyGenerator.append(StringUtil.toHexString((Object)arguments[i]));
            }
            Serializable batchKey = cacheKeyGenerator.finish();
            try {
                Increment increment = IncrementFactory.createIncrement(incrementClass, (Object)value);
                BufferedIncreasableEntry bufferedIncreasableEntry = new BufferedIncreasableEntry(aopMethodInvocation, arguments, batchKey, increment);
                TransactionCommitCallbackUtil.registerCallback(() -> {
                    bufferedIncrementProcessor.process(bufferedIncreasableEntry);
                    return null;
                });
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to increment", (Throwable)exception);
            }
        }
        return nullResult;
    }

    private static class BufferedIncrementContext {
        private final BufferedIncrementProcessor _bufferedIncrementProcessor;
        private final Class<? extends Increment<?>> _incrementClass;

        private BufferedIncrementContext(BufferedIncrementProcessor bufferedIncrementProcessor, Class<? extends Increment<?>> incrementClass) {
            this._bufferedIncrementProcessor = bufferedIncrementProcessor;
            this._incrementClass = incrementClass;
        }
    }
}

