/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.increment;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.internal.increment.BatchablePipe;
import com.liferay.portal.internal.increment.BufferedIncreasableEntry;
import com.liferay.portal.internal.increment.BufferedIncrementConfiguration;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.increment.Increment;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferedIncrementRunnable
implements Runnable {
    private static final Log _log = LogFactoryUtil.getLog(BufferedIncrementRunnable.class);
    private final BatchablePipe<Serializable, Increment<?>> _batchablePipe;
    private final BufferedIncrementConfiguration _bufferedIncrementConfiguration;
    private final Thread _dispatchThread;
    private final AtomicInteger _queueLengthTracker;

    public BufferedIncrementRunnable(BufferedIncrementConfiguration bufferedIncrementConfiguration, BatchablePipe<Serializable, Increment<?>> batchablePipe, AtomicInteger queueLengthTracker, Thread dispatchThread) {
        this._bufferedIncrementConfiguration = bufferedIncrementConfiguration;
        this._batchablePipe = batchablePipe;
        this._queueLengthTracker = queueLengthTracker;
        this._dispatchThread = dispatchThread;
        if (bufferedIncrementConfiguration.isStandbyEnabled()) {
            this._queueLengthTracker.incrementAndGet();
        }
    }

    @Override
    public void run() {
        BufferedIncreasableEntry bufferedIncreasableEntry;
        while ((bufferedIncreasableEntry = (BufferedIncreasableEntry)this._batchablePipe.take()) != null) {
            try {
                bufferedIncreasableEntry.proceed();
            }
            catch (Throwable throwable) {
                _log.error((Object)("Unable to persist buffered increment value: " + bufferedIncreasableEntry), throwable);
            }
            if (!this._bufferedIncrementConfiguration.isStandbyEnabled() || !CTCollectionThreadLocal.isProductionMode()) continue;
            int queueLength = this._queueLengthTracker.decrementAndGet();
            long standbyTime = this._bufferedIncrementConfiguration.calculateStandbyTime(queueLength);
            try {
                Thread.sleep(standbyTime);
            }
            catch (InterruptedException interruptedException) {
                if (!_log.isDebugEnabled()) break;
                _log.debug((Throwable)interruptedException);
                break;
            }
        }
        if (this._dispatchThread != Thread.currentThread()) {
            ThreadLocalCacheManager.clearAll((Lifecycle)Lifecycle.REQUEST);
            CentralizedThreadLocal.clearShortLivedCentralizedThreadLocals();
        }
    }
}

