/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.jabsorb.serializer;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONObject;

public class LiferaySerializer
extends AbstractSerializer {
    private static final Class<?>[] _JSON_CLASSES = new Class[]{JSONObject.class};
    private static final Class<?>[] _SERIALIZABLE_CLASSES = new Class[]{Serializable.class};
    private static final Log _log = LogFactoryUtil.getLog(LiferaySerializer.class);

    public boolean canSerialize(Class clazz, Class jsonClass) {
        Constructor constructor;
        block2: {
            constructor = null;
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
        return Serializable.class.isAssignableFrom(clazz) && (jsonClass == null || jsonClass == JSONObject.class) && constructor != null;
    }

    public Class<?>[] getJSONClasses() {
        return _JSON_CLASSES;
    }

    public Class<?>[] getSerializableClasses() {
        return _SERIALIZABLE_CLASSES;
    }

    public Object marshall(SerializerState serializerState, Object parentObject, Object object) throws MarshallException {
        JSONObject jsonObject = new JSONObject();
        Class<?> javaClass = object.getClass();
        if (this.ser.getMarshallClassHints()) {
            try {
                jsonObject.put("javaClass", (Object)javaClass.getName());
                String contextName = ClassLoaderPool.getContextName((ClassLoader)javaClass.getClassLoader());
                if (Validator.isNotNull((String)contextName)) {
                    jsonObject.put("contextName", (Object)contextName);
                }
            }
            catch (Exception exception) {
                throw new MarshallException("Unable to put javaClass", (Throwable)exception);
            }
        }
        JSONObject serializableJSONObject = new JSONObject();
        try {
            jsonObject.put("serializable", (Object)serializableJSONObject);
            serializerState.push(object, (Object)serializableJSONObject, (Object)"serializable");
        }
        catch (Exception exception) {
            throw new MarshallException("Unable to put serializable", (Throwable)exception);
        }
        String fieldName = null;
        try {
            HashSet<String> processedFieldNames = new HashSet<String>();
            while (javaClass != null) {
                Field[] declaredFields;
                for (Field field : declaredFields = javaClass.getDeclaredFields()) {
                    Object fieldObject;
                    fieldName = field.getName();
                    if (processedFieldNames.contains(fieldName)) continue;
                    processedFieldNames.add(fieldName);
                    int modifiers = field.getModifiers();
                    if ((modifiers & 8) == 8 || (modifiers & 0x80) == 128) continue;
                    field.setAccessible(true);
                    if (fieldName.startsWith("_")) {
                        fieldName = fieldName.substring(1);
                    }
                    if (JSONSerializer.CIRC_REF_OR_DUPLICATE != (fieldObject = this.ser.marshall(serializerState, (Object)serializableJSONObject, field.get(object), (Object)fieldName))) {
                        serializableJSONObject.put(fieldName, fieldObject);
                        continue;
                    }
                    if (serializableJSONObject.has(fieldName)) continue;
                    serializableJSONObject.put(fieldName, field.get(object));
                }
                javaClass = javaClass.getSuperclass();
            }
        }
        catch (Exception exception) {
            throw new MarshallException("Unable to match field " + fieldName, (Throwable)exception);
        }
        finally {
            serializerState.pop();
        }
        return jsonObject;
    }

    public ObjectMatch tryUnmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        JSONObject jsonObject = (JSONObject)object;
        String javaClassName = null;
        try {
            javaClassName = jsonObject.getString("javaClass");
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to get javaClass", (Throwable)exception);
        }
        if (javaClassName == null) {
            throw new UnmarshallException("javaClass is undefined");
        }
        try {
            boolean loadedClassFromContext = false;
            if (jsonObject.has("contextName")) {
                String contextName = jsonObject.getString("contextName");
                ClassLoader classLoader = ClassLoaderPool.getClassLoader((String)contextName);
                if (classLoader != null) {
                    Class.forName(javaClassName, true, classLoader);
                    loadedClassFromContext = true;
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to get class loader for class ", javaClassName, " in context ", contextName}));
                }
            }
            if (!loadedClassFromContext) {
                Class.forName(javaClassName);
            }
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to get class " + javaClassName, (Throwable)exception);
        }
        JSONObject serializableJSONObject = null;
        try {
            serializableJSONObject = jsonObject.getJSONObject("serializable");
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to get serializable", (Throwable)exception);
        }
        if (serializableJSONObject == null) {
            throw new UnmarshallException("serializable is undefined");
        }
        ObjectMatch objectMatch = new ObjectMatch(-1);
        serializerState.setSerialized(object, (Object)objectMatch);
        String fieldName = null;
        try {
            Iterator iterator = serializableJSONObject.keys();
            while (iterator.hasNext()) {
                fieldName = (String)iterator.next();
                ObjectMatch fieldObjectMatch = this.ser.tryUnmarshall(serializerState, null, serializableJSONObject.get(fieldName));
                ObjectMatch maxFieldObjectMatch = fieldObjectMatch.max(objectMatch);
                objectMatch.setMismatch(maxFieldObjectMatch.getMismatch());
            }
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to match field " + fieldName, (Throwable)exception);
        }
        return objectMatch;
    }

    public Object unmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        JSONObject jsonObject = (JSONObject)object;
        String javaClassName = null;
        try {
            javaClassName = jsonObject.getString("javaClass");
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to get javaClass", (Throwable)exception);
        }
        if (javaClassName == null) {
            throw new UnmarshallException("javaClass is undefined");
        }
        Class<?> javaClass = null;
        Object javaClassInstance = null;
        try {
            if (jsonObject.has("contextName")) {
                String contextName = jsonObject.getString("contextName");
                ClassLoader classLoader = ClassLoaderPool.getClassLoader((String)contextName);
                if (classLoader != null) {
                    try {
                        javaClass = Class.forName(javaClassName, true, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to load class ", javaClassName, " in context ", contextName}), (Throwable)classNotFoundException);
                        }
                    }
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to get class loader for class ", javaClassName, " in context ", contextName}));
                }
            }
            if (javaClass == null) {
                javaClass = Class.forName(javaClassName);
            }
            javaClassInstance = javaClass.newInstance();
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to get class " + javaClassName, (Throwable)exception);
        }
        JSONObject serializableJSONObject = null;
        try {
            serializableJSONObject = jsonObject.getJSONObject("serializable");
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to get serializable", (Throwable)exception);
        }
        if (serializableJSONObject == null) {
            throw new UnmarshallException("serializable is undefined");
        }
        serializerState.setSerialized(object, javaClassInstance);
        String fieldName = null;
        try {
            HashSet<String> processedFieldNames = new HashSet<String>();
            while (javaClass != null) {
                Field[] fields;
                for (Field field : fields = javaClass.getDeclaredFields()) {
                    Object value;
                    block25: {
                        fieldName = field.getName();
                        if (processedFieldNames.contains(fieldName)) continue;
                        processedFieldNames.add(fieldName);
                        int modifiers = field.getModifiers();
                        if ((modifiers & 8) == 8 || (modifiers & 0x80) == 128) continue;
                        field.setAccessible(true);
                        if (fieldName.startsWith("_")) {
                            fieldName = fieldName.substring(1);
                        }
                        if (!serializableJSONObject.has(fieldName)) continue;
                        value = null;
                        try {
                            value = this.ser.unmarshall(serializerState, field.getType(), this._getSafe(serializableJSONObject, fieldName));
                        }
                        catch (Exception exception) {
                            if (!_log.isDebugEnabled()) break block25;
                            _log.debug((Throwable)exception);
                        }
                    }
                    if (value == null) continue;
                    try {
                        field.set(javaClassInstance, value);
                    }
                    catch (Exception exception) {
                        _log.error((Throwable)exception);
                    }
                }
                javaClass = javaClass.getSuperclass();
            }
        }
        catch (Exception exception) {
            throw new UnmarshallException("Unable to match field " + fieldName, (Throwable)exception);
        }
        return javaClassInstance;
    }

    private Object _getSafe(JSONObject jsonObject, String name) {
        Long cachedLong;
        Long jsonLong;
        Object object = jsonObject.get(name);
        if (object instanceof Integer) {
            Integer jsonInteger = (Integer)object;
            Integer cachedInteger = (int)jsonInteger;
            if (jsonInteger == cachedInteger) {
                return new Integer(jsonInteger);
            }
        } else if (object instanceof Long && (jsonLong = (Long)object) == (cachedLong = Long.valueOf(jsonLong))) {
            return new Long(jsonLong.intValue());
        }
        return object;
    }
}

