/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletWrapper;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.LayoutTypePortletFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LayoutImpl
extends LayoutBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutImpl.class);
    private static String[] _friendlyURLKeywords;
    private ColorScheme _colorScheme;
    private String _faviconURL;
    private LayoutSet _layoutSet;
    private transient LayoutType _layoutType;
    private Layout _masterLayout;
    private Theme _theme;
    private UnicodeProperties _typeSettingsUnicodeProperties;

    public static boolean hasFriendlyURLKeyword(String friendlyURL) {
        String keyword = LayoutImpl._getFriendlyURLKeyword(friendlyURL);
        return Validator.isNotNull((String)keyword);
    }

    public static int validateFriendlyURL(String friendlyURL) {
        return LayoutImpl.validateFriendlyURL(friendlyURL, true);
    }

    public static int validateFriendlyURL(String friendlyURL, boolean checkMaxLength) {
        if (friendlyURL.length() < 2) {
            return 3;
        }
        if (checkMaxLength && friendlyURL.length() > 255) {
            return 10;
        }
        if (!friendlyURL.startsWith("/")) {
            return 1;
        }
        if (friendlyURL.endsWith("/")) {
            return 2;
        }
        if (friendlyURL.contains("//")) {
            return 4;
        }
        for (char c : friendlyURL.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c) || c == '-' || c == '%' || c == '.' || c == '+' || c == '/' || c == '*' || c == '_') continue;
            return 5;
        }
        return -1;
    }

    public static void validateFriendlyURLKeyword(String friendlyURL) throws LayoutFriendlyURLException {
        String keyword = LayoutImpl._getFriendlyURLKeyword(friendlyURL);
        if (Validator.isNotNull((String)keyword)) {
            LayoutFriendlyURLException layoutFriendlyURLException = new LayoutFriendlyURLException(7);
            layoutFriendlyURLException.setKeywordConflict(keyword);
            throw layoutFriendlyURLException;
        }
    }

    public Layout fetchDraftLayout() {
        return LayoutLocalServiceUtil.fetchLayout((long)PortalUtil.getClassNameId(Layout.class), (long)this.getPlid());
    }

    public List<Layout> getAllChildren() {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Layout layout : this.getChildren()) {
            layouts.add(layout);
            layouts.addAll(layout.getAllChildren());
        }
        return layouts;
    }

    public long getAncestorLayoutId() throws PortalException {
        long layoutId = 0L;
        LayoutImpl layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId());
        }
        layoutId = layout.getLayoutId();
        return layoutId;
    }

    public long getAncestorPlid() throws PortalException {
        long plid = 0L;
        LayoutImpl layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId());
        }
        plid = layout.getPlid();
        return plid;
    }

    public List<Layout> getAncestors() throws PortalException {
        List<Layout> layouts = Collections.emptyList();
        LayoutImpl layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId());
            if (layouts.isEmpty()) {
                layouts = new ArrayList<Layout>();
            }
            layouts.add(layout);
        }
        return layouts;
    }

    public String getBreadcrumb(Locale locale) throws PortalException {
        List<Layout> layouts = this.getAncestors();
        StringBundler sb = new StringBundler(4 * layouts.size() + 5);
        Group group = this.getGroup();
        sb.append(group.getLayoutRootNodeName(this.isPrivateLayout(), locale));
        sb.append(" ");
        sb.append(">");
        sb.append(" ");
        Collections.reverse(layouts);
        for (Layout layout : layouts) {
            sb.append(HtmlUtil.escape((String)layout.getName(locale)));
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
        }
        sb.append(HtmlUtil.escape((String)this.getName(locale)));
        return sb.toString();
    }

    public List<Layout> getChildren() {
        return LayoutLocalServiceUtil.getLayouts((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)this.getLayoutId());
    }

    public List<Layout> getChildren(PermissionChecker permissionChecker) throws PortalException {
        List layouts = ListUtil.copy(this.getChildren());
        Iterator iterator = layouts.iterator();
        while (iterator.hasNext()) {
            Layout layout = (Layout)iterator.next();
            if (!layout.isHidden() && layout.isPublished() && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW")) continue;
            iterator.remove();
        }
        return layouts;
    }

    public ColorScheme getColorScheme() throws PortalException {
        if (this._colorScheme != null) {
            return this._colorScheme;
        }
        this._colorScheme = this._getColorScheme();
        return this._colorScheme;
    }

    public String getCssText() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getCss();
        }
        Layout masterLayout = this._getMasterLayout();
        if (masterLayout != null) {
            return masterLayout.getCssText();
        }
        return this.getCss();
    }

    public String getDefaultThemeSetting(String key, String device, boolean inheritLookAndFeel) {
        block6: {
            if (!inheritLookAndFeel) {
                try {
                    Theme theme = this.getTheme();
                    return theme.getSetting(key);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Throwable)exception);
                }
            }
        }
        try {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getThemeSetting(key, device);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }

    public List<Portlet> getEmbeddedPortlets() {
        return this.getEmbeddedPortlets(this.getGroupId());
    }

    public List<Portlet> getEmbeddedPortlets(long groupId) {
        List<PortletPreferences> portletPreferencesList = this._getPortletPreferences(groupId);
        if (portletPreferencesList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        Set<String> layoutPortletIds = this._getLayoutPortletIds();
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            String portletId = portletPreferences.getPortletId();
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
            if (portlet == null || !portlet.isReady() || portlet.isUndeployedPortlet() || !portlet.isActive() || !layoutPortletIds.contains(portletId)) continue;
            Object embeddedPortlet = portlet;
            if (!portlet.isInstanceable()) {
                embeddedPortlet = new PortletWrapper(portlet){
                    private boolean _staticPortlet;

                    public boolean getStatic() {
                        return this._staticPortlet;
                    }

                    public boolean isStatic() {
                        return this._staticPortlet;
                    }

                    public void setStatic(boolean staticPortlet) {
                        this._staticPortlet = staticPortlet;
                    }
                };
            }
            embeddedPortlet.setStatic(true);
            portlets.add((Portlet)embeddedPortlet);
        }
        return portlets;
    }

    public String getFaviconURL() {
        if (this._faviconURL != null) {
            return this._faviconURL;
        }
        String faviconURL = this._getFaviconURL(this.getFaviconFileEntryId());
        if (faviconURL != null) {
            this._faviconURL = faviconURL;
            return this._faviconURL;
        }
        return this._faviconURL;
    }

    public String getFriendlyURL(Locale locale) {
        String friendlyURL;
        block3: {
            friendlyURL = this.getFriendlyURL();
            try {
                Object[] locales;
                Group group = this.getGroup();
                UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
                if (!GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("inheritLocales"), (boolean)true) && !ArrayUtil.contains((Object[])(locales = StringUtil.split((String)typeSettingsUnicodeProperties.getProperty("locales"))), (Object)LanguageUtil.getLanguageId((Locale)locale))) {
                    return friendlyURL;
                }
                LayoutFriendlyURL layoutFriendlyURL = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURL((long)this.getPlid(), (String)LocaleUtil.toLanguageId((Locale)locale));
                friendlyURL = layoutFriendlyURL.getFriendlyURL();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        return friendlyURL;
    }

    public Map<Locale, String> getFriendlyURLMap() {
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)this.getPlid());
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            if (!LanguageUtil.isAvailableLocale((long)layoutFriendlyURL.getGroupId(), (String)layoutFriendlyURL.getLanguageId())) continue;
            friendlyURLMap.put(LocaleUtil.fromLanguageId((String)layoutFriendlyURL.getLanguageId(), (boolean)false), layoutFriendlyURL.getFriendlyURL());
        }
        return friendlyURLMap;
    }

    public String getFriendlyURLsXML() {
        Map<Locale, String> friendlyURLMap = this.getFriendlyURLMap();
        if (MapUtil.isNotEmpty(friendlyURLMap) && !friendlyURLMap.containsKey(LocaleUtil.getSiteDefault())) {
            String friendlyURL = friendlyURLMap.get(this.getDefaultLanguageId());
            if (friendlyURL == null) {
                Collection<String> values = friendlyURLMap.values();
                Iterator<String> iterator = values.iterator();
                friendlyURL = iterator.next();
            }
            friendlyURLMap.put(LocaleUtil.getSiteDefault(), friendlyURL);
        }
        return LocalizationUtil.updateLocalization(friendlyURLMap, (String)"", (String)"FriendlyURL", (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
    }

    public Group getGroup() {
        try {
            return GroupLocalServiceUtil.getGroup((long)this.getGroupId());
        }
        catch (PortalException portalException) {
            return (Group)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    public String getHTMLTitle(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getHTMLTitle(localeLanguageId);
    }

    public String getHTMLTitle(String localeLanguageId) {
        if (this.isDraftLayout() && this.isTypeContent()) {
            return this.getName(localeLanguageId);
        }
        String htmlTitle = this.getTitle(localeLanguageId);
        if (Validator.isNull((String)htmlTitle)) {
            htmlTitle = this.getName(localeLanguageId);
        }
        return htmlTitle;
    }

    public String getIcon() {
        if (this.isTypeContent()) {
            return "page";
        }
        if (this.isTypeURL() || this.isTypeLinkToLayout()) {
            return "link";
        }
        return "page-template";
    }

    public boolean getIconImage() {
        return this.getIconImageId() > 0L;
    }

    public LayoutSet getLayoutSet() {
        if (this._layoutSet == null) {
            try {
                this._layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)this.isPrivateLayout());
            }
            catch (PortalException portalException) {
                ReflectionUtil.throwException((Throwable)portalException);
            }
        }
        return this._layoutSet;
    }

    public Layout getLayoutSetPrototypeLayout() {
        try {
            LayoutSet layoutSet = this.getLayoutSet();
            if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
                return null;
            }
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSet.getLayoutSetPrototypeUuid(), (long)this.getCompanyId());
            return LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)this.getSourcePrototypeLayoutUuid(), (long)layoutSetPrototype.getGroupId(), (boolean)true);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to fetch the the layout set prototype's layout", (Throwable)exception);
            return null;
        }
    }

    public LayoutType getLayoutType() {
        if (this._layoutType == null) {
            this._layoutType = LayoutTypePortletFactoryUtil.create((Layout)this);
        }
        return this._layoutType;
    }

    public Layout getLinkedToLayout() {
        long linkToLayoutId = GetterUtil.getLong((String)this.getTypeSettingsProperty("linkToLayoutId"));
        if (linkToLayoutId <= 0L) {
            return null;
        }
        return LayoutLocalServiceUtil.fetchLayout((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)linkToLayoutId);
    }

    public String getRegularURL(HttpServletRequest httpServletRequest) throws PortalException {
        String url = this._getURL(httpServletRequest, false, false);
        if (!Validator.isUrl((String)url, (boolean)true)) {
            return "/" + url;
        }
        return url;
    }

    public String getResetLayoutURL(HttpServletRequest httpServletRequest) throws PortalException {
        return this._getURL(httpServletRequest, true, true);
    }

    public String getResetMaxStateURL(HttpServletRequest httpServletRequest) throws PortalException {
        return this._getURL(httpServletRequest, true, false);
    }

    public Group getScopeGroup() throws PortalException {
        Group group;
        block2: {
            group = null;
            try {
                group = GroupLocalServiceUtil.getLayoutGroup((long)this.getCompanyId(), (long)this.getPlid());
            }
            catch (NoSuchGroupException noSuchGroupException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)noSuchGroupException);
            }
        }
        return group;
    }

    public String getTarget() {
        return PortalUtil.getLayoutTarget((Layout)this);
    }

    public Theme getTheme() throws PortalException {
        if (this._theme != null) {
            return this._theme;
        }
        this._theme = this._getTheme();
        return this._theme;
    }

    public String getThemeSetting(String key, String device) {
        return this.getThemeSetting(key, device, this.isInheritLookAndFeel());
    }

    public String getThemeSetting(String key, String device, boolean inheritLookAndFeel) {
        String value;
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        Layout masterLayout = this._getMasterLayout();
        if (masterLayout != null) {
            typeSettingsUnicodeProperties = masterLayout.getTypeSettingsProperties();
        }
        if ((value = typeSettingsUnicodeProperties.getProperty(ThemeSettingImpl.namespaceProperty(device, key))) != null) {
            return value;
        }
        return this.getDefaultThemeSetting(key, device, inheritLookAndFeel);
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsUnicodeProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsUnicodeProperties.toString();
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsUnicodeProperties == null) {
            this._typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(super.getTypeSettings()).build();
        }
        return this._typeSettingsUnicodeProperties;
    }

    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        return typeSettingsUnicodeProperties.getProperty(key);
    }

    public String getTypeSettingsProperty(String key, String defaultValue) {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        return typeSettingsUnicodeProperties.getProperty(key, defaultValue);
    }

    public boolean hasAncestor(long layoutId) throws PortalException {
        long parentLayoutId = this.getParentLayoutId();
        while (parentLayoutId != 0L) {
            if (parentLayoutId == layoutId) {
                return true;
            }
            Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)parentLayoutId);
            parentLayoutId = parentLayout.getParentLayoutId();
        }
        return false;
    }

    public boolean hasChildren() {
        return LayoutLocalServiceUtil.hasLayouts((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)this.getLayoutId());
    }

    public boolean hasScopeGroup() throws PortalException {
        Group group = this.getScopeGroup();
        return group != null;
    }

    @Override
    public boolean hasSetModifiedDate() {
        return true;
    }

    public boolean includeLayoutContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(this.getType());
        return layoutTypeController.includeLayoutContent(httpServletRequest, httpServletResponse, (Layout)this);
    }

    public boolean isChildSelected(boolean selectable, Layout layout) throws PortalException {
        if (selectable) {
            long plid = this.getPlid();
            List ancestors = layout.getAncestors();
            for (Layout curLayout : ancestors) {
                if (plid != curLayout.getPlid()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContentDisplayPage() {
        UnicodeProperties typeSettingsUnicodeProperties = this.getTypeSettingsProperties();
        String defaultAssetPublisherPortletId = typeSettingsUnicodeProperties.getProperty("default-asset-publisher-portlet-id");
        return Validator.isNotNull((String)defaultAssetPublisherPortletId);
    }

    public boolean isCustomizable() {
        if (!this.isTypePortlet()) {
            return false;
        }
        if (GetterUtil.getBoolean((String)this.getTypeSettingsProperty("CUSTOMIZABLE_LAYOUT"))) {
            return true;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
        return layoutTypePortlet.isCustomizable();
    }

    public boolean isDraftLayout() {
        if (!this.isTypeAssetDisplay() && !this.isTypeContent()) {
            return false;
        }
        return this.getClassPK() > 0L && this.getClassNameId() == PortalUtil.getClassNameId((String)Layout.class.getName());
    }

    public boolean isEmbeddedPersonalApplication() {
        if (this.isTypeControlPanel()) {
            return false;
        }
        return this.isSystem() && Objects.equals(this.getFriendlyURL(), PropsUtil.get((String)"control.panel.layout.friendly.url"));
    }

    public boolean isFirstChild() {
        return this.getPriority() == 0;
    }

    public boolean isFirstParent() {
        return this.isFirstChild() && this.isRootLayout();
    }

    public boolean isIconImage() {
        return this.getIconImage();
    }

    public boolean isInheritLookAndFeel() {
        Layout masterLayout = this._getMasterLayout();
        if (masterLayout != null) {
            return masterLayout.isInheritLookAndFeel();
        }
        return Validator.isNull((String)this.getThemeId()) || Validator.isNull((String)this.getColorSchemeId());
    }

    public boolean isLayoutDeleteable() {
        block5: {
            try {
                if (Validator.isNull((String)this.getSourcePrototypeLayoutUuid())) {
                    return true;
                }
                LayoutSet layoutSet = this.getLayoutSet();
                if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
                    return true;
                }
                if (LayoutLocalServiceUtil.hasLayoutSetPrototypeLayout((String)layoutSet.getLayoutSetPrototypeUuid(), (long)this.getCompanyId(), (String)this.getSourcePrototypeLayoutUuid())) {
                    return false;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        return true;
    }

    public boolean isLayoutPrototypeLinkActive() {
        return this.isLayoutPrototypeLinkEnabled() && Validator.isNotNull((String)this.getLayoutPrototypeUuid());
    }

    public boolean isLayoutSortable() {
        return this.isLayoutDeleteable();
    }

    public boolean isLayoutUpdateable() {
        block7: {
            try {
                if (Validator.isNull((String)this.getLayoutPrototypeUuid()) && Validator.isNull((String)this.getSourcePrototypeLayoutUuid())) {
                    return true;
                }
                LayoutSet layoutSet = this.getLayoutSet();
                if (layoutSet.isLayoutSetPrototypeLinkActive()) {
                    boolean layoutSetPrototypeUpdateable = layoutSet.isLayoutSetPrototypeUpdateable();
                    if (!layoutSetPrototypeUpdateable) {
                        return false;
                    }
                    Layout layoutSetPrototypeLayout = this.getLayoutSetPrototypeLayout();
                    if (layoutSetPrototypeLayout == null) {
                        return true;
                    }
                    String layoutUpdateable = layoutSetPrototypeLayout.getTypeSettingsProperty("layoutUpdateable");
                    if (Validator.isNull((String)layoutUpdateable)) {
                        return true;
                    }
                    return GetterUtil.getBoolean((String)layoutUpdateable);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Throwable)exception);
            }
        }
        return true;
    }

    public boolean isPortletEmbedded(String portletId, long groupId) {
        LayoutTypePortlet layoutTypePortlet;
        PortalPreferences portalPreferences;
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.fetchPortletPreferences((long)0L, (int)3, (long)this.getPlid(), (String)portletId);
        if (portletPreferences == null) {
            return false;
        }
        portletPreferences = PortletPreferencesLocalServiceUtil.fetchPortletPreferences((long)groupId, (int)3, (long)0L, (String)portletId);
        if (portletPreferences == null && this.isTypePortlet() && (portalPreferences = (layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType()).getPortalPreferences()) != null && layoutTypePortlet.isCustomizable()) {
            portletPreferences = PortletPreferencesLocalServiceUtil.fetchPortletPreferences((long)portalPreferences.getUserId(), (int)4, (long)this.getPlid(), (String)portletId);
        }
        if (portletPreferences == null) {
            return false;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
        return portlet != null && portlet.isReady() && !portlet.isUndeployedPortlet() && portlet.isActive();
    }

    public boolean isPublicLayout() {
        return !this.isPrivateLayout();
    }

    public boolean isPublished() {
        if (!this.isTypeContent()) {
            return true;
        }
        Layout draftLayout = this.fetchDraftLayout();
        return draftLayout == null || GetterUtil.getBoolean((String)draftLayout.getTypeSettingsProperty("published"));
    }

    public boolean isRootLayout() {
        return this.getParentLayoutId() == 0L;
    }

    public boolean isSelected(boolean selectable, Layout layout, long ancestorPlid) {
        long plid;
        return selectable && ((plid = this.getPlid()) == layout.getPlid() || plid == ancestorPlid);
    }

    public boolean isSupportsEmbeddedPortlets() {
        return this.isTypeEmbedded() || this.isTypePanel() || this.isTypePortlet();
    }

    public boolean isTypeAssetDisplay() {
        return Objects.equals(this.getType(), "asset_display") || Objects.equals(this._getLayoutTypeControllerType(), "asset_display");
    }

    public boolean isTypeContent() {
        return Objects.equals(this.getType(), "content") || Objects.equals(this.getType(), "utility") || Objects.equals(this._getLayoutTypeControllerType(), "content");
    }

    public boolean isTypeControlPanel() {
        return Objects.equals(this.getType(), "control_panel") || Objects.equals(this._getLayoutTypeControllerType(), "control_panel");
    }

    public boolean isTypeEmbedded() {
        return Objects.equals(this.getType(), "embedded") || Objects.equals(this._getLayoutTypeControllerType(), "embedded");
    }

    public boolean isTypeLinkToLayout() {
        return Objects.equals(this.getType(), "link_to_layout") || Objects.equals(this._getLayoutTypeControllerType(), "link_to_layout");
    }

    public boolean isTypePanel() {
        return Objects.equals(this.getType(), "panel") || Objects.equals(this._getLayoutTypeControllerType(), "panel");
    }

    public boolean isTypePortlet() {
        return Objects.equals(this.getType(), "portlet") || Objects.equals(this._getLayoutTypeControllerType(), "portlet");
    }

    public boolean isTypeURL() {
        return Objects.equals(this.getType(), "url");
    }

    public boolean isTypeUtility() {
        return Objects.equals(this.getType(), "utility");
    }

    public boolean isUnlocked(String mode, long userId) {
        if (!Objects.equals(mode, "edit") || !this.isDraftLayout()) {
            return true;
        }
        Lock lock = LockManagerUtil.fetchLock((String)Layout.class.getName(), (long)this.getPlid());
        return lock == null || lock.getUserId() == userId;
    }

    public boolean matches(HttpServletRequest httpServletRequest, String friendlyURL) {
        LayoutType layoutType = this.getLayoutType();
        LayoutTypeController layoutTypeController = layoutType.getLayoutTypeController();
        return layoutTypeController.matches(httpServletRequest, friendlyURL, (Layout)this);
    }

    @Override
    public void setGroupId(long groupId) {
        super.setGroupId(groupId);
        this._layoutSet = null;
    }

    public void setLayoutSet(LayoutSet layoutSet) {
        this._layoutSet = layoutSet;
    }

    @Override
    public void setPrivateLayout(boolean privateLayout) {
        super.setPrivateLayout(privateLayout);
        this._layoutSet = null;
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsUnicodeProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsUnicodeProperties) {
        this._typeSettingsUnicodeProperties = typeSettingsUnicodeProperties;
        super.setTypeSettings(this._typeSettingsUnicodeProperties.toString());
    }

    private static String _getFriendlyURLKeyword(String friendlyURL) {
        friendlyURL = StringUtil.toLowerCase((String)friendlyURL);
        for (String keyword : _friendlyURLKeywords) {
            if (friendlyURL.startsWith(keyword)) {
                return keyword;
            }
            if (!keyword.equals(friendlyURL + "/")) continue;
            return friendlyURL;
        }
        return null;
    }

    private static void _initFriendlyURLKeywords() {
        _friendlyURLKeywords = new String[PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS.length];
        for (int i = 0; i < PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS.length; ++i) {
            Object keyword = PropsValues.LAYOUT_FRIENDLY_URL_KEYWORDS[i];
            if (!((String)(keyword = "/" + (String)keyword)).contains(".")) {
                keyword = ((String)keyword).endsWith("*") ? ((String)keyword).substring(0, ((String)keyword).length() - 1) : (String)keyword + "/";
            }
            LayoutImpl._friendlyURLKeywords[i] = StringUtil.toLowerCase((String)keyword);
        }
    }

    private ColorScheme _getColorScheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getColorScheme();
        }
        Layout masterLayout = this._getMasterLayout();
        if (masterLayout != null) {
            return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)masterLayout.getThemeId(), (String)masterLayout.getColorSchemeId());
        }
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getThemeId(), (String)this.getColorSchemeId());
    }

    private String _getFaviconURL(long faviconFileEntryId) {
        if (faviconFileEntryId <= 0L) {
            return null;
        }
        try {
            FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)faviconFileEntryId);
            return HtmlUtil.escape((String)StringBundler.concat((Object[])new Object[]{PortalUtil.getPathContext(), "/documents/", fileEntry.getRepositoryId(), "/", fileEntry.getFolderId(), "/", URLCodec.encodeURL((String)HtmlUtil.unescape((String)fileEntry.getTitle())), "/", URLCodec.encodeURL((String)fileEntry.getUuid())}));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private Set<String> _getLayoutPortletIds() {
        HashSet<String> layoutPortletIds = new HashSet<String>();
        List portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)0L, (int)3, (long)this.getPlid());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            layoutPortletIds.add(portletPreferences.getPortletId());
        }
        return layoutPortletIds;
    }

    private String _getLayoutTypeControllerType() {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(this.getType());
        return layoutTypeController.getType();
    }

    private LayoutTypePortlet _getLayoutTypePortletClone(HttpServletRequest httpServletRequest) throws IOException {
        String typeSettings;
        LayoutTypePortlet layoutTypePortlet = null;
        LayoutClone layoutClone = LayoutCloneFactory.getInstance();
        if (layoutClone != null && (typeSettings = layoutClone.get(httpServletRequest, this.getPlid())) != null) {
            UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).load(typeSettings).build();
            String stateMax = typeSettingsUnicodeProperties.getProperty("state-max");
            String stateMin = typeSettingsUnicodeProperties.getProperty("state-min");
            Layout layout = (Layout)this.clone();
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setStateMax(stateMax);
            layoutTypePortlet.setStateMin(stateMin);
        }
        if (layoutTypePortlet == null) {
            layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
        }
        return layoutTypePortlet;
    }

    private Layout _getMasterLayout() {
        if (this._masterLayout != null) {
            return this._masterLayout;
        }
        if (this.getMasterLayoutPlid() <= 0L) {
            return null;
        }
        if (this.getMasterLayoutPlid() == this.getPlid()) {
            throw new UnsupportedOperationException("Master page cannot point to itself");
        }
        this._masterLayout = LayoutLocalServiceUtil.fetchLayout((long)this.getMasterLayoutPlid());
        return this._masterLayout;
    }

    private List<PortletPreferences> _getPortletPreferences(long groupId) {
        LayoutTypePortlet layoutTypePortlet;
        PortalPreferences portalPreferences;
        List portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)groupId, (int)3, (long)0L);
        if (this.isTypePortlet() && (portalPreferences = (layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType()).getPortalPreferences()) != null && layoutTypePortlet.isCustomizable()) {
            portletPreferences = ListUtil.copy((List)portletPreferences);
            portletPreferences.addAll(PortletPreferencesLocalServiceUtil.getPortletPreferences((long)portalPreferences.getUserId(), (int)4, (long)this.getPlid()));
        }
        return portletPreferences;
    }

    private Theme _getTheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            LayoutSet layoutSet = this.getLayoutSet();
            return layoutSet.getTheme();
        }
        Layout masterLayout = this._getMasterLayout();
        if (masterLayout != null) {
            return ThemeLocalServiceUtil.getTheme((long)masterLayout.getCompanyId(), (String)masterLayout.getThemeId());
        }
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId());
    }

    private String _getURL(HttpServletRequest httpServletRequest, boolean resetMaxState, boolean resetRenderParameters) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (resetMaxState) {
            Layout layout = themeDisplay.getLayout();
            LayoutTypePortlet layoutTypePortlet = null;
            if (layout.equals((Object)this)) {
                layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
            } else {
                try {
                    layoutTypePortlet = this._getLayoutTypePortletClone(httpServletRequest);
                }
                catch (IOException ioException) {
                    _log.error((Object)"Unable to clone layout settings", (Throwable)ioException);
                    layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
                }
            }
            if (layoutTypePortlet.hasStateMax()) {
                String portletId = StringUtil.split((String)layoutTypePortlet.getStateMax())[0];
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletId, (Layout)this, (String)"ACTION_PHASE");
                try {
                    portletURL.setWindowState(WindowState.NORMAL);
                    portletURL.setPortletMode(PortletMode.VIEW);
                }
                catch (PortletException portletException) {
                    throw new SystemException((Throwable)portletException);
                }
                portletURL.setAnchor(false);
                if (PropsValues.LAYOUT_DEFAULT_P_L_RESET && !resetRenderParameters) {
                    portletURL.setParameter("p_l_reset", "0");
                } else if (!PropsValues.LAYOUT_DEFAULT_P_L_RESET && resetRenderParameters) {
                    portletURL.setParameter("p_l_reset", "1");
                }
                return portletURL.toString();
            }
        }
        String url = PortalUtil.getLayoutURL((Layout)this, (ThemeDisplay)themeDisplay);
        if (!CookiesManagerUtil.hasSessionId((HttpServletRequest)httpServletRequest) && (url.startsWith(PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest)) || url.startsWith("/"))) {
            HttpSession httpSession = httpServletRequest.getSession();
            url = PortalUtil.getURLWithSessionId((String)url, (String)httpSession.getId());
        }
        if (!resetMaxState) {
            return url;
        }
        if (PropsValues.LAYOUT_DEFAULT_P_L_RESET && !resetRenderParameters) {
            url = HttpComponentsUtil.addParameter((String)url, (String)"p_l_reset", (int)0);
        } else if (!PropsValues.LAYOUT_DEFAULT_P_L_RESET && resetRenderParameters) {
            url = HttpComponentsUtil.addParameter((String)url, (String)"p_l_reset", (int)1);
        }
        return url;
    }

    static {
        LayoutImpl._initFriendlyURLKeywords();
    }
}

