/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.registry;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryConfiguration;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.ConfigurationCapability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.repository.InitializedLocalRepository;
import com.liferay.portal.repository.InitializedRepository;
import com.liferay.portal.repository.capabilities.CapabilityLocalRepository;
import com.liferay.portal.repository.capabilities.CapabilityRepository;
import com.liferay.portal.repository.registry.DefaultCapabilityRegistry;
import com.liferay.portal.repository.registry.DefaultRepositoryEventRegistry;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RepositoryClassDefinition
implements RepositoryFactory,
RepositoryFactoryRegistry {
    private static final Snapshot<PortalCapabilityLocator> _portalCapabilityLocatorSnapshot = new Snapshot(RepositoryClassDefinition.class, PortalCapabilityLocator.class);
    private final Map<Long, Map<Long, LocalRepository>> _localRepositoriesMap = new ConcurrentHashMap<Long, Map<Long, LocalRepository>>();
    private final Map<Long, Map<Long, com.liferay.portal.kernel.repository.Repository>> _repositoriesMap = new ConcurrentHashMap<Long, Map<Long, com.liferay.portal.kernel.repository.Repository>>();
    private final RepositoryDefiner _repositoryDefiner;
    private RepositoryFactory _repositoryFactory;
    private final RepositoryEventTrigger _rootRepositoryEventTrigger;

    public static RepositoryClassDefinition fromRepositoryDefiner(RepositoryDefiner repositoryDefiner) {
        DefaultRepositoryEventRegistry defaultRepositoryEventRegistry = new DefaultRepositoryEventRegistry(null);
        RepositoryClassDefinition repositoryClassDefinition = new RepositoryClassDefinition(repositoryDefiner, defaultRepositoryEventRegistry);
        repositoryDefiner.registerRepositoryFactory((RepositoryFactoryRegistry)repositoryClassDefinition);
        repositoryDefiner.registerRepositoryEventListeners((RepositoryEventRegistry)defaultRepositoryEventRegistry);
        return repositoryClassDefinition;
    }

    public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
        Map localRepositories = this._localRepositoriesMap.computeIfAbsent(this._getCompanyId(repositoryId), key -> new ConcurrentHashMap());
        if (localRepositories.containsKey(repositoryId)) {
            return (LocalRepository)localRepositories.get(repositoryId);
        }
        InitializedLocalRepository initializedLocalRepository = new InitializedLocalRepository();
        DefaultCapabilityRegistry defaultCapabilityRegistry = new DefaultCapabilityRegistry(initializedLocalRepository);
        this._repositoryDefiner.registerCapabilities((CapabilityRegistry)defaultCapabilityRegistry);
        DefaultRepositoryEventRegistry defaultRepositoryEventRegistry = new DefaultRepositoryEventRegistry(this._rootRepositoryEventTrigger);
        this.setUpCommonCapabilities(initializedLocalRepository, defaultCapabilityRegistry, defaultRepositoryEventRegistry);
        defaultCapabilityRegistry.registerCapabilityRepositoryEvents(defaultRepositoryEventRegistry);
        LocalRepository localRepository = this._repositoryFactory.createLocalRepository(repositoryId);
        LocalRepository wrappedLocalRepository = defaultCapabilityRegistry.invokeCapabilityWrappers(localRepository);
        CapabilityLocalRepository capabilityLocalRepository = new CapabilityLocalRepository(wrappedLocalRepository, defaultCapabilityRegistry, defaultRepositoryEventRegistry);
        initializedLocalRepository.setDocumentRepository(capabilityLocalRepository);
        localRepositories.put(repositoryId, capabilityLocalRepository);
        return capabilityLocalRepository;
    }

    public com.liferay.portal.kernel.repository.Repository createRepository(long repositoryId) throws PortalException {
        Map repositories = this._repositoriesMap.computeIfAbsent(this._getCompanyId(repositoryId), key -> new ConcurrentHashMap());
        if (repositories.containsKey(repositoryId)) {
            return (com.liferay.portal.kernel.repository.Repository)repositories.get(repositoryId);
        }
        InitializedRepository initializedRepository = new InitializedRepository();
        DefaultCapabilityRegistry defaultCapabilityRegistry = new DefaultCapabilityRegistry(initializedRepository);
        this._repositoryDefiner.registerCapabilities((CapabilityRegistry)defaultCapabilityRegistry);
        DefaultRepositoryEventRegistry defaultRepositoryEventRegistry = new DefaultRepositoryEventRegistry(this._rootRepositoryEventTrigger);
        this.setUpCommonCapabilities(initializedRepository, defaultCapabilityRegistry, defaultRepositoryEventRegistry);
        com.liferay.portal.kernel.repository.Repository repository = this._repositoryFactory.createRepository(repositoryId);
        defaultCapabilityRegistry.registerCapabilityRepositoryEvents(defaultRepositoryEventRegistry);
        com.liferay.portal.kernel.repository.Repository wrappedRepository = defaultCapabilityRegistry.invokeCapabilityWrappers(repository);
        CapabilityRepository capabilityRepository = new CapabilityRepository(wrappedRepository, defaultCapabilityRegistry, defaultRepositoryEventRegistry);
        initializedRepository.setDocumentRepository(capabilityRepository);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            repositories.put(repositoryId, capabilityRepository);
        }
        return capabilityRepository;
    }

    public String getClassName() {
        return this._repositoryDefiner.getClassName();
    }

    public RepositoryConfiguration getRepositoryConfiguration() {
        return this._repositoryDefiner.getRepositoryConfiguration();
    }

    public String getRepositoryTypeLabel(Locale locale) {
        return this._repositoryDefiner.getRepositoryTypeLabel(locale);
    }

    public void invalidateCache() {
        this._localRepositoriesMap.clear();
        this._repositoriesMap.clear();
    }

    public void setRepositoryFactory(RepositoryFactory repositoryFactory) {
        if (this._repositoryFactory != null) {
            throw new IllegalStateException("Repository factory already exists");
        }
        this._repositoryFactory = repositoryFactory;
    }

    protected RepositoryClassDefinition(RepositoryDefiner repositoryDefiner, RepositoryEventTrigger rootRepositoryEventTrigger) {
        this._repositoryDefiner = repositoryDefiner;
        this._rootRepositoryEventTrigger = rootRepositoryEventTrigger;
    }

    protected void invalidateCachedRepository(long repositoryId) {
        if (CompanyThreadLocal.getCompanyId() != null) {
            Map<Long, com.liferay.portal.kernel.repository.Repository> map;
            Map<Long, LocalRepository> localRepositories = this._localRepositoriesMap.get(CompanyThreadLocal.getCompanyId());
            if (localRepositories != null) {
                localRepositories.remove(repositoryId);
            }
            if ((map = this._repositoriesMap.get(CompanyThreadLocal.getCompanyId())) != null) {
                map.remove(repositoryId);
            }
        } else {
            for (Map<Long, LocalRepository> map : this._localRepositoriesMap.values()) {
                map.remove(repositoryId);
            }
            for (Map<Long, LocalRepository> map : this._repositoriesMap.values()) {
                map.remove(repositoryId);
            }
        }
    }

    protected void setUpCommonCapabilities(DocumentRepository documentRepository, DefaultCapabilityRegistry capabilityRegistry, RepositoryEventTrigger repositoryEventTrigger) {
        PortalCapabilityLocator portalCapabilityLocator;
        if (!capabilityRegistry.isCapabilityProvided(ConfigurationCapability.class)) {
            portalCapabilityLocator = (PortalCapabilityLocator)_portalCapabilityLocatorSnapshot.get();
            capabilityRegistry.addExportedCapability(ConfigurationCapability.class, portalCapabilityLocator.getConfigurationCapability(documentRepository));
        }
        if (!capabilityRegistry.isCapabilityProvided(RepositoryEventTriggerCapability.class)) {
            portalCapabilityLocator = (PortalCapabilityLocator)_portalCapabilityLocatorSnapshot.get();
            capabilityRegistry.addExportedCapability(RepositoryEventTriggerCapability.class, portalCapabilityLocator.getRepositoryEventTriggerCapability(documentRepository, repositoryEventTrigger));
        }
        capabilityRegistry.addSupportedCapability(CacheCapability.class, new CacheCapability());
    }

    private long _getCompanyId(long repositoryId) throws PortalException {
        Group group = GroupLocalServiceUtil.fetchGroup((long)repositoryId);
        if (group != null) {
            return group.getCompanyId();
        }
        Repository repository = RepositoryLocalServiceUtil.getRepository((long)repositoryId);
        return repository.getCompanyId();
    }

    private class CacheCapability
    implements Capability,
    RepositoryEventAware {
        private CacheCapability() {
        }

        public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
            repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, LocalRepository.class, (RepositoryEventListener)new RepositoryEventListener<RepositoryEventType.Delete, LocalRepository>(){

                public void execute(LocalRepository localRepository) {
                    RepositoryClassDefinition.this.invalidateCachedRepository(localRepository.getRepositoryId());
                }
            });
        }
    }
}

