/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.index.IndexEncoder;
import com.liferay.portal.kernel.cache.index.PortalCacheIndexer;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class PermissionCacheUtil {
    public static final String PERMISSION_CACHE_NAME = PermissionCacheUtil.class.getName() + "_PERMISSION";
    public static final String PERMISSION_CHECKER_BAG_CACHE_NAME = PermissionCacheUtil.class.getName() + "_PERMISSION_CHECKER_BAG";
    public static final String USER_BAG_CACHE_NAME = PermissionCacheUtil.class.getName() + "_USER_BAG";
    public static final String USER_PRIMARY_KEY_ROLE_CACHE_NAME = PermissionCacheUtil.class.getName() + "_USER_PRIMARY_KEY_ROLE";
    public static final String USER_ROLE_CACHE_NAME = PermissionCacheUtil.class.getName() + "_USER_ROLE";
    private static final MethodKey _clearCacheMethodKey = new MethodKey(PermissionCacheUtil.class, "clearCache", new Class[]{long[].class});
    private static final MethodKey _clearResourcePermissionCacheMethodKey = new MethodKey(PermissionCacheUtil.class, "clearResourcePermissionCache", new Class[]{Integer.TYPE, String.class, String.class});
    private static final PortalCache<PermissionKey, Boolean> _permissionPortalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)PERMISSION_CACHE_NAME);
    private static final PortalCacheIndexer<Long, PermissionKey, Boolean> _permissionPortalCacheGroupIdIndexer = new PortalCacheIndexer((IndexEncoder)new PermissionKeyGroupIdIndexEncoder(), _permissionPortalCache);
    private static final PortalCacheIndexer<Map.Entry<?, ?>, PermissionKey, Boolean> _permissionPortalCacheNamePrimKeyIndexer = new PortalCacheIndexer((IndexEncoder)new PermissionKeyNamePrimKeyIndexEncoder(), _permissionPortalCache);
    private static final PortalCache<Long, UserBag> _userBagPortalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)USER_BAG_CACHE_NAME);
    private static final PortalCache<UserGroupRoleIdsKey, long[]> _userGroupRoleIdsPortalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)PERMISSION_CHECKER_BAG_CACHE_NAME);
    private static final PortalCacheIndexer<Long, UserGroupRoleIdsKey, long[]> _userGroupRoleIdsPortalCacheIndexer = new PortalCacheIndexer((IndexEncoder)new UserGroupRoleIdsKeyIndexEncoder(), _userGroupRoleIdsPortalCache);
    private static final PortalCache<UserPrimaryKeyRoleKey, Boolean> _userPrimaryKeyRolePortalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)USER_PRIMARY_KEY_ROLE_CACHE_NAME);
    private static final PortalCacheIndexer<Long, UserPrimaryKeyRoleKey, Boolean> _userPrimaryKeyRolePortalCacheUserIdIndexer = new PortalCacheIndexer((IndexEncoder)new UserGroupRoleKeyUserIdEncoder(), _userPrimaryKeyRolePortalCache);
    private static final PortalCache<UserRoleKey, Boolean> _userRolePortalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)USER_ROLE_CACHE_NAME);
    private static final PortalCacheIndexer<Long, UserRoleKey, Boolean> _userRolePortalCacheIndexer = new PortalCacheIndexer((IndexEncoder)new UserRoleKeyIndexEncoder(), _userRolePortalCache);

    public static void clearCache() {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        PermissionCacheUtil._clearPermissionChecksMap();
        _userRolePortalCache.removeAll();
        _userGroupRoleIdsPortalCache.removeAll();
        _permissionPortalCache.removeAll();
        _userBagPortalCache.removeAll();
        _userPrimaryKeyRolePortalCache.removeAll();
    }

    public static void clearCache(long ... userIds) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        PermissionCacheUtil._clearPermissionChecksMap();
        for (long userId : userIds) {
            _userBagPortalCache.remove((Serializable)Long.valueOf(userId));
            _userGroupRoleIdsPortalCacheIndexer.removeKeys((Object)userId);
            _userPrimaryKeyRolePortalCacheUserIdIndexer.removeKeys((Object)userId);
            _userRolePortalCacheIndexer.removeKeys((Object)userId);
        }
        _permissionPortalCache.removeAll();
        PermissionCacheUtil._sendClearCacheClusterMessage(_clearCacheMethodKey, new Object[]{userIds});
    }

    public static void clearPrimaryKeyRoleCache() {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        PermissionCacheUtil._clearPermissionChecksMap();
        _permissionPortalCache.removeAll();
        _userPrimaryKeyRolePortalCache.removeAll();
    }

    public static void clearResourceCache() {
        if (!ExportImportThreadLocal.isImportInProcess()) {
            _permissionPortalCache.removeAll();
        }
        PermissionCacheUtil._clearPermissionChecksMap();
    }

    public static void clearResourcePermissionCache(int scope, String name, String primKey) {
        if (ExportImportThreadLocal.isImportInProcess() || !PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)primKey)) {
            return;
        }
        PermissionCacheUtil._clearPermissionChecksMap();
        if (scope == 4) {
            _permissionPortalCacheNamePrimKeyIndexer.removeKeys(PermissionKeyNamePrimKeyIndexEncoder.encode(name, primKey));
            PermissionCacheUtil._sendClearCacheClusterMessage(_clearResourcePermissionCacheMethodKey, scope, name, primKey);
        } else if (scope == 2) {
            _permissionPortalCacheGroupIdIndexer.removeKeys((Object)Long.valueOf(primKey));
            PermissionCacheUtil._sendClearCacheClusterMessage(_clearResourcePermissionCacheMethodKey, scope, name, primKey);
        } else {
            _permissionPortalCache.removeAll();
        }
    }

    public static Boolean getPermission(long groupId, String name, String primKey, long[] roleIds, String actionId) {
        if (!CTCollectionThreadLocal.isProductionMode()) {
            return null;
        }
        PermissionKey permissionKey = new PermissionKey(groupId, name, primKey, roleIds, actionId);
        return (Boolean)_permissionPortalCache.get((Serializable)permissionKey);
    }

    public static UserBag getUserBag(long userId) {
        if (!CTCollectionThreadLocal.isProductionMode()) {
            return null;
        }
        return (UserBag)_userBagPortalCache.get((Serializable)Long.valueOf(userId));
    }

    public static long[] getUserGroupRoleIds(long userId, long groupId) {
        UserGroupRoleIdsKey userGroupRoleIdsKey = new UserGroupRoleIdsKey(userId, groupId);
        return (long[])_userGroupRoleIdsPortalCache.get((Serializable)userGroupRoleIdsKey);
    }

    public static Boolean getUserPrimaryKeyRole(long userId, long primaryKey, String roleName) {
        UserPrimaryKeyRoleKey userPrimaryKeyRoleKey = new UserPrimaryKeyRoleKey(userId, primaryKey, roleName);
        return (Boolean)_userPrimaryKeyRolePortalCache.get((Serializable)userPrimaryKeyRoleKey);
    }

    public static Boolean getUserRole(long userId, Role role) {
        UserRoleKey userRoleKey = new UserRoleKey(userId, role.getRoleId());
        Boolean userRole = (Boolean)_userRolePortalCache.get((Serializable)userRoleKey);
        if (userRole != null) {
            return userRole;
        }
        UserBag userBag = PermissionCacheUtil.getUserBag(userId);
        if (userBag == null) {
            return null;
        }
        userRole = userBag.hasRole(role);
        PortalCacheHelperUtil.putWithoutReplicator(_userRolePortalCache, (Serializable)userRoleKey, (Object)userRole);
        return userRole;
    }

    public static void putPermission(long groupId, String name, String primKey, long[] roleIds, String actionId, Boolean value) {
        if (!CTCollectionThreadLocal.isProductionMode()) {
            return;
        }
        PermissionKey permissionKey = new PermissionKey(groupId, name, primKey, roleIds, actionId);
        PortalCacheHelperUtil.putWithoutReplicator(_permissionPortalCache, (Serializable)permissionKey, (Object)value);
    }

    public static void putUserBag(long userId, UserBag userBag) {
        if (CTCollectionThreadLocal.isProductionMode()) {
            PortalCacheHelperUtil.putWithoutReplicator(_userBagPortalCache, (Serializable)Long.valueOf(userId), (Object)userBag);
        }
    }

    public static void putUserGroupRoleIds(long userId, long groupId, long[] roleIds) {
        if (roleIds == null) {
            return;
        }
        UserGroupRoleIdsKey userGroupRoleIdsKey = new UserGroupRoleIdsKey(userId, groupId);
        PortalCacheHelperUtil.putWithoutReplicator(_userGroupRoleIdsPortalCache, (Serializable)userGroupRoleIdsKey, (Object)roleIds);
    }

    public static void putUserPrimaryKeyRole(long userId, long primaryKey, String roleName, Boolean value) {
        if (value == null) {
            return;
        }
        UserPrimaryKeyRoleKey userPrimaryKeyRoleKey = new UserPrimaryKeyRoleKey(userId, primaryKey, roleName);
        PortalCacheHelperUtil.putWithoutReplicator(_userPrimaryKeyRolePortalCache, (Serializable)userPrimaryKeyRoleKey, (Object)value);
    }

    public static void putUserRole(long userId, Role role, Boolean value) {
        if (value == null) {
            return;
        }
        UserRoleKey userRoleKey = new UserRoleKey(userId, role.getRoleId());
        PortalCacheHelperUtil.putWithoutReplicator(_userRolePortalCache, (Serializable)userRoleKey, (Object)value);
    }

    private static void _clearPermissionChecksMap() {
        Map permissionChecksMap;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null && (permissionChecksMap = permissionChecker.getPermissionChecksMap()) != null) {
            permissionChecksMap.clear();
        }
    }

    private static void _sendClearCacheClusterMessage(MethodKey methodKey, Object ... arguments) {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)new MethodHandler(methodKey, arguments), (boolean)true);
        clusterRequest.setFireAndForget(true);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
    }

    private static class PermissionKeyNamePrimKeyIndexEncoder
    implements IndexEncoder<Map.Entry<?, ?>, PermissionKey> {
        private PermissionKeyNamePrimKeyIndexEncoder() {
        }

        public static Map.Entry<?, ?> encode(String name, String primKey) {
            return new AbstractMap.SimpleImmutableEntry<String, String>(name, primKey);
        }

        public Map.Entry<?, ?> encode(PermissionKey permissionKey) {
            return PermissionKeyNamePrimKeyIndexEncoder.encode(permissionKey._name, permissionKey._primKey);
        }
    }

    private static class PermissionKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _actionId;
        private final long _groupId;
        private final String _name;
        private final String _primKey;
        private final long[] _roleIds;

        public boolean equals(Object object) {
            PermissionKey permissionKey = (PermissionKey)object;
            return permissionKey._groupId == this._groupId && Objects.equals(permissionKey._name, this._name) && Objects.equals(permissionKey._primKey, this._primKey) && Arrays.equals(permissionKey._roleIds, this._roleIds) && Objects.equals(permissionKey._actionId, this._actionId);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._name);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._primKey);
            hashCode = HashUtil.hash((int)hashCode, (int)this._roleIds.length);
            for (long roleId : this._roleIds) {
                hashCode = HashUtil.hash((int)hashCode, (long)roleId);
            }
            return HashUtil.hash((int)hashCode, (Object)this._actionId);
        }

        private PermissionKey(long groupId, String name, String primKey, long[] roleIds, String actionId) {
            this._groupId = groupId;
            this._name = name;
            this._primKey = primKey;
            this._roleIds = roleIds;
            this._actionId = actionId;
        }
    }

    private static class UserGroupRoleIdsKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _groupId;
        private final long _userId;

        public boolean equals(Object object) {
            UserGroupRoleIdsKey userGroupRoleIdsKey = (UserGroupRoleIdsKey)object;
            return userGroupRoleIdsKey._userId == this._userId && userGroupRoleIdsKey._groupId == this._groupId;
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._userId);
            return HashUtil.hash((int)hashCode, (long)this._groupId);
        }

        private UserGroupRoleIdsKey(long userId, long groupId) {
            this._userId = userId;
            this._groupId = groupId;
        }
    }

    private static class UserPrimaryKeyRoleKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _name;
        private final long _primaryKey;
        private final long _userId;

        public boolean equals(Object object) {
            UserPrimaryKeyRoleKey userPrimaryKeyRoleKey = (UserPrimaryKeyRoleKey)object;
            return userPrimaryKeyRoleKey._userId == this._userId && userPrimaryKeyRoleKey._primaryKey == this._primaryKey && Objects.equals(userPrimaryKeyRoleKey._name, this._name);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._userId);
            hashCode = HashUtil.hash((int)hashCode, (long)this._primaryKey);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._name);
            return hashCode;
        }

        private UserPrimaryKeyRoleKey(long userId, long primaryKey, String name) {
            this._userId = userId;
            this._primaryKey = primaryKey;
            this._name = name;
        }
    }

    private static class UserRoleKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _roleId;
        private final long _userId;

        public boolean equals(Object object) {
            UserRoleKey userRoleKey = (UserRoleKey)object;
            return userRoleKey._userId == this._userId && userRoleKey._roleId == this._roleId;
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._userId);
            return HashUtil.hash((int)hashCode, (long)this._roleId);
        }

        private UserRoleKey(long userId, long roleId) {
            this._userId = userId;
            this._roleId = roleId;
        }
    }

    private static class PermissionKeyGroupIdIndexEncoder
    implements IndexEncoder<Long, PermissionKey> {
        private PermissionKeyGroupIdIndexEncoder() {
        }

        public Long encode(PermissionKey permissionKey) {
            return permissionKey._groupId;
        }
    }

    private static class UserGroupRoleIdsKeyIndexEncoder
    implements IndexEncoder<Long, UserGroupRoleIdsKey> {
        private UserGroupRoleIdsKeyIndexEncoder() {
        }

        public Long encode(UserGroupRoleIdsKey userGroupRoleIdsKey) {
            return userGroupRoleIdsKey._userId;
        }
    }

    private static class UserGroupRoleKeyUserIdEncoder
    implements IndexEncoder<Long, UserPrimaryKeyRoleKey> {
        private UserGroupRoleKeyUserIdEncoder() {
        }

        public Long encode(UserPrimaryKeyRoleKey key) {
            return key._userId;
        }
    }

    private static class UserRoleKeyIndexEncoder
    implements IndexEncoder<Long, UserRoleKey> {
        private UserRoleKeyIndexEncoder() {
        }

        public Long encode(UserRoleKey userRoleKey) {
            return userRoleKey._userId;
        }
    }
}

