/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.GroupFinder;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.OrganizationPersistence;
import com.liferay.portal.kernel.service.persistence.RolePersistence;
import com.liferay.portal.kernel.service.persistence.UserGroupPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;

public abstract class GroupLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements GroupLocalService,
IdentifiableOSGiService {
    @BeanReference(type=GroupLocalService.class)
    protected GroupLocalService groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    protected GroupPersistence groupPersistence;
    @BeanReference(type=GroupFinder.class)
    protected GroupFinder groupFinder;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=OrganizationPersistence.class)
    protected OrganizationPersistence organizationPersistence;
    @BeanReference(type=RolePersistence.class)
    protected RolePersistence rolePersistence;
    @BeanReference(type=UserGroupPersistence.class)
    protected UserGroupPersistence userGroupPersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    private static final Log _log = LogFactoryUtil.getLog(GroupLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Group addGroup(Group group) {
        group.setNew(true);
        return (Group)this.groupPersistence.update((BaseModel)group);
    }

    @Transactional(enabled=false)
    public Group createGroup(long groupId) {
        return this.groupPersistence.create(groupId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Group deleteGroup(long groupId) throws PortalException {
        return this.groupPersistence.remove(groupId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Group deleteGroup(Group group) throws PortalException {
        return (Group)this.groupPersistence.remove((BaseModel)group);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.groupPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Group.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.groupPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.groupPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.groupPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.groupPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.groupPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Group fetchGroup(long groupId) {
        return this.groupPersistence.fetchByPrimaryKey(groupId);
    }

    public Group fetchGroupByUuidAndCompanyId(String uuid, long companyId) {
        return this.groupPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public Group fetchGroupByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.groupPersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public Group getGroupByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.groupPersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public Group getGroup(long groupId) throws PortalException {
        return this.groupPersistence.findByPrimaryKey(groupId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.groupLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Group.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("groupId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.groupLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Group.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("groupId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.groupLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Group.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("groupId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.groupPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement GroupLocalServiceImpl#deleteGroup(Group) to avoid orphaned data");
        }
        return this.groupLocalService.deleteGroup((Group)persistedModel);
    }

    public BasePersistence<Group> getBasePersistence() {
        return this.groupPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.groupPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public Group getGroupByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.groupPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<Group> getGroups(int start, int end) {
        return this.groupPersistence.findAll(start, end);
    }

    public int getGroupsCount() {
        return this.groupPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Group updateGroup(Group group) {
        return (Group)this.groupPersistence.update((BaseModel)group);
    }

    public boolean addOrganizationGroup(long organizationId, long groupId) {
        return this.organizationPersistence.addGroup(organizationId, groupId);
    }

    public boolean addOrganizationGroup(long organizationId, Group group) {
        return this.organizationPersistence.addGroup(organizationId, group);
    }

    public boolean addOrganizationGroups(long organizationId, long[] groupIds) {
        return this.organizationPersistence.addGroups(organizationId, groupIds);
    }

    public boolean addOrganizationGroups(long organizationId, List<Group> groups) {
        return this.organizationPersistence.addGroups(organizationId, groups);
    }

    public void clearOrganizationGroups(long organizationId) {
        this.organizationPersistence.clearGroups(organizationId);
    }

    public void deleteOrganizationGroup(long organizationId, long groupId) {
        this.organizationPersistence.removeGroup(organizationId, groupId);
    }

    public void deleteOrganizationGroup(long organizationId, Group group) {
        this.organizationPersistence.removeGroup(organizationId, group);
    }

    public void deleteOrganizationGroups(long organizationId, long[] groupIds) {
        this.organizationPersistence.removeGroups(organizationId, groupIds);
    }

    public void deleteOrganizationGroups(long organizationId, List<Group> groups) {
        this.organizationPersistence.removeGroups(organizationId, groups);
    }

    public long[] getOrganizationPrimaryKeys(long groupId) {
        return this.groupPersistence.getOrganizationPrimaryKeys(groupId);
    }

    public List<Group> getOrganizationGroups(long organizationId) {
        return this.organizationPersistence.getGroups(organizationId);
    }

    public List<Group> getOrganizationGroups(long organizationId, int start, int end) {
        return this.organizationPersistence.getGroups(organizationId, start, end);
    }

    public List<Group> getOrganizationGroups(long organizationId, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.organizationPersistence.getGroups(organizationId, start, end, orderByComparator);
    }

    public int getOrganizationGroupsCount(long organizationId) {
        return this.organizationPersistence.getGroupsSize(organizationId);
    }

    public boolean hasOrganizationGroup(long organizationId, long groupId) {
        return this.organizationPersistence.containsGroup(organizationId, groupId);
    }

    public boolean hasOrganizationGroups(long organizationId) {
        return this.organizationPersistence.containsGroups(organizationId);
    }

    public void setOrganizationGroups(long organizationId, long[] groupIds) {
        this.organizationPersistence.setGroups(organizationId, groupIds);
    }

    public boolean addRoleGroup(long roleId, long groupId) {
        return this.rolePersistence.addGroup(roleId, groupId);
    }

    public boolean addRoleGroup(long roleId, Group group) {
        return this.rolePersistence.addGroup(roleId, group);
    }

    public boolean addRoleGroups(long roleId, long[] groupIds) {
        return this.rolePersistence.addGroups(roleId, groupIds);
    }

    public boolean addRoleGroups(long roleId, List<Group> groups) {
        return this.rolePersistence.addGroups(roleId, groups);
    }

    public void clearRoleGroups(long roleId) {
        this.rolePersistence.clearGroups(roleId);
    }

    public void deleteRoleGroup(long roleId, long groupId) {
        this.rolePersistence.removeGroup(roleId, groupId);
    }

    public void deleteRoleGroup(long roleId, Group group) {
        this.rolePersistence.removeGroup(roleId, group);
    }

    public void deleteRoleGroups(long roleId, long[] groupIds) {
        this.rolePersistence.removeGroups(roleId, groupIds);
    }

    public void deleteRoleGroups(long roleId, List<Group> groups) {
        this.rolePersistence.removeGroups(roleId, groups);
    }

    public long[] getRolePrimaryKeys(long groupId) {
        return this.groupPersistence.getRolePrimaryKeys(groupId);
    }

    public List<Group> getRoleGroups(long roleId) {
        return this.rolePersistence.getGroups(roleId);
    }

    public List<Group> getRoleGroups(long roleId, int start, int end) {
        return this.rolePersistence.getGroups(roleId, start, end);
    }

    public List<Group> getRoleGroups(long roleId, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.rolePersistence.getGroups(roleId, start, end, orderByComparator);
    }

    public int getRoleGroupsCount(long roleId) {
        return this.rolePersistence.getGroupsSize(roleId);
    }

    public boolean hasRoleGroup(long roleId, long groupId) {
        return this.rolePersistence.containsGroup(roleId, groupId);
    }

    public boolean hasRoleGroups(long roleId) {
        return this.rolePersistence.containsGroups(roleId);
    }

    public void setRoleGroups(long roleId, long[] groupIds) {
        this.rolePersistence.setGroups(roleId, groupIds);
    }

    public boolean addUserGroupGroup(long userGroupId, long groupId) {
        return this.userGroupPersistence.addGroup(userGroupId, groupId);
    }

    public boolean addUserGroupGroup(long userGroupId, Group group) {
        return this.userGroupPersistence.addGroup(userGroupId, group);
    }

    public boolean addUserGroupGroups(long userGroupId, long[] groupIds) {
        return this.userGroupPersistence.addGroups(userGroupId, groupIds);
    }

    public boolean addUserGroupGroups(long userGroupId, List<Group> groups) {
        return this.userGroupPersistence.addGroups(userGroupId, groups);
    }

    public void clearUserGroupGroups(long userGroupId) {
        this.userGroupPersistence.clearGroups(userGroupId);
    }

    public void deleteUserGroupGroup(long userGroupId, long groupId) {
        this.userGroupPersistence.removeGroup(userGroupId, groupId);
    }

    public void deleteUserGroupGroup(long userGroupId, Group group) {
        this.userGroupPersistence.removeGroup(userGroupId, group);
    }

    public void deleteUserGroupGroups(long userGroupId, long[] groupIds) {
        this.userGroupPersistence.removeGroups(userGroupId, groupIds);
    }

    public void deleteUserGroupGroups(long userGroupId, List<Group> groups) {
        this.userGroupPersistence.removeGroups(userGroupId, groups);
    }

    public long[] getUserGroupPrimaryKeys(long groupId) {
        return this.groupPersistence.getUserGroupPrimaryKeys(groupId);
    }

    public List<Group> getUserGroupGroups(long userGroupId) {
        return this.userGroupPersistence.getGroups(userGroupId);
    }

    public List<Group> getUserGroupGroups(long userGroupId, int start, int end) {
        return this.userGroupPersistence.getGroups(userGroupId, start, end);
    }

    public List<Group> getUserGroupGroups(long userGroupId, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.userGroupPersistence.getGroups(userGroupId, start, end, orderByComparator);
    }

    public int getUserGroupGroupsCount(long userGroupId) {
        return this.userGroupPersistence.getGroupsSize(userGroupId);
    }

    public boolean hasUserGroupGroup(long userGroupId, long groupId) {
        return this.userGroupPersistence.containsGroup(userGroupId, groupId);
    }

    public boolean hasUserGroupGroups(long userGroupId) {
        return this.userGroupPersistence.containsGroups(userGroupId);
    }

    public void setUserGroupGroups(long userGroupId, long[] groupIds) {
        this.userGroupPersistence.setGroups(userGroupId, groupIds);
    }

    public boolean addUserGroup(long userId, long groupId) {
        return this.userPersistence.addGroup(userId, groupId);
    }

    public boolean addUserGroup(long userId, Group group) {
        return this.userPersistence.addGroup(userId, group);
    }

    public boolean addUserGroups(long userId, long[] groupIds) {
        return this.userPersistence.addGroups(userId, groupIds);
    }

    public boolean addUserGroups(long userId, List<Group> groups) {
        return this.userPersistence.addGroups(userId, groups);
    }

    public void clearUserGroups(long userId) {
        this.userPersistence.clearGroups(userId);
    }

    public void deleteUserGroup(long userId, long groupId) {
        this.userPersistence.removeGroup(userId, groupId);
    }

    public void deleteUserGroup(long userId, Group group) {
        this.userPersistence.removeGroup(userId, group);
    }

    public void deleteUserGroups(long userId, long[] groupIds) {
        this.userPersistence.removeGroups(userId, groupIds);
    }

    public void deleteUserGroups(long userId, List<Group> groups) {
        this.userPersistence.removeGroups(userId, groups);
    }

    public long[] getUserPrimaryKeys(long groupId) {
        return this.groupPersistence.getUserPrimaryKeys(groupId);
    }

    public List<Group> getUserGroups(long userId) {
        return this.userPersistence.getGroups(userId);
    }

    public List<Group> getUserGroups(long userId, int start, int end) {
        return this.userPersistence.getGroups(userId, start, end);
    }

    public List<Group> getUserGroups(long userId, int start, int end, OrderByComparator<Group> orderByComparator) throws PortalException {
        return this.userPersistence.getGroups(userId, start, end, orderByComparator);
    }

    public int getUserGroupsCount(long userId) {
        return this.userPersistence.getGroupsSize(userId);
    }

    public boolean hasUserGroup(long userId, long groupId) {
        return this.userPersistence.containsGroup(userId, groupId);
    }

    public boolean hasUserGroups(long userId) {
        return this.userPersistence.containsGroups(userId);
    }

    public void setUserGroups(long userId, long[] groupIds) {
        this.userPersistence.setGroups(userId, groupIds);
    }

    public GroupLocalService getGroupLocalService() {
        return this.groupLocalService;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public GroupPersistence getGroupPersistence() {
        return this.groupPersistence;
    }

    public void setGroupPersistence(GroupPersistence groupPersistence) {
        this.groupPersistence = groupPersistence;
    }

    public GroupFinder getGroupFinder() {
        return this.groupFinder;
    }

    public void setGroupFinder(GroupFinder groupFinder) {
        this.groupFinder = groupFinder;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        GroupLocalServiceUtil.setService((GroupLocalService)this.groupLocalService);
    }

    public void destroy() {
        GroupLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return GroupLocalService.class.getName();
    }

    public CTPersistence<Group> getCTPersistence() {
        return this.groupPersistence;
    }

    public Class<Group> getModelClass() {
        return Group.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<Group>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.groupPersistence);
    }

    protected String getModelClassName() {
        return Group.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.groupPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

