/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetPersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;

public abstract class LayoutSetLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
LayoutSetLocalService {
    @BeanReference(type=LayoutSetLocalService.class)
    protected LayoutSetLocalService layoutSetLocalService;
    @BeanReference(type=LayoutSetPersistence.class)
    protected LayoutSetPersistence layoutSetPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public LayoutSet addLayoutSet(LayoutSet layoutSet) {
        layoutSet.setNew(true);
        return (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
    }

    @Transactional(enabled=false)
    public LayoutSet createLayoutSet(long layoutSetId) {
        return this.layoutSetPersistence.create(layoutSetId);
    }

    @Indexable(type=IndexableType.DELETE)
    public LayoutSet deleteLayoutSet(long layoutSetId) throws PortalException {
        return this.layoutSetPersistence.remove(layoutSetId);
    }

    @Indexable(type=IndexableType.DELETE)
    public LayoutSet deleteLayoutSet(LayoutSet layoutSet) {
        return (LayoutSet)this.layoutSetPersistence.remove((BaseModel)layoutSet);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.layoutSetPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(LayoutSet.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.layoutSetPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.layoutSetPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.layoutSetPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.layoutSetPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.layoutSetPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public LayoutSet fetchLayoutSet(long layoutSetId) {
        return this.layoutSetPersistence.fetchByPrimaryKey(layoutSetId);
    }

    public LayoutSet getLayoutSet(long layoutSetId) throws PortalException {
        return this.layoutSetPersistence.findByPrimaryKey(layoutSetId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.layoutSetLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LayoutSet.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("layoutSetId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.layoutSetLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(LayoutSet.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("layoutSetId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.layoutSetLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LayoutSet.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("layoutSetId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.layoutSetPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement LayoutSetLocalServiceImpl#deleteLayoutSet(LayoutSet) to avoid orphaned data");
        }
        return this.layoutSetLocalService.deleteLayoutSet((LayoutSet)persistedModel);
    }

    public BasePersistence<LayoutSet> getBasePersistence() {
        return this.layoutSetPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.layoutSetPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<LayoutSet> getLayoutSets(int start, int end) {
        return this.layoutSetPersistence.findAll(start, end);
    }

    public int getLayoutSetsCount() {
        return this.layoutSetPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public LayoutSet updateLayoutSet(LayoutSet layoutSet) {
        return (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
    }

    public LayoutSetLocalService getLayoutSetLocalService() {
        return this.layoutSetLocalService;
    }

    public void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this.layoutSetLocalService = layoutSetLocalService;
    }

    public LayoutSetPersistence getLayoutSetPersistence() {
        return this.layoutSetPersistence;
    }

    public void setLayoutSetPersistence(LayoutSetPersistence layoutSetPersistence) {
        this.layoutSetPersistence = layoutSetPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        LayoutSetLocalServiceUtil.setService((LayoutSetLocalService)this.layoutSetLocalService);
    }

    public void destroy() {
        LayoutSetLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return LayoutSetLocalService.class.getName();
    }

    public CTPersistence<LayoutSet> getCTPersistence() {
        return this.layoutSetPersistence;
    }

    public Class<LayoutSet> getModelClass() {
        return LayoutSet.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<LayoutSet>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.layoutSetPersistence);
    }

    protected String getModelClassName() {
        return LayoutSet.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.layoutSetPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

