/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.OrganizationFinder;
import com.liferay.portal.kernel.service.persistence.OrganizationPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;

public abstract class OrganizationLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
OrganizationLocalService {
    @BeanReference(type=OrganizationLocalService.class)
    protected OrganizationLocalService organizationLocalService;
    @BeanReference(type=OrganizationPersistence.class)
    protected OrganizationPersistence organizationPersistence;
    @BeanReference(type=OrganizationFinder.class)
    protected OrganizationFinder organizationFinder;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=GroupPersistence.class)
    protected GroupPersistence groupPersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    private static final Log _log = LogFactoryUtil.getLog(OrganizationLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Organization addOrganization(Organization organization) {
        organization.setNew(true);
        return (Organization)this.organizationPersistence.update((BaseModel)organization);
    }

    @Transactional(enabled=false)
    public Organization createOrganization(long organizationId) {
        return this.organizationPersistence.create(organizationId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Organization deleteOrganization(long organizationId) throws PortalException {
        return this.organizationPersistence.remove(organizationId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Organization deleteOrganization(Organization organization) throws PortalException {
        return (Organization)this.organizationPersistence.remove((BaseModel)organization);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.organizationPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Organization.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.organizationPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.organizationPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.organizationPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.organizationPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.organizationPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Organization fetchOrganization(long organizationId) {
        return this.organizationPersistence.fetchByPrimaryKey(organizationId);
    }

    public Organization fetchOrganizationByUuidAndCompanyId(String uuid, long companyId) {
        return this.organizationPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public Organization fetchOrganizationByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.organizationPersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public Organization getOrganizationByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.organizationPersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public Organization getOrganization(long organizationId) throws PortalException {
        return this.organizationPersistence.findByPrimaryKey(organizationId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.organizationLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Organization.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("organizationId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.organizationLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Organization.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("organizationId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.organizationLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Organization.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("organizationId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Organization>(){

            public void performAction(Organization organization) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)Organization.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.organizationPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement OrganizationLocalServiceImpl#deleteOrganization(Organization) to avoid orphaned data");
        }
        return this.organizationLocalService.deleteOrganization((Organization)persistedModel);
    }

    public BasePersistence<Organization> getBasePersistence() {
        return this.organizationPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.organizationPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public Organization getOrganizationByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.organizationPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<Organization> getOrganizations(int start, int end) {
        return this.organizationPersistence.findAll(start, end);
    }

    public int getOrganizationsCount() {
        return this.organizationPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Organization updateOrganization(Organization organization) {
        return (Organization)this.organizationPersistence.update((BaseModel)organization);
    }

    public boolean addGroupOrganization(long groupId, long organizationId) {
        return this.groupPersistence.addOrganization(groupId, organizationId);
    }

    public boolean addGroupOrganization(long groupId, Organization organization) {
        return this.groupPersistence.addOrganization(groupId, organization);
    }

    public boolean addGroupOrganizations(long groupId, long[] organizationIds) {
        return this.groupPersistence.addOrganizations(groupId, organizationIds);
    }

    public boolean addGroupOrganizations(long groupId, List<Organization> organizations) {
        return this.groupPersistence.addOrganizations(groupId, organizations);
    }

    public void clearGroupOrganizations(long groupId) {
        this.groupPersistence.clearOrganizations(groupId);
    }

    public void deleteGroupOrganization(long groupId, long organizationId) {
        this.groupPersistence.removeOrganization(groupId, organizationId);
    }

    public void deleteGroupOrganization(long groupId, Organization organization) {
        this.groupPersistence.removeOrganization(groupId, organization);
    }

    public void deleteGroupOrganizations(long groupId, long[] organizationIds) {
        this.groupPersistence.removeOrganizations(groupId, organizationIds);
    }

    public void deleteGroupOrganizations(long groupId, List<Organization> organizations) {
        this.groupPersistence.removeOrganizations(groupId, organizations);
    }

    public long[] getGroupPrimaryKeys(long organizationId) {
        return this.organizationPersistence.getGroupPrimaryKeys(organizationId);
    }

    public List<Organization> getGroupOrganizations(long groupId) {
        return this.groupPersistence.getOrganizations(groupId);
    }

    public List<Organization> getGroupOrganizations(long groupId, int start, int end) {
        return this.groupPersistence.getOrganizations(groupId, start, end);
    }

    public List<Organization> getGroupOrganizations(long groupId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.groupPersistence.getOrganizations(groupId, start, end, orderByComparator);
    }

    public int getGroupOrganizationsCount(long groupId) {
        return this.groupPersistence.getOrganizationsSize(groupId);
    }

    public boolean hasGroupOrganization(long groupId, long organizationId) {
        return this.groupPersistence.containsOrganization(groupId, organizationId);
    }

    public boolean hasGroupOrganizations(long groupId) {
        return this.groupPersistence.containsOrganizations(groupId);
    }

    public void setGroupOrganizations(long groupId, long[] organizationIds) {
        this.groupPersistence.setOrganizations(groupId, organizationIds);
    }

    public boolean addUserOrganization(long userId, long organizationId) {
        return this.userPersistence.addOrganization(userId, organizationId);
    }

    public boolean addUserOrganization(long userId, Organization organization) {
        return this.userPersistence.addOrganization(userId, organization);
    }

    public boolean addUserOrganizations(long userId, long[] organizationIds) {
        return this.userPersistence.addOrganizations(userId, organizationIds);
    }

    public boolean addUserOrganizations(long userId, List<Organization> organizations) {
        return this.userPersistence.addOrganizations(userId, organizations);
    }

    public void clearUserOrganizations(long userId) {
        this.userPersistence.clearOrganizations(userId);
    }

    public void deleteUserOrganization(long userId, long organizationId) {
        this.userPersistence.removeOrganization(userId, organizationId);
    }

    public void deleteUserOrganization(long userId, Organization organization) {
        this.userPersistence.removeOrganization(userId, organization);
    }

    public void deleteUserOrganizations(long userId, long[] organizationIds) {
        this.userPersistence.removeOrganizations(userId, organizationIds);
    }

    public void deleteUserOrganizations(long userId, List<Organization> organizations) {
        this.userPersistence.removeOrganizations(userId, organizations);
    }

    public long[] getUserPrimaryKeys(long organizationId) {
        return this.organizationPersistence.getUserPrimaryKeys(organizationId);
    }

    public List<Organization> getUserOrganizations(long userId) {
        return this.userPersistence.getOrganizations(userId);
    }

    public List<Organization> getUserOrganizations(long userId, int start, int end) {
        return this.userPersistence.getOrganizations(userId, start, end);
    }

    public List<Organization> getUserOrganizations(long userId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.userPersistence.getOrganizations(userId, start, end, orderByComparator);
    }

    public int getUserOrganizationsCount(long userId) {
        return this.userPersistence.getOrganizationsSize(userId);
    }

    public boolean hasUserOrganization(long userId, long organizationId) {
        return this.userPersistence.containsOrganization(userId, organizationId);
    }

    public boolean hasUserOrganizations(long userId) {
        return this.userPersistence.containsOrganizations(userId);
    }

    public void setUserOrganizations(long userId, long[] organizationIds) {
        this.userPersistence.setOrganizations(userId, organizationIds);
    }

    public OrganizationLocalService getOrganizationLocalService() {
        return this.organizationLocalService;
    }

    public void setOrganizationLocalService(OrganizationLocalService organizationLocalService) {
        this.organizationLocalService = organizationLocalService;
    }

    public OrganizationPersistence getOrganizationPersistence() {
        return this.organizationPersistence;
    }

    public void setOrganizationPersistence(OrganizationPersistence organizationPersistence) {
        this.organizationPersistence = organizationPersistence;
    }

    public OrganizationFinder getOrganizationFinder() {
        return this.organizationFinder;
    }

    public void setOrganizationFinder(OrganizationFinder organizationFinder) {
        this.organizationFinder = organizationFinder;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        OrganizationLocalServiceUtil.setService((OrganizationLocalService)this.organizationLocalService);
    }

    public void destroy() {
        OrganizationLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return OrganizationLocalService.class.getName();
    }

    public CTPersistence<Organization> getCTPersistence() {
        return this.organizationPersistence;
    }

    public Class<Organization> getModelClass() {
        return Organization.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<Organization>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.organizationPersistence);
    }

    protected String getModelClassName() {
        return Organization.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.organizationPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

