/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.kernel.service.PortletItemLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.PortletItemPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;

public abstract class PortletItemLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
PortletItemLocalService {
    @BeanReference(type=PortletItemLocalService.class)
    protected PortletItemLocalService portletItemLocalService;
    @BeanReference(type=PortletItemPersistence.class)
    protected PortletItemPersistence portletItemPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(PortletItemLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public PortletItem addPortletItem(PortletItem portletItem) {
        portletItem.setNew(true);
        return (PortletItem)this.portletItemPersistence.update((BaseModel)portletItem);
    }

    @Transactional(enabled=false)
    public PortletItem createPortletItem(long portletItemId) {
        return this.portletItemPersistence.create(portletItemId);
    }

    @Indexable(type=IndexableType.DELETE)
    public PortletItem deletePortletItem(long portletItemId) throws PortalException {
        return this.portletItemPersistence.remove(portletItemId);
    }

    @Indexable(type=IndexableType.DELETE)
    public PortletItem deletePortletItem(PortletItem portletItem) {
        return (PortletItem)this.portletItemPersistence.remove((BaseModel)portletItem);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.portletItemPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(PortletItem.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.portletItemPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.portletItemPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.portletItemPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.portletItemPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.portletItemPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public PortletItem fetchPortletItem(long portletItemId) {
        return this.portletItemPersistence.fetchByPrimaryKey(portletItemId);
    }

    public PortletItem getPortletItem(long portletItemId) throws PortalException {
        return this.portletItemPersistence.findByPrimaryKey(portletItemId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.portletItemLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(PortletItem.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("portletItemId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.portletItemLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(PortletItem.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("portletItemId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.portletItemLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(PortletItem.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("portletItemId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.portletItemPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement PortletItemLocalServiceImpl#deletePortletItem(PortletItem) to avoid orphaned data");
        }
        return this.portletItemLocalService.deletePortletItem((PortletItem)persistedModel);
    }

    public BasePersistence<PortletItem> getBasePersistence() {
        return this.portletItemPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.portletItemPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<PortletItem> getPortletItems(int start, int end) {
        return this.portletItemPersistence.findAll(start, end);
    }

    public int getPortletItemsCount() {
        return this.portletItemPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public PortletItem updatePortletItem(PortletItem portletItem) {
        return (PortletItem)this.portletItemPersistence.update((BaseModel)portletItem);
    }

    public PortletItemLocalService getPortletItemLocalService() {
        return this.portletItemLocalService;
    }

    public void setPortletItemLocalService(PortletItemLocalService portletItemLocalService) {
        this.portletItemLocalService = portletItemLocalService;
    }

    public PortletItemPersistence getPortletItemPersistence() {
        return this.portletItemPersistence;
    }

    public void setPortletItemPersistence(PortletItemPersistence portletItemPersistence) {
        this.portletItemPersistence = portletItemPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        PortletItemLocalServiceUtil.setService((PortletItemLocalService)this.portletItemLocalService);
    }

    public void destroy() {
        PortletItemLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return PortletItemLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return PortletItem.class;
    }

    protected String getModelClassName() {
        return PortletItem.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.portletItemPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

