/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.RegionLocalization;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.RegionLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.RegionLocalizationPersistence;
import com.liferay.portal.kernel.service.persistence.RegionPersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public abstract class RegionLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
RegionLocalService {
    @BeanReference(type=RegionLocalService.class)
    protected RegionLocalService regionLocalService;
    @BeanReference(type=RegionPersistence.class)
    protected RegionPersistence regionPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=RegionLocalizationPersistence.class)
    protected RegionLocalizationPersistence regionLocalizationPersistence;
    private static final Log _log = LogFactoryUtil.getLog(RegionLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Region addRegion(Region region) {
        region.setNew(true);
        return (Region)this.regionPersistence.update((BaseModel)region);
    }

    @Transactional(enabled=false)
    public Region createRegion(long regionId) {
        return this.regionPersistence.create(regionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Region deleteRegion(long regionId) throws PortalException {
        return this.regionPersistence.remove(regionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Region deleteRegion(Region region) {
        return (Region)this.regionPersistence.remove((BaseModel)region);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.regionPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Region.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.regionPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.regionPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.regionPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.regionPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.regionPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Region fetchRegion(long regionId) {
        return this.regionPersistence.fetchByPrimaryKey(regionId);
    }

    public Region fetchRegionByUuidAndCompanyId(String uuid, long companyId) {
        return this.regionPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public Region getRegion(long regionId) throws PortalException {
        return this.regionPersistence.findByPrimaryKey(regionId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.regionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Region.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("regionId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.regionLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Region.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("regionId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.regionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Region.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("regionId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Region>(){

            public void performAction(Region region) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)region);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)Region.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.regionPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement RegionLocalServiceImpl#deleteRegion(Region) to avoid orphaned data");
        }
        return this.regionLocalService.deleteRegion((Region)persistedModel);
    }

    public BasePersistence<Region> getBasePersistence() {
        return this.regionPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.regionPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public Region getRegionByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.regionPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<Region> getRegions(int start, int end) {
        return this.regionPersistence.findAll(start, end);
    }

    public int getRegionsCount() {
        return this.regionPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Region updateRegion(Region region) {
        return (Region)this.regionPersistence.update((BaseModel)region);
    }

    public RegionLocalization fetchRegionLocalization(long regionId, String languageId) {
        return this.regionLocalizationPersistence.fetchByRegionId_LanguageId(regionId, languageId);
    }

    public RegionLocalization getRegionLocalization(long regionId, String languageId) throws PortalException {
        return this.regionLocalizationPersistence.findByRegionId_LanguageId(regionId, languageId);
    }

    public List<RegionLocalization> getRegionLocalizations(long regionId) {
        return this.regionLocalizationPersistence.findByRegionId(regionId);
    }

    public RegionLocalization updateRegionLocalization(Region region, String languageId, String title) throws PortalException {
        region = this.regionPersistence.findByPrimaryKey(region.getPrimaryKey());
        RegionLocalization regionLocalization = this.regionLocalizationPersistence.fetchByRegionId_LanguageId(region.getRegionId(), languageId);
        return this._updateRegionLocalization(region, regionLocalization, languageId, title);
    }

    public List<RegionLocalization> updateRegionLocalizations(Region region, Map<String, String> titleMap) throws PortalException {
        String[] localizedValues;
        region = this.regionPersistence.findByPrimaryKey(region.getPrimaryKey());
        HashMap<String, String[]> localizedValuesMap = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : titleMap.entrySet()) {
            String languageId = entry.getKey();
            localizedValues = (String[])localizedValuesMap.get(languageId);
            if (localizedValues == null) {
                localizedValues = new String[1];
                localizedValuesMap.put(languageId, localizedValues);
            }
            localizedValues[0] = (String)entry.getValue();
        }
        ArrayList<RegionLocalization> regionLocalizations = new ArrayList<RegionLocalization>(localizedValuesMap.size());
        for (RegionLocalization regionLocalization : this.regionLocalizationPersistence.findByRegionId(region.getRegionId())) {
            localizedValues = (String[])localizedValuesMap.remove(regionLocalization.getLanguageId());
            if (localizedValues == null) {
                this.regionLocalizationPersistence.remove((BaseModel)regionLocalization);
                continue;
            }
            regionLocalization.setCtCollectionId(region.getCtCollectionId());
            regionLocalization.setCompanyId(region.getCompanyId());
            regionLocalization.setTitle(localizedValues[0]);
            regionLocalizations.add((RegionLocalization)this.regionLocalizationPersistence.update((BaseModel)regionLocalization));
        }
        long batchCounter = this.counterLocalService.increment(RegionLocalization.class.getName(), localizedValuesMap.size()) - (long)localizedValuesMap.size();
        for (Map.Entry entry : localizedValuesMap.entrySet()) {
            String languageId = (String)entry.getKey();
            String[] localizedValues2 = (String[])entry.getValue();
            RegionLocalization regionLocalization = this.regionLocalizationPersistence.create(++batchCounter);
            regionLocalization.setCtCollectionId(region.getCtCollectionId());
            regionLocalization.setRegionId(region.getRegionId());
            regionLocalization.setCompanyId(region.getCompanyId());
            regionLocalization.setLanguageId(languageId);
            regionLocalization.setTitle(localizedValues2[0]);
            regionLocalizations.add((RegionLocalization)this.regionLocalizationPersistence.update((BaseModel)regionLocalization));
        }
        return regionLocalizations;
    }

    private RegionLocalization _updateRegionLocalization(Region region, RegionLocalization regionLocalization, String languageId, String title) throws PortalException {
        if (regionLocalization == null) {
            long regionLocalizationId = this.counterLocalService.increment(RegionLocalization.class.getName());
            regionLocalization = this.regionLocalizationPersistence.create(regionLocalizationId);
            regionLocalization.setRegionId(region.getRegionId());
            regionLocalization.setLanguageId(languageId);
        }
        regionLocalization.setCtCollectionId(region.getCtCollectionId());
        regionLocalization.setCompanyId(region.getCompanyId());
        regionLocalization.setTitle(title);
        return (RegionLocalization)this.regionLocalizationPersistence.update((BaseModel)regionLocalization);
    }

    public RegionLocalService getRegionLocalService() {
        return this.regionLocalService;
    }

    public void setRegionLocalService(RegionLocalService regionLocalService) {
        this.regionLocalService = regionLocalService;
    }

    public RegionPersistence getRegionPersistence() {
        return this.regionPersistence;
    }

    public void setRegionPersistence(RegionPersistence regionPersistence) {
        this.regionPersistence = regionPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public RegionLocalizationPersistence getRegionLocalizationPersistence() {
        return this.regionLocalizationPersistence;
    }

    public void setRegionLocalizationPersistence(RegionLocalizationPersistence regionLocalizationPersistence) {
        this.regionLocalizationPersistence = regionLocalizationPersistence;
    }

    public void afterPropertiesSet() {
        RegionLocalServiceUtil.setService((RegionLocalService)this.regionLocalService);
    }

    public void destroy() {
        RegionLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return RegionLocalService.class.getName();
    }

    public CTPersistence<Region> getCTPersistence() {
        return this.regionPersistence;
    }

    public Class<Region> getModelClass() {
        return Region.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<Region>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.regionPersistence);
    }

    protected String getModelClassName() {
        return Region.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.regionPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

