/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.service.base.ClassNameLocalServiceBaseImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@CTAware
public class ClassNameLocalServiceImpl
extends ClassNameLocalServiceBaseImpl
implements CacheRegistryItem {
    private static final Log _log = LogFactoryUtil.getLog(ClassNameLocalServiceImpl.class);
    private static final ClassName _nullClassName = new ClassNameImpl();

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ClassName addClassName(String value) {
        ClassName className = this.classNamePersistence.fetchByValue(value);
        if (className == null) {
            long classNameId = this.counterLocalService.increment();
            className = this.classNamePersistence.create(classNameId);
            className.setValue(value);
            className = (ClassName)this.classNamePersistence.update((BaseModel)className);
        }
        ClassNamePool.add(className);
        return className;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkClassNames() {
        List classNames = this.classNamePersistence.findAll();
        for (ClassName className : classNames) {
            ClassNamePool.add(className);
        }
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            this.getClassName(model);
        }
    }

    @Override
    public ClassName deleteClassName(ClassName className) {
        ClassName removedClassName = (ClassName)this.classNamePersistence.remove((BaseModel)className);
        ClassNamePool.remove(className);
        return removedClassName;
    }

    public ClassName fetchByClassNameId(long classNameId) {
        ClassName className = ClassNamePool.fetchByClassNameId(classNameId);
        if (className == null) {
            className = this.classNamePersistence.fetchByPrimaryKey(classNameId);
        }
        ClassNamePool.add(className);
        return className;
    }

    public ClassName fetchClassName(String value) {
        if (Validator.isNull((String)value)) {
            return _nullClassName;
        }
        ClassName className = ClassNamePool.fetchByValue(value);
        if (className == null) {
            className = this.classNamePersistence.fetchByValue(value);
        }
        if (className == null) {
            return _nullClassName;
        }
        ClassNamePool.add(className);
        return className;
    }

    @Transactional(enabled=false)
    public ClassName getClassName(String value) {
        if (Validator.isNull((String)value)) {
            return _nullClassName;
        }
        ClassName className = ClassNamePool.fetchByValue(value);
        if (className != null) {
            return className;
        }
        try {
            return this.classNameLocalService.addClassName(value);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug(throwable);
            }
            return ClassNamePool.fetchByValue(value);
        }
    }

    @Transactional(enabled=false)
    public long getClassNameId(Class<?> clazz) {
        return this.getClassNameId(clazz.getName());
    }

    @Transactional(enabled=false)
    public long getClassNameId(String value) {
        ClassName className = this.getClassName(value);
        return className.getClassNameId();
    }

    public Supplier<long[]> getClassNameIdsSupplier(String[] classNames) {
        ConcurrentHashMap classNameIds = new ConcurrentHashMap();
        return () -> classNameIds.computeIfAbsent(ClassNameLocalServiceImpl._getCompanyId(), key -> TransformUtil.transformToLongArray((Collection)ListUtil.fromArray((Object[])classNames), className -> this.getClassNameId((String)className)));
    }

    public Supplier<Long> getClassNameIdSupplier(String className) {
        return () -> this.getClassNameId(className);
    }

    public String getRegistryName() {
        return ClassNameLocalServiceImpl.class.getName();
    }

    public void invalidate() {
        if (DBPartition.isPartitionEnabled() && CompanyThreadLocal.getCompanyId() != 0L) {
            ClassNamePool.invalidate(CompanyThreadLocal.getCompanyId());
            return;
        }
        ClassNamePool.invalidate();
    }

    private static long _getCompanyId() {
        if (DBPartition.isPartitionEnabled()) {
            return CompanyThreadLocal.getNonsystemCompanyId();
        }
        return 0L;
    }

    private static class ClassNamePool {
        private static Map<Long, Map<String, Long>> _classNameIdsMap = new ConcurrentHashMap<Long, Map<String, Long>>();
        private static Map<Long, Map<Long, ClassName>> _classNamesMap = new ConcurrentHashMap<Long, Map<Long, ClassName>>();

        private ClassNamePool() {
        }

        public static void add(ClassName className) {
            if (className == null) {
                return;
            }
            Map classNameIds = ClassNamePool._getMap(_classNameIdsMap);
            classNameIds.put(className.getValue(), className.getClassNameId());
            Map classNames = ClassNamePool._getMap(_classNamesMap);
            classNames.put(className.getClassNameId(), className);
        }

        public static ClassName fetchByClassNameId(long classNameId) {
            Map classNames = ClassNamePool._getMap(_classNamesMap);
            return (ClassName)classNames.get(classNameId);
        }

        public static ClassName fetchByValue(String value) {
            Map classNameIds = ClassNamePool._getMap(_classNameIdsMap);
            Long classNameId = (Long)classNameIds.get(value);
            if (classNameId == null) {
                return null;
            }
            Map classNames = ClassNamePool._getMap(_classNamesMap);
            return (ClassName)classNames.get(classNameId);
        }

        public static void invalidate() {
            for (Map<String, Long> map : _classNameIdsMap.values()) {
                map.clear();
            }
            for (Map<Object, Long> map : _classNamesMap.values()) {
                map.clear();
            }
        }

        public static void invalidate(long companyId) {
            _classNameIdsMap.remove(companyId);
            _classNamesMap.remove(companyId);
        }

        public static void remove(ClassName className) {
            _classNameIdsMap.computeIfPresent(ClassNameLocalServiceImpl._getCompanyId(), (key, classNameIds) -> {
                classNameIds.remove(className.getValue());
                return classNameIds;
            });
            _classNamesMap.computeIfPresent(ClassNameLocalServiceImpl._getCompanyId(), (key, classNames) -> {
                classNames.remove(className.getClassNameId());
                return classNames;
            });
        }

        private static <S, T> Map<S, T> _getMap(Map<Long, Map<S, T>> map) {
            return map.computeIfAbsent(ClassNameLocalServiceImpl._getCompanyId(), companyId -> new ConcurrentHashMap());
        }
    }
}

