/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.LayoutReference;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.PluginSettingLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.service.base.LayoutServiceBaseImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class LayoutServiceImpl
extends LayoutServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutServiceImpl.class);
    @BeanReference(type=ExportImportConfigurationLocalService.class)
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=LayoutSetLocalService.class)
    private LayoutSetLocalService _layoutSetLocalService;
    @BeanReference(type=PluginSettingLocalService.class)
    private PluginSettingLocalService _pluginSettingLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public Layout addLayout(String externalReferenceCode, long groupId, boolean privateLayout, long parentLayoutId, long classNameId, long classPK, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, long masterLayoutPlid, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        Layout layout = this.layoutLocalService.addLayout(externalReferenceCode, this.getUserId(), groupId, privateLayout, parentLayoutId, classNameId, classPK, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, system, friendlyURLMap, masterLayoutPlid, serviceContext);
        this.checkLayoutTypeSettings(layout, "", typeSettings);
        return layout;
    }

    public Layout addLayout(String externalReferenceCode, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, long masterLayoutPlid, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(externalReferenceCode, groupId, privateLayout, parentLayoutId, 0L, 0L, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, false, friendlyURLMap, masterLayoutPlid, serviceContext);
    }

    public Layout addLayout(String externalReferenceCode, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(externalReferenceCode, groupId, privateLayout, parentLayoutId, 0L, 0L, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, false, friendlyURLMap, 0L, serviceContext);
    }

    public Layout addLayout(String externalReferenceCode, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        return this.layoutLocalService.addLayout(externalReferenceCode, this.getUserId(), groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext);
    }

    public FileEntry addTempFileEntry(long groupId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}), (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    public Layout copyLayout(long groupId, boolean privateLayout, Map<Locale, String> localeNamesMap, boolean hidden, boolean system, boolean copyPermissions, long sourcePlid, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        Layout sourceLayout = this.layoutLocalService.getLayout(sourcePlid);
        long parentLayoutId = sourceLayout.getParentLayoutId();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        return this.layoutLocalService.copyLayout(this.getUserId(), groupId, privateLayout, localeNamesMap, hidden, system, copyPermissions, sourcePlid, serviceContext);
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"DELETE");
        this.layoutLocalService.deleteLayout(groupId, privateLayout, layoutId, serviceContext);
    }

    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"DELETE");
        this.layoutLocalService.deleteLayout(plid, serviceContext);
    }

    public void deleteLayout(String externalReferenceCode, long groupId) throws PortalException {
        Layout layout = this.getLayoutByExternalReferenceCode(externalReferenceCode, groupId);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"DELETE");
        this.layoutLocalService.deleteLayout(layout);
    }

    public void deleteTempFileEntry(long groupId, String folderName, String fileName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}), (String)fileName);
    }

    public Layout fetchFirstLayout(long groupId, boolean privateLayout, boolean published) {
        List layouts = this.layoutLocalService.getLayouts(groupId, privateLayout, 0L, true, 0, 1);
        if (layouts.isEmpty()) {
            return null;
        }
        Layout layout = (Layout)layouts.get(0);
        if ((!published || layout.isPublished()) && this._hasViewPermission(layout)) {
            return layout;
        }
        return this._getFirstLayout(groupId, privateLayout, published);
    }

    public Layout fetchLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException {
        Layout layout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layout != null) {
            LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        }
        return layout;
    }

    public Layout fetchLayoutByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        Layout layout = this.layoutLocalService.fetchLayoutByExternalReferenceCode(externalReferenceCode, groupId);
        if (layout != null) {
            LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        }
        return layout;
    }

    public long fetchLayoutPlid(String uuid, long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this.layoutLocalService.fetchLayout(uuid, groupId, privateLayout);
        if (layout != null) {
            LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
            return layout.getPlid();
        }
        return 0L;
    }

    public List<Layout> getAncestorLayouts(long plid) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        return this.filterLayouts(layout.getAncestors());
    }

    public long getControlPanelLayoutPlid() throws PortalException {
        Group group = this._groupLocalService.fetchGroup(CompanyThreadLocal.getCompanyId().longValue(), "Control Panel");
        List layouts = this.layoutLocalService.getLayouts(group.getGroupId(), true);
        if (ListUtil.isEmpty((List)layouts)) {
            throw new NoSuchLayoutException("Unable to get control panel layout");
        }
        Layout layout = (Layout)layouts.get(0);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout.getPlid();
    }

    public long getDefaultPlid(long groupId, boolean privateLayout) {
        return this.layoutLocalService.getDefaultPlid(groupId, privateLayout);
    }

    public long getDefaultPlid(long groupId, long scopeGroupId, boolean privateLayout, String portletId) throws PortalException {
        if (groupId <= 0L) {
            return 0L;
        }
        String scopeGroupLayoutUuid = null;
        Group scopeGroup = this._groupLocalService.getGroup(scopeGroupId);
        if (scopeGroup.isLayout()) {
            Layout scopeGroupLayout = this.layoutLocalService.getLayout(scopeGroup.getClassPK());
            scopeGroupLayoutUuid = scopeGroupLayout.getUuid();
        }
        Map jxPortletPreferencesMap = PortletPreferencesFactoryUtil.getPortletSetupMap((long)scopeGroup.getCompanyId(), (long)groupId, (long)0L, (int)3, (String)portletId, (boolean)privateLayout);
        for (Map.Entry entry : jxPortletPreferencesMap.entrySet()) {
            LayoutTypePortlet layoutTypePortlet;
            long plid = (Long)entry.getKey();
            Layout layout = null;
            try {
                layout = this.layoutLocalService.getLayout(plid);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)noSuchLayoutException);
                continue;
            }
            if (!this._hasViewPermission(layout) || !layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
            PortletPreferences jxPortletPreferences = (PortletPreferences)entry.getValue();
            String scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
            if (scopeGroup.isLayout()) {
                String scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
                if (!Validator.isNotNull((String)scopeType) || !Validator.isNotNull((String)scopeLayoutUuid) || !scopeLayoutUuid.equals(scopeGroupLayoutUuid)) continue;
                return layout.getPlid();
            }
            if (!(scopeGroup.isCompany() ? Validator.isNotNull((String)scopeType) && scopeType.equals("company") : Validator.isNull((String)scopeType))) continue;
            return layout.getPlid();
        }
        return 0L;
    }

    @ThreadLocalCachable
    public long getDefaultPlid(long groupId, long scopeGroupId, String portletId) throws PortalException {
        long plid = this.getDefaultPlid(groupId, scopeGroupId, false, portletId);
        if (plid == 0L) {
            plid = this.getDefaultPlid(groupId, scopeGroupId, true, portletId);
        }
        return plid;
    }

    public Layout getLayoutByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        Layout layout = this.layoutLocalService.getLayoutByExternalReferenceCode(externalReferenceCode, groupId);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout;
    }

    public Layout getLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this.layoutLocalService.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout;
    }

    public String getLayoutName(long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout.getName(languageId);
    }

    public long getLayoutPlid(String uuid, long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this.layoutLocalService.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout.getPlid();
    }

    public LayoutReference[] getLayoutReferences(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        LayoutReference[] layoutReferences = this.layoutLocalService.getLayouts(companyId, portletId, preferencesKey, preferencesValue);
        ArrayList<LayoutReference> filteredLayoutReferences = new ArrayList<LayoutReference>(layoutReferences.length);
        for (LayoutReference layoutReference : layoutReferences) {
            try {
                LayoutModel layoutModel = layoutReference.getLayoutModel();
                if (!LayoutPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)layoutModel.getPlid(), (String)"VIEW")) continue;
                filteredLayoutReferences.add(layoutReference);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
        return filteredLayoutReferences.toArray(new LayoutReference[0]);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout) {
        return this.layoutPersistence.filterFindByG_P(groupId, privateLayout);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) throws PortalException {
        return this.filterLayouts(this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId));
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) throws PortalException {
        if (incomplete) {
            return this.filterLayouts(this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end));
        }
        Group group = this._groupLocalService.getGroup(groupId);
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
        if (!MergeLayoutPrototypesThreadLocal.isInProgress() && (layoutSet.isLayoutSetPrototypeLinkActive() || group.isUser() || group.isUserGroup() && parentLayoutId != 0L)) {
            return this.filterLayouts(this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end));
        }
        return this.layoutPersistence.filterFindByG_P_P(groupId, privateLayout, parentLayoutId, start, end, null);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, int start, int end) throws PortalException {
        return this.filterLayouts(this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId), start, end);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type) throws PortalException {
        return this.filterLayouts(this.layoutLocalService.getLayouts(groupId, privateLayout, type));
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type, int start, int end) throws PortalException {
        return this.layoutPersistence.filterFindByG_P_T(groupId, privateLayout, type, start, end);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String keywords, String[] types, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.layoutPersistence.filterFindByG_P(groupId, privateLayout, start, end, orderByComparator);
        }
        return this.layoutLocalService.getLayouts(groupId, this.getUserId(), privateLayout, keywords, types, start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String keywords, String[] types, int[] statuses, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.layoutPersistence.filterFindByG_P_ST(groupId, privateLayout, statuses, start, end, orderByComparator);
        }
        return this.layoutLocalService.getLayouts(groupId, this.getUserId(), privateLayout, keywords, types, statuses, start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, String type) {
        return this.layoutPersistence.filterFindByG_T(groupId, type);
    }

    public List<Layout> getLayouts(long groupId, String type, int start, int end) {
        return this.layoutPersistence.filterFindByG_T(groupId, type, start, end);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout) {
        return this.layoutPersistence.filterCountByG_P(groupId, privateLayout);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId) {
        try {
            List<Layout> layouts = this.getLayouts(groupId, privateLayout, parentLayoutId);
            return layouts.size();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return 0;
        }
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId, int priority) {
        return this.layoutPersistence.filterCountByG_P_P_LteP(groupId, privateLayout, parentLayoutId, priority);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, String type) {
        return this.layoutPersistence.filterCountByG_P_T(groupId, privateLayout, type);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, String keywords, String[] types) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.layoutPersistence.filterCountByG_P(groupId, privateLayout);
        }
        return this.layoutLocalService.getLayoutsCount(groupId, this.getUserId(), privateLayout, keywords, types);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, String keywords, String[] types, int[] statuses) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.layoutPersistence.filterCountByG_P_ST(groupId, privateLayout, statuses);
        }
        return this.layoutLocalService.getLayoutsCount(groupId, this.getUserId(), privateLayout, keywords, types, statuses);
    }

    public int getLayoutsCount(long groupId, String type) {
        return this.layoutPersistence.filterCountByG_T(groupId, type);
    }

    public String[] getTempFileNames(long groupId, String folderName) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"EXPORT_IMPORT_LAYOUTS");
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)group.getCtCollectionId());){
            String[] stringArray = TempFileEntryUtil.getTempFileNames((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}));
            return stringArray;
        }
    }

    public boolean hasLayout(String uuid, long groupId, boolean privateLayout) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        return this.layoutLocalService.hasLayout(uuid, groupId, privateLayout);
    }

    public boolean hasPortletId(long plid, String portletId) throws PortalException {
        LayoutTypePortlet layoutTypePortlet;
        Layout layout = this.layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return false;
        }
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        LayoutType layoutType = layout.getLayoutType();
        return layoutType instanceof LayoutTypePortlet && (layoutTypePortlet = (LayoutTypePortlet)layoutType).hasPortletId(portletId);
    }

    public Layout publishLayout(long plid) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void schedulePublishToLive(long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"PUBLISH_STAGING");
        User user = this._userPersistence.findByPrimaryKey(this.getUserId());
        Map publishLayoutLocalSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildPublishLayoutLocalSettingsMap((User)user, (long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap);
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(this.getUserId(), description, 3, publishLayoutLocalSettingsMap);
        long companyId = exportImportConfiguration.getCompanyId();
        Trigger trigger = TriggerFactoryUtil.createTrigger((String)StringBundler.concat((Object[])new Object[]{PortalUUIDUtil.generate(), "@", companyId}), (String)groupName, (Date)schedulerStartDate, (Date)schedulerEndDate, (String)cronText, (TimeZone)TimeZone.getTimeZone(MapUtil.getString(parameterMap, (String)"timeZoneId")));
        Message message = new Message();
        message.put("companyId", (Object)companyId);
        message.setPayload((Object)exportImportConfiguration.getExportImportConfigurationId());
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, (String)description, (String)"liferay/layouts_local_publisher", (Message)message);
    }

    public void schedulePublishToRemote(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)sourceGroupId, (String)"PUBLISH_STAGING");
        User user = this._userPersistence.findByPrimaryKey(this.getUserId());
        Map publishLayoutRemoteSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildPublishLayoutRemoteSettingsMap((long)this.getUserId(), (long)sourceGroupId, (boolean)privateLayout, layoutIdMap, parameterMap, (String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId, (boolean)remotePrivateLayout, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(this.getUserId(), description, 4, publishLayoutRemoteSettingsMap);
        long companyId = exportImportConfiguration.getCompanyId();
        Trigger trigger = TriggerFactoryUtil.createTrigger((String)StringBundler.concat((Object[])new Object[]{PortalUUIDUtil.generate(), "@", companyId}), (String)groupName, (Date)schedulerStartDate, (Date)schedulerEndDate, (String)cronText, (TimeZone)TimeZone.getTimeZone(MapUtil.getString(parameterMap, (String)"timeZoneId")));
        Message message = new Message();
        message.put("companyId", (Object)companyId);
        message.setPayload((Object)exportImportConfiguration.getExportImportConfigurationId());
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, (String)description, (String)"liferay/layouts_remote_publisher", (Message)message);
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        this.layoutLocalService.setLayouts(groupId, privateLayout, parentLayoutId, layoutIds, serviceContext);
    }

    public void unschedulePublishToLive(long groupId, String jobName, String groupName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete((String)jobName, (String)groupName, (StorageType)StorageType.PERSISTED);
    }

    public void unschedulePublishToRemote(long groupId, String jobName, String groupName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete((String)jobName, (String)groupName, (StorageType)StorageType.PERSISTED);
    }

    public Layout updateIconImage(long plid, byte[] bytes) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (long)plid);
        return this.layoutLocalService.updateIconImage(plid, bytes);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean hasIconImage, byte[] iconBytes, long styleBookEntryId, long faviconFileEntryId, long masterLayoutPlid, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (Layout)layout);
        Layout updatedLayout = this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, hasIconImage, iconBytes, styleBookEntryId, faviconFileEntryId, masterLayoutPlid, serviceContext);
        if (!(layout.getLayoutType() instanceof LayoutTypePortlet)) {
            this.checkLayoutTypeSettings(layout, "", updatedLayout.getTypeSettings());
        }
        return updatedLayout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (Layout)layout);
        this.checkLayoutTypeSettings(layout, layout.getTypeSettings(), typeSettings);
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (Layout)this.layoutLocalService.getLayout(groupId, privateLayout, layoutId));
        if (Validator.isNotNull((String)themeId)) {
            this._pluginSettingLocalService.checkPermission(this.getUserId(), themeId, "theme");
        }
        return this.layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (Layout)this.layoutLocalService.getLayout(groupId, privateLayout, layoutId));
        return this.layoutLocalService.updateName(groupId, privateLayout, layoutId, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (long)plid);
        return this.layoutLocalService.updateName(plid, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (Layout)this.layoutLocalService.getLayout(groupId, privateLayout, layoutId));
        return this.layoutLocalService.updateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (long)plid);
        return this.layoutLocalService.updateParentLayoutId(plid, parentPlid);
    }

    public Layout updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (long)plid);
        return this.layoutLocalService.updateParentLayoutIdAndPriority(plid, parentPlid, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (Layout)this.layoutLocalService.getLayout(groupId, privateLayout, layoutId));
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (Layout)this.layoutLocalService.getLayout(groupId, privateLayout, layoutId));
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, nextLayoutId, previousLayoutId);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (long)plid);
        return this.layoutLocalService.updatePriority(plid, priority);
    }

    public Layout updateType(long plid, String type) throws PortalException {
        LayoutPermissionUtil.checkLayoutUpdatePermission((PermissionChecker)this.getPermissionChecker(), (long)plid);
        return this.layoutLocalService.updateType(plid, type);
    }

    protected void checkLayoutTypeSettings(Layout layout, String originalTypeSettings, String newTypeSettings) throws PortalException {
        if (!(layout.getLayoutType() instanceof LayoutTypePortlet)) {
            return;
        }
        List<String> originalPortletIds = this.getPortletIds(layout, originalTypeSettings);
        List<String> newPortletIds = this.getPortletIds(layout, newTypeSettings);
        for (String portletId : newPortletIds) {
            if (originalPortletIds.contains(portletId)) continue;
            PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getPlid(), (String)portletId, (String)"ADD_TO_PAGE");
        }
    }

    protected List<Layout> filterLayouts(List<Layout> layouts) {
        ArrayList<Layout> filteredLayouts = new ArrayList<Layout>();
        for (Layout layout : layouts) {
            if (!this._hasViewPermission(layout)) continue;
            filteredLayouts.add(layout);
        }
        return filteredLayouts;
    }

    protected List<Layout> filterLayouts(List<Layout> layouts, int start, int end) throws PortalException {
        List<Layout> filteredLayouts = this.filterLayouts(layouts);
        if (filteredLayouts.size() < end) {
            end = filteredLayouts.size();
        }
        if (end <= start) {
            return Collections.emptyList();
        }
        return filteredLayouts.subList(start, end);
    }

    protected List<String> getPortletIds(Layout layout, String typeSettings) {
        if (Validator.isBlank((String)typeSettings)) {
            return Collections.emptyList();
        }
        Layout clonedLayout = (Layout)layout.clone();
        clonedLayout.setType("portlet");
        clonedLayout.setTypeSettings(typeSettings);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)clonedLayout.getLayoutType();
        return layoutTypePortlet.getPortletIds();
    }

    private Layout _getFirstLayout(long groupId, boolean privateLayout, boolean published) {
        boolean hasNext = true;
        int start = 1;
        int end = 0;
        int interval = 5;
        while (hasNext) {
            end = start + interval;
            List layouts = this.layoutLocalService.getLayouts(groupId, privateLayout, 0L, true, start, end);
            for (Layout layout : layouts) {
                if (published && !layout.isPublished() || !this._hasViewPermission(layout)) continue;
                return layout;
            }
            start += interval;
            if (layouts.size() >= interval) continue;
            hasNext = false;
        }
        return null;
    }

    private boolean _hasViewPermission(Layout layout) {
        block3: {
            try {
                if (LayoutPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW")) {
                    return true;
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)portalException);
            }
        }
        return false;
    }
}

