/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.DuplicatePasswordPolicyException;
import com.liferay.portal.kernel.exception.PasswordPolicyNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredPasswordPolicyException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PasswordPolicyRel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.PasswordPolicyRelLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.PasswordPolicyRelPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.PasswordPolicyLocalServiceBaseImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import java.util.List;

public class PasswordPolicyLocalServiceImpl
extends PasswordPolicyLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=PasswordPolicyRelLocalService.class)
    private PasswordPolicyRelLocalService _passwordPolicyRelLocalService;
    @BeanReference(type=PasswordPolicyRelPersistence.class)
    private PasswordPolicyRelPersistence _passwordPolicyRelPersistence;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public PasswordPolicy addPasswordPolicy(long userId, boolean defaultPolicy, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, String regex, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        this.validate(0L, user.getCompanyId(), name);
        long passwordPolicyId = this.counterLocalService.increment();
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.create(passwordPolicyId);
        passwordPolicy.setUuid(serviceContext.getUuid());
        passwordPolicy.setCompanyId(user.getCompanyId());
        passwordPolicy.setUserId(userId);
        passwordPolicy.setUserName(user.getFullName());
        passwordPolicy.setDefaultPolicy(defaultPolicy);
        passwordPolicy.setName(name);
        passwordPolicy.setDescription(description);
        passwordPolicy.setChangeable(changeable);
        passwordPolicy.setChangeRequired(changeRequired);
        passwordPolicy.setMinAge(minAge);
        passwordPolicy.setCheckSyntax(checkSyntax);
        passwordPolicy.setAllowDictionaryWords(allowDictionaryWords);
        passwordPolicy.setMinAlphanumeric(minAlphanumeric);
        passwordPolicy.setMinLength(minLength);
        passwordPolicy.setMinLowerCase(minLowerCase);
        passwordPolicy.setMinNumbers(minNumbers);
        passwordPolicy.setMinSymbols(minSymbols);
        passwordPolicy.setMinUpperCase(minUpperCase);
        passwordPolicy.setRegex(regex);
        passwordPolicy.setHistory(history);
        passwordPolicy.setHistoryCount(historyCount);
        passwordPolicy.setExpireable(expireable);
        passwordPolicy.setMaxAge(maxAge);
        passwordPolicy.setWarningTime(warningTime);
        passwordPolicy.setGraceLimit(graceLimit);
        passwordPolicy.setLockout(lockout);
        passwordPolicy.setMaxFailure(maxFailure);
        passwordPolicy.setLockoutDuration(lockoutDuration);
        passwordPolicy.setRequireUnlock(lockoutDuration == 0L);
        passwordPolicy.setResetFailureCount(resetFailureCount);
        passwordPolicy.setResetTicketMaxAge(resetTicketMaxAge);
        passwordPolicy.setExpandoBridgeAttributes(serviceContext);
        passwordPolicy = (PasswordPolicy)this.passwordPolicyPersistence.update((BaseModel)passwordPolicy);
        long ownerId = userId;
        if (user.isGuestUser()) {
            ownerId = 0L;
        }
        this._resourceLocalService.addResources(user.getCompanyId(), 0L, ownerId, PasswordPolicy.class.getName(), passwordPolicy.getPasswordPolicyId(), false, false, false);
        return passwordPolicy;
    }

    public void checkDefaultPasswordPolicy(long companyId) throws PortalException {
        String defaultPasswordPolicyName = PropsValues.PASSWORDS_DEFAULT_POLICY_NAME;
        PasswordPolicy defaultPasswordPolicy = this.passwordPolicyPersistence.fetchByC_N(companyId, defaultPasswordPolicyName);
        if (defaultPasswordPolicy != null) {
            return;
        }
        this.addPasswordPolicy(this._userLocalService.getGuestUserId(companyId), true, defaultPasswordPolicyName, defaultPasswordPolicyName, PropsValues.PASSWORDS_DEFAULT_POLICY_CHANGEABLE, PropsValues.PASSWORDS_DEFAULT_POLICY_CHANGE_REQUIRED, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_AGE, PropsValues.PASSWORDS_DEFAULT_POLICY_CHECK_SYNTAX, PropsValues.PASSWORDS_DEFAULT_POLICY_ALLOW_DICTIONARY_WORDS, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_ALPHANUMERIC, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_LENGTH, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_LOWERCASE, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_NUMBERS, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_SYMBOLS, PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_UPPERCASE, PropsValues.PASSWORDS_DEFAULT_POLICY_REGEX, PropsValues.PASSWORDS_DEFAULT_POLICY_HISTORY, PropsValues.PASSWORDS_DEFAULT_POLICY_HISTORY_COUNT, PropsValues.PASSWORDS_DEFAULT_POLICY_EXPIREABLE, PropsValues.PASSWORDS_DEFAULT_POLICY_MAX_AGE, PropsValues.PASSWORDS_DEFAULT_POLICY_WARNING_TIME, PropsValues.PASSWORDS_DEFAULT_POLICY_GRACE_LIMIT, PropsValues.PASSWORDS_DEFAULT_POLICY_LOCKOUT, PropsValues.PASSWORDS_DEFAULT_POLICY_MAX_FAILURE, PropsValues.PASSWORDS_DEFAULT_POLICY_LOCKOUT_DURATION, PropsValues.PASSWORDS_DEFAULT_POLICY_RESET_FAILURE_COUNT, PropsValues.PASSWORDS_DEFAULT_POLICY_RESET_TICKET_MAX_AGE, new ServiceContext());
    }

    public void deleteNondefaultPasswordPolicies(long companyId) throws PortalException {
        List passwordPolicies = this.passwordPolicyPersistence.findByCompanyId(companyId);
        for (PasswordPolicy passwordPolicy : passwordPolicies) {
            if (passwordPolicy.isDefaultPolicy()) continue;
            this.passwordPolicyLocalService.deletePasswordPolicy(passwordPolicy);
        }
    }

    @Override
    public PasswordPolicy deletePasswordPolicy(long passwordPolicyId) throws PortalException {
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.findByPrimaryKey(passwordPolicyId);
        return this.passwordPolicyLocalService.deletePasswordPolicy(passwordPolicy);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public PasswordPolicy deletePasswordPolicy(PasswordPolicy passwordPolicy) throws PortalException {
        if (passwordPolicy.isDefaultPolicy() && !PortalInstances.isCurrentCompanyInDeletionProcess()) {
            throw new RequiredPasswordPolicyException();
        }
        this._passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicy.getPasswordPolicyId());
        this._resourceLocalService.deleteResource(passwordPolicy.getCompanyId(), PasswordPolicy.class.getName(), 4, passwordPolicy.getPasswordPolicyId());
        return (PasswordPolicy)this.passwordPolicyPersistence.remove((BaseModel)passwordPolicy);
    }

    public PasswordPolicy fetchPasswordPolicy(long companyId, String name) {
        return this.passwordPolicyPersistence.fetchByC_N(companyId, name);
    }

    public PasswordPolicy getDefaultPasswordPolicy(long companyId) throws PortalException {
        return this.passwordPolicyPersistence.findByC_DP(companyId, true);
    }

    public PasswordPolicy getPasswordPolicy(long companyId, boolean defaultPolicy) throws PortalException {
        return this.passwordPolicyPersistence.findByC_DP(companyId, defaultPolicy);
    }

    public PasswordPolicy getPasswordPolicy(long companyId, long[] organizationIds) throws PortalException {
        if (ArrayUtil.isEmpty((long[])organizationIds)) {
            return this.getDefaultPasswordPolicy(companyId);
        }
        long classNameId = this._classNameLocalService.getClassNameId(Organization.class.getName());
        PasswordPolicyRel passwordPolicyRel = null;
        for (long organizationId : organizationIds) {
            passwordPolicyRel = this._passwordPolicyRelPersistence.fetchByC_C(classNameId, organizationId);
            if (passwordPolicyRel == null) continue;
            return this.passwordPolicyPersistence.findByPrimaryKey(passwordPolicyRel.getPasswordPolicyId());
        }
        return this.getDefaultPasswordPolicy(companyId);
    }

    public PasswordPolicy getPasswordPolicyByUser(User user) throws PortalException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getLdapServerId(), (long)user.getCompanyId())) {
            return null;
        }
        long count = this.passwordPolicyPersistence.countByCompanyId(user.getCompanyId());
        if (count == 1L) {
            return this.passwordPolicyPersistence.findByC_DP(user.getCompanyId(), true);
        }
        PasswordPolicyRel passwordPolicyRel = this._passwordPolicyRelPersistence.fetchByC_C(this._classNameLocalService.getClassNameId(User.class.getName()), user.getUserId());
        if (passwordPolicyRel != null) {
            return this.getPasswordPolicy(passwordPolicyRel.getPasswordPolicyId());
        }
        long[] organizationIds = this._userPersistence.getOrganizationPrimaryKeys(user.getUserId());
        if (organizationIds.length == 0) {
            return this.passwordPolicyPersistence.findByC_DP(user.getCompanyId(), true);
        }
        return this.getPasswordPolicy(user.getCompanyId(), organizationIds);
    }

    @ThreadLocalCachable
    public PasswordPolicy getPasswordPolicyByUserId(long userId) throws PortalException {
        return this.getPasswordPolicyByUser(this._userPersistence.findByPrimaryKey(userId));
    }

    public List<PasswordPolicy> search(long companyId, String name, int start, int end, OrderByComparator<PasswordPolicy> orderByComparator) {
        return this.passwordPolicyFinder.findByC_N(companyId, name, start, end, orderByComparator);
    }

    public int searchCount(long companyId, String name) {
        return this.passwordPolicyFinder.countByC_N(companyId, name);
    }

    public PasswordPolicy updatePasswordPolicy(long passwordPolicyId, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, String regex, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge, ServiceContext serviceContext) throws PortalException {
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.findByPrimaryKey(passwordPolicyId);
        if (!passwordPolicy.isDefaultPolicy()) {
            this.validate(passwordPolicyId, passwordPolicy.getCompanyId(), name);
            passwordPolicy.setName(name);
        }
        passwordPolicy.setDescription(description);
        passwordPolicy.setChangeable(changeable);
        passwordPolicy.setChangeRequired(changeRequired);
        passwordPolicy.setMinAge(minAge);
        passwordPolicy.setCheckSyntax(checkSyntax);
        passwordPolicy.setAllowDictionaryWords(allowDictionaryWords);
        passwordPolicy.setMinAlphanumeric(minAlphanumeric);
        passwordPolicy.setMinLength(minLength);
        passwordPolicy.setMinLowerCase(minLowerCase);
        passwordPolicy.setMinNumbers(minNumbers);
        passwordPolicy.setMinSymbols(minSymbols);
        passwordPolicy.setMinUpperCase(minUpperCase);
        passwordPolicy.setRegex(regex);
        passwordPolicy.setHistory(history);
        passwordPolicy.setHistoryCount(historyCount);
        passwordPolicy.setExpireable(expireable);
        passwordPolicy.setMaxAge(maxAge);
        passwordPolicy.setWarningTime(warningTime);
        passwordPolicy.setGraceLimit(graceLimit);
        passwordPolicy.setLockout(lockout);
        passwordPolicy.setMaxFailure(maxFailure);
        passwordPolicy.setLockoutDuration(lockoutDuration);
        passwordPolicy.setRequireUnlock(lockoutDuration == 0L);
        passwordPolicy.setResetFailureCount(resetFailureCount);
        passwordPolicy.setResetTicketMaxAge(resetTicketMaxAge);
        passwordPolicy.setExpandoBridgeAttributes(serviceContext);
        return (PasswordPolicy)this.passwordPolicyPersistence.update((BaseModel)passwordPolicy);
    }

    protected void validate(long passwordPolicyId, long companyId, String name) throws PortalException {
        if (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new PasswordPolicyNameException();
        }
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.fetchByC_N(companyId, name);
        if (passwordPolicy != null && passwordPolicy.getPasswordPolicyId() != passwordPolicyId) {
            throw new DuplicatePasswordPolicyException("{passwordPolicyId=" + passwordPolicyId + "}");
        }
    }
}

