/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.format.util.PhoneNumberFormatUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PhoneNumberException;
import com.liferay.portal.kernel.exception.PhoneNumberExtensionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.PhoneLocalServiceBaseImpl;
import java.util.List;

public class PhoneLocalServiceImpl
extends PhoneLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=ListTypeLocalService.class)
    private ListTypeLocalService _listTypeLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public Phone addPhone(String externalReferenceCode, long userId, String className, long classPK, String number, String extension, long listTypeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        long classNameId = this._classNameLocalService.getClassNameId(className);
        this.validate(0L, user.getCompanyId(), classNameId, classPK, number, extension, listTypeId, primary);
        long phoneId = this.counterLocalService.increment();
        Phone phone = this.phonePersistence.create(phoneId);
        phone.setUuid(serviceContext.getUuid());
        phone.setExternalReferenceCode(externalReferenceCode);
        phone.setCompanyId(user.getCompanyId());
        phone.setUserId(user.getUserId());
        phone.setUserName(user.getFullName());
        phone.setClassNameId(classNameId);
        phone.setClassPK(classPK);
        phone.setNumber(number);
        phone.setExtension(extension);
        phone.setListTypeId(listTypeId);
        phone.setPrimary(primary);
        return (Phone)this.phonePersistence.update((BaseModel)phone);
    }

    @Override
    public Phone deletePhone(long phoneId) throws PortalException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        return this.phoneLocalService.deletePhone(phone);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public Phone deletePhone(Phone phone) {
        this.phonePersistence.remove((BaseModel)phone);
        return phone;
    }

    public void deletePhones(long companyId, String className, long classPK) {
        List phones = this.phonePersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
        for (Phone phone : phones) {
            this.phoneLocalService.deletePhone(phone);
        }
    }

    public List<Phone> getPhones() {
        return this.phonePersistence.findAll();
    }

    public List<Phone> getPhones(long companyId, String className, long classPK) {
        return this.phonePersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public Phone updatePhone(String externalReferenceCode, long phoneId, String number, String extension, long listTypeId, boolean primary) throws PortalException {
        this.validate(phoneId, 0L, 0L, 0L, number, extension, listTypeId, primary);
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        phone.setExternalReferenceCode(externalReferenceCode);
        phone.setNumber(number);
        phone.setExtension(extension);
        phone.setListTypeId(listTypeId);
        phone.setPrimary(primary);
        return (Phone)this.phonePersistence.update((BaseModel)phone);
    }

    protected void validate(long phoneId, long companyId, long classNameId, long classPK, boolean primary) {
        if (primary) {
            List phones = this.phonePersistence.findByC_C_C_P(companyId, classNameId, classPK, primary);
            for (Phone phone : phones) {
                if (phoneId > 0L && phone.getPhoneId() == phoneId) continue;
                phone.setPrimary(false);
                this.phonePersistence.update((BaseModel)phone);
            }
        }
    }

    protected void validate(long phoneId, long companyId, long classNameId, long classPK, String number, String extension, long listTypeId, boolean primary) throws PortalException {
        if (!PhoneNumberFormatUtil.validate(number)) {
            throw new PhoneNumberException();
        }
        if (Validator.isNotNull((String)extension)) {
            for (int i = 0; i < extension.length(); ++i) {
                if (Character.isDigit(extension.charAt(i))) continue;
                throw new PhoneNumberExtensionException();
            }
        }
        if (phoneId > 0L) {
            Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
            companyId = phone.getCompanyId();
            classNameId = phone.getClassNameId();
            classPK = phone.getClassPK();
        }
        if (classNameId == this._classNameLocalService.getClassNameId(Company.class) || classNameId == this._classNameLocalService.getClassNameId(Contact.class) || classNameId == this._classNameLocalService.getClassNameId(Organization.class)) {
            this._listTypeLocalService.validate(listTypeId, classNameId, ".phone");
        }
        this.validate(phoneId, companyId, classNameId, classPK, primary);
    }
}

