/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mass.delete.MassDeleteCacheThreadLocal;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.persistence.ResourcePermissionPersistence;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.ResourceActionLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceActionLocalServiceImpl
extends ResourceActionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ResourceActionLocalServiceImpl.class);
    private static final Map<String, ResourceAction> _resourceActions = new ConcurrentHashMap<String, ResourceAction>();
    @BeanReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @BeanReference(type=ResourcePermissionLocalService.class)
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @BeanReference(type=ResourcePermissionPersistence.class)
    private ResourcePermissionPersistence _resourcePermissionPersistence;

    public ResourceAction addResourceAction(String name, String actionId, long bitwiseValue) {
        ResourceAction resourceAction = this.resourceActionPersistence.fetchByN_A(name, actionId);
        if (resourceAction == null) {
            long resourceActionId = this.counterLocalService.increment(ResourceAction.class.getName());
            resourceAction = this.resourceActionPersistence.create(resourceActionId);
            resourceAction.setName(name);
            resourceAction.setActionId(actionId);
            resourceAction.setBitwiseValue(bitwiseValue);
            resourceAction = (ResourceAction)this.resourceActionPersistence.update((BaseModel)resourceAction);
        }
        _resourceActions.put(this.encodeKey(name, actionId), resourceAction);
        return resourceAction;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkResourceActions() {
        List resourceActions = this.resourceActionPersistence.findAll();
        for (ResourceAction resourceAction : resourceActions) {
            String key = this.encodeKey(resourceAction.getName(), resourceAction.getActionId());
            _resourceActions.put(key, resourceAction);
        }
    }

    public void checkResourceActions(String name, List<String> actionIds) {
        this.checkResourceActions(name, actionIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkResourceActions(String name, List<String> actionIds, boolean addDefaultActions) {
        String string = name.intern();
        synchronized (string) {
            if (actionIds.size() > 64 || actionIds.size() == 64 && !actionIds.contains("VIEW")) {
                throw new SystemException("There are too many actions for resource " + name);
            }
            long availableBits = -2L;
            HashMap<String, ResourceAction> resourceActionsMap = null;
            ArrayList<Object[]> keyActionIdAndBitwiseValues = null;
            for (String actionId : actionIds) {
                ResourceAction resourceAction;
                String key = this.encodeKey(name, actionId);
                if (_resourceActions.get(key) != null) continue;
                if (resourceActionsMap == null) {
                    resourceActionsMap = new HashMap<String, ResourceAction>();
                    List<ResourceAction> resourceActions = this.getResourceActions(name);
                    for (ResourceAction resourceAction2 : resourceActions) {
                        availableBits &= resourceAction2.getBitwiseValue() ^ 0xFFFFFFFFFFFFFFFFL;
                        resourceActionsMap.put(resourceAction2.getActionId(), resourceAction2);
                    }
                }
                if ((resourceAction = (ResourceAction)resourceActionsMap.get(actionId)) == null) {
                    long bitwiseValue = 1L;
                    if (!actionId.equals("VIEW")) {
                        bitwiseValue = Long.lowestOneBit(availableBits);
                        availableBits ^= bitwiseValue;
                    }
                    if (keyActionIdAndBitwiseValues == null) {
                        keyActionIdAndBitwiseValues = new ArrayList<Object[]>();
                    }
                    keyActionIdAndBitwiseValues.add(new Object[]{key, actionId, bitwiseValue});
                    continue;
                }
                _resourceActions.put(key, resourceAction);
            }
            if (keyActionIdAndBitwiseValues == null) {
                return;
            }
            long batchCounter = this.counterLocalService.increment(ResourceAction.class.getName(), keyActionIdAndBitwiseValues.size());
            batchCounter -= (long)keyActionIdAndBitwiseValues.size();
            for (Object[] keyActionIdAndBitwiseValue : keyActionIdAndBitwiseValues) {
                String key = (String)keyActionIdAndBitwiseValue[0];
                String actionId = (String)keyActionIdAndBitwiseValue[1];
                long bitwiseValue = (Long)keyActionIdAndBitwiseValue[2];
                ResourceAction resourceAction = null;
                try {
                    resourceAction = this.resourceActionPersistence.create(++batchCounter);
                    resourceAction.setName(name);
                    resourceAction.setActionId(actionId);
                    resourceAction.setBitwiseValue(bitwiseValue);
                    resourceAction = (ResourceAction)this.resourceActionPersistence.update((BaseModel)resourceAction);
                    _resourceActions.put(key, resourceAction);
                }
                catch (Throwable throwable) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(throwable);
                    }
                    this.resourceActionLocalService.addResourceAction(name, actionId, bitwiseValue);
                }
            }
            if (!addDefaultActions) {
                return;
            }
            List groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
            List guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions((String)name);
            long guestBitwiseValue = 0L;
            long ownerBitwiseValue = 0L;
            long siteMemberBitwiseValue = 0L;
            for (Object[] keyActionIdAndBitwiseValue : keyActionIdAndBitwiseValues) {
                String actionId = (String)keyActionIdAndBitwiseValue[1];
                long bitwiseValue = (Long)keyActionIdAndBitwiseValue[2];
                if (guestDefaultActions.contains(actionId)) {
                    guestBitwiseValue |= bitwiseValue;
                }
                ownerBitwiseValue |= bitwiseValue;
                if (!groupDefaultActions.contains(actionId)) continue;
                siteMemberBitwiseValue |= bitwiseValue;
            }
            if (guestBitwiseValue > 0L) {
                this._resourcePermissionLocalService.addResourcePermissions(name, "Guest", 4, guestBitwiseValue);
            }
            if (ownerBitwiseValue > 0L) {
                this._resourcePermissionLocalService.addResourcePermissions(name, "Owner", 4, ownerBitwiseValue);
            }
            if (siteMemberBitwiseValue > 0L) {
                this._resourcePermissionLocalService.addResourcePermissions(name, "Site Member", 4, siteMemberBitwiseValue);
            }
        }
    }

    @Override
    public ResourceAction deleteResourceAction(long resourceActionId) throws PortalException {
        return this.deleteResourceAction(this.resourceActionPersistence.findByPrimaryKey(resourceActionId));
    }

    @Override
    public ResourceAction deleteResourceAction(ResourceAction resourceAction) {
        String name = resourceAction.getName();
        Set names = (Set)MassDeleteCacheThreadLocal.getMassDeleteCache((String)ResourcePermissionLocalService.class.getName(), HashSet::new);
        if (names == null) {
            long bitwiseValue = resourceAction.getBitwiseValue();
            ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = dynamicQuery -> {
                Property nameProperty = PropertyFactoryUtil.forName((String)"name");
                dynamicQuery.add(nameProperty.eq((Object)name));
            };
            this._companyLocalService.forEachCompanyId(companyId -> {
                ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
                actionableDynamicQuery.setAddCriteriaMethod(addCriteriaMethod);
                actionableDynamicQuery.setCompanyId(companyId.longValue());
                actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
                    long actionIds = resourcePermission.getActionIds();
                    if ((actionIds & bitwiseValue) != 0L) {
                        resourcePermission.setActionIds(actionIds &= bitwiseValue ^ 0xFFFFFFFFFFFFFFFFL);
                        resourcePermission.setViewActionId(actionIds % 2L == 1L);
                        this._resourcePermissionPersistence.update((BaseModel)resourcePermission);
                    }
                });
                try {
                    actionableDynamicQuery.performActions();
                }
                catch (PortalException portalException) {
                    throw new SystemException((Throwable)portalException);
                }
            });
        } else {
            names.add(name);
        }
        this.resourceActionPersistence.remove((BaseModel)resourceAction);
        _resourceActions.remove(this.encodeKey(resourceAction.getName(), resourceAction.getActionId()));
        PermissionCacheUtil.clearCache();
        return resourceAction;
    }

    @Transactional(enabled=false)
    public ResourceAction fetchResourceAction(String name, String actionId) {
        return _resourceActions.get(this.encodeKey(name, actionId));
    }

    @Transactional(enabled=false)
    public ResourceAction getResourceAction(String name, String actionId) throws PortalException {
        String key = this.encodeKey(name, actionId);
        ResourceAction resourceAction = _resourceActions.get(key);
        if (resourceAction == null) {
            throw new NoSuchResourceActionException(key);
        }
        return resourceAction;
    }

    public List<ResourceAction> getResourceActions(String name) {
        return this.resourceActionPersistence.findByName(name);
    }

    public int getResourceActionsCount(String name) {
        return this.resourceActionPersistence.countByName(name);
    }

    protected String encodeKey(String name, String actionId) {
        return DBPartitionUtil.getPartitionKey(StringBundler.concat((String[])new String[]{name, "#", actionId}));
    }
}

