/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.service.base.ResourceLocalServiceBaseImpl;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;

@Transactional(enabled=false)
public class ResourceLocalServiceImpl
extends ResourceLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ResourceLocalServiceImpl.class);
    @BeanReference(type=ResourcePermissionLocalService.class)
    private ResourcePermissionLocalService _resourcePermissionLocalService;

    public void addModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException {
        this._resourcePermissionLocalService.addModelResourcePermissions(auditedModel, serviceContext);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, long primKey, ModelPermissions modelPermissions) throws PortalException {
        this._resourcePermissionLocalService.addModelResourcePermissions(companyId, groupId, userId, name, String.valueOf(primKey), modelPermissions);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this._resourcePermissionLocalService.addModelResourcePermissions(companyId, groupId, userId, name, String.valueOf(primKey), groupPermissions, guestPermissions);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, String primKey, ModelPermissions modelPermissions) throws PortalException {
        this._resourcePermissionLocalService.addModelResourcePermissions(companyId, groupId, userId, name, primKey, modelPermissions);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this._resourcePermissionLocalService.addModelResourcePermissions(companyId, groupId, userId, name, primKey, groupPermissions, guestPermissions);
    }

    public void addResources(long companyId, long groupId, long userId, String name, long primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(addGroupPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        this.addResources(companyId, groupId, userId, name, primKey, portletActions, serviceContext);
    }

    public void addResources(long companyId, long groupId, long userId, String name, long primKey, boolean portletActions, ServiceContext serviceContext) throws PortalException {
        this._resourcePermissionLocalService.addResourcePermissions(companyId, groupId, userId, name, String.valueOf(primKey), portletActions, serviceContext);
    }

    public void addResources(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(addGroupPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        this._resourcePermissionLocalService.addResourcePermissions(companyId, groupId, userId, name, primKey, portletActions, serviceContext);
    }

    public void addResources(long companyId, long groupId, long userId, String name, String[] primKeys, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(addGroupPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        this._resourcePermissionLocalService.addResourcePermissions(companyId, groupId, userId, name, primKeys, portletActions, serviceContext);
    }

    public void addResources(long companyId, long groupId, String name, boolean portletActions) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(false);
        serviceContext.setAddGuestPermissions(false);
        this._resourcePermissionLocalService.addResourcePermissions(companyId, groupId, 0L, name, (String)null, portletActions, serviceContext);
    }

    public void copyModelResources(long companyId, String name, long sourcePrimKey, long targetPrimKey) throws PortalException {
        this._resourcePermissionLocalService.copyModelResourcePermissions(companyId, name, sourcePrimKey, targetPrimKey);
    }

    public void deleteResource(AuditedModel auditedModel, int scope) throws PortalException {
        this._resourcePermissionLocalService.deleteResourcePermissions(auditedModel.getCompanyId(), auditedModel.getModelClassName(), scope, String.valueOf(auditedModel.getPrimaryKeyObj()));
    }

    public void deleteResource(long companyId, String name, int scope, long primKey) throws PortalException {
        this._resourcePermissionLocalService.deleteResourcePermissions(companyId, name, scope, primKey);
    }

    public void deleteResource(long companyId, String name, int scope, String primKey) throws PortalException {
        this._resourcePermissionLocalService.deleteResourcePermissions(companyId, name, scope, primKey);
    }

    public Resource getResource(long companyId, String name, int scope, String primKey) {
        ResourceImpl resource = new ResourceImpl();
        resource.setCompanyId(companyId);
        resource.setName(name);
        resource.setScope(scope);
        resource.setPrimKey(primKey);
        return resource;
    }

    public boolean hasUserPermissions(long userId, long resourceId, List<Resource> resources, String actionId, long[] roleIds) throws PortalException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        boolean hasUserPermissions = this._resourcePermissionLocalService.hasResourcePermission(resources, roleIds, actionId);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Checking user permissions for ", userId, " ", resourceId, " ", actionId, " takes ", stopWatch.getTime(), " ms"}));
        }
        return hasUserPermissions;
    }

    public void removeResource(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException {
        this._resourcePermissionLocalService.removeResourcePermission(companyId, name, scope, primKey, roleId, actionId);
    }

    public void updateModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException {
        this._resourcePermissionLocalService.updateModelResourcePermissions(auditedModel, serviceContext);
    }

    public void updateResources(long companyId, long groupId, String name, long primKey, ModelPermissions modelPermissions) throws PortalException {
        this._resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, name, String.valueOf(primKey), modelPermissions);
    }

    public void updateResources(long companyId, long groupId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this._resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, name, primKey, groupPermissions, guestPermissions);
    }

    public void updateResources(long companyId, long groupId, String name, String primKey, ModelPermissions modelPermissions) throws PortalException {
        this._resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, name, primKey, modelPermissions);
    }

    public void updateResources(long companyId, long groupId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this._resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, name, primKey, groupPermissions, guestPermissions);
    }

    public void updateResources(long companyId, String name, int scope, String primKey, String newPrimKey) {
        this._resourcePermissionLocalService.updateResourcePermissions(companyId, name, scope, primKey, newPrimKey);
    }
}

