/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.internal.minifier.MinifierThreadLocal;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.RequestDispatcherUtil;
import com.liferay.portal.kernel.servlet.ResourceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.minifier.MinifierUtil;
import com.liferay.portal.servlet.filters.IgnoreModuleRequestFilter;
import com.liferay.portal.servlet.filters.aggregate.ServletPaths;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.servlet.filters.util.CacheFileNameGenerator;
import com.liferay.portal.util.AggregateUtil;
import com.liferay.portal.util.JavaScriptBundleUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AggregateFilter
extends IgnoreModuleRequestFilter {
    private static final String _BASE_URL = "@base_url@";
    private static final String _CSS_COMMENT_BEGIN = "/*";
    private static final String _CSS_COMMENT_END = "*/";
    private static final String _CSS_EXTENSION = ".css";
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final String _CSS_MEDIA_QUERY = "@media";
    private static final String _JAVASCRIPT_EXTENSION = ".js";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _TEMP_DIR = "aggregate";
    private static final Log _log = LogFactoryUtil.getLog(AggregateFilter.class);
    private static final Pattern _pattern = Pattern.compile("^(\\.ie|\\.js\\.ie)([^}]*)}", 8);
    private static final Snapshot<PortalExecutorManager> _portalExecutorManagerSnapshot = new Snapshot(AggregateFilter.class, PortalExecutorManager.class);
    private final Map<String, NoticeableFuture<String>> _noticeableFutures = new ConcurrentHashMap<String, NoticeableFuture<String>>();
    private ServletContext _servletContext;
    private File _tempDir;

    public static String aggregateCss(ServletPaths servletPaths, String content) throws IOException {
        StringBundler sb = new StringBundler();
        int pos = 0;
        while (true) {
            char firstCharacter;
            int commentX = content.indexOf(_CSS_COMMENT_BEGIN, pos);
            int commentY = content.indexOf(_CSS_COMMENT_END, commentX + _CSS_COMMENT_BEGIN.length());
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            if (commentX != -1 && commentY != -1 && commentX < importX && commentY > importX) {
                sb.append(content.substring(pos, commentY += _CSS_COMMENT_END.length()));
                pos = commentY;
                continue;
            }
            sb.append(content.substring(pos, importX));
            String mediaQuery = "";
            int mediaQueryImportX = content.indexOf(41, importX + _CSS_IMPORT_BEGIN.length());
            int mediaQueryImportY = content.indexOf(59, importX + _CSS_IMPORT_BEGIN.length());
            String importFileName = null;
            if (importY != mediaQueryImportX) {
                mediaQuery = content.substring(mediaQueryImportX + 1, mediaQueryImportY);
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), mediaQueryImportX);
            } else {
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            }
            String normalizedImportFileName = importFileName;
            if (!(importFileName.isEmpty() || (firstCharacter = importFileName.charAt(0)) != '\'' && firstCharacter != '\"')) {
                normalizedImportFileName = importFileName.substring(1, importFileName.length() - 1);
            }
            Object importContent = null;
            if (Validator.isUrl((String)normalizedImportFileName)) {
                ServletPaths downServletPaths = servletPaths.down(normalizedImportFileName);
                importContent = downServletPaths.getContent();
                if (importContent == null) {
                    importContent = _CSS_IMPORT_BEGIN + importFileName + _CSS_IMPORT_END;
                }
            } else {
                ServletPaths importFileServletPaths;
                int queryPos = importFileName.indexOf(63);
                if (queryPos != -1) {
                    importFileName = importFileName.substring(0, queryPos);
                }
                if ((importContent = (importFileServletPaths = servletPaths.down(importFileName)).getContent()) == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("File " + importFileServletPaths.getResourcePath() + " does not exist"));
                    }
                    importContent = "";
                }
                String importDirName = "";
                int slashPos = importFileName.lastIndexOf(47);
                if (slashPos != -1) {
                    importDirName = importFileName.substring(0, slashPos + 1);
                }
                ServletPaths importDirServletPaths = servletPaths.down(importDirName);
                importContent = AggregateFilter.aggregateCss(importDirServletPaths, (String)importContent);
                Object baseURL = _BASE_URL.concat(importDirServletPaths.getResourcePath());
                if (!((String)baseURL).endsWith("/")) {
                    baseURL = (String)baseURL + "/";
                }
                importContent = AggregateUtil.updateRelativeURLs((String)importContent, (String)baseURL);
            }
            if (Validator.isNotNull((String)mediaQuery)) {
                sb.append(_CSS_MEDIA_QUERY);
                sb.append(' ');
                sb.append(mediaQuery);
                sb.append('{');
                sb.append((String)importContent);
                sb.append('}');
                pos = mediaQueryImportY + 1;
                continue;
            }
            sb.append((String)importContent);
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        return sb.toString();
    }

    public static String aggregateJavaScript(ServletPaths servletPaths, String[] fileNames) {
        StringBundler sb = new StringBundler(fileNames.length * 2);
        for (String fileName : fileNames) {
            ServletPaths fileServletPaths = servletPaths.down(fileName);
            String content = fileServletPaths.getContent();
            if (Validator.isNull((String)content)) continue;
            sb.append(content);
            sb.append("\n");
        }
        return AggregateFilter.getJavaScriptContent(StringUtil.merge((Object[])fileNames, (String)"+"), sb.toString());
    }

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        File tempDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        this._tempDir = new File(tempDir, _TEMP_DIR);
        this._tempDir.mkdirs();
    }

    protected static String getJavaScriptContent(String resourceName, String content) {
        return MinifierUtil.minifyJavaScript(resourceName, content);
    }

    protected Object getBundleContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String minifierType = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"minifierType");
        String bundleId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"bundleId", (String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"minifierBundleId"));
        if (Validator.isNull((String)minifierType) || Validator.isNull((String)bundleId) || !ArrayUtil.contains((Object[])PropsValues.JAVASCRIPT_BUNDLE_IDS, (Object)bundleId)) {
            return null;
        }
        String bundleDirName = PropsUtil.get("javascript.bundle.dir", new Filter(bundleId));
        ServletContext jsServletContext = PortalWebResourcesUtil.getServletContext((String)"js");
        URL bundleDirURL = jsServletContext.getResource(bundleDirName);
        if (bundleDirURL == null) {
            return null;
        }
        String cacheFileName = bundleId;
        File cacheFile = new File(this._tempDir, cacheFileName);
        if (cacheFile.exists()) {
            long lastModified = PortalWebResourcesUtil.getLastModified((String)"js");
            long fileLastModifiedTime = -1L;
            try (FileReader reader = new FileReader(cacheFile);
                 UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)reader);){
                String line = unsyncBufferedReader.readLine();
                if (line != null && line.startsWith("//")) {
                    fileLastModifiedTime = GetterUtil.getLong((String)line.substring(2), (long)-1L);
                }
            }
            if (lastModified == fileLastModifiedTime) {
                httpServletResponse.setContentType("text/javascript");
                return cacheFile;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Aggregating JavaScript bundle " + bundleId));
        }
        String content = null;
        String[] fileNames = JavaScriptBundleUtil.getFileNames(bundleId);
        content = fileNames.length == 0 ? "" : AggregateFilter.aggregateJavaScript(new ServletPaths(jsServletContext, bundleDirName), fileNames);
        content = StringBundler.concat((Object[])new Object[]{"//", PortalWebResourcesUtil.getLastModified((String)"js"), "\n", content});
        httpServletResponse.setContentType("text/javascript");
        FileUtil.write((File)cacheFile, (String)content);
        return content;
    }

    protected String getCacheFileName(HttpServletRequest httpServletRequest) {
        return CacheFileNameGenerator.getCacheFileName(httpServletRequest, AggregateFilter.class.getName());
    }

    protected Object getContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        URL resourceURL;
        String minifierType = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"minifierType");
        String minifierBundleId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"minifierBundleId");
        String minifierBundleDirName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"minifierBundleDir");
        if (Validator.isNull((String)minifierType) || Validator.isNotNull((String)minifierBundleId) || Validator.isNotNull((String)minifierBundleDirName)) {
            return null;
        }
        String resourcePath = httpServletRequest.getRequestURI();
        String contextPath = httpServletRequest.getContextPath();
        if (!contextPath.equals("/")) {
            resourcePath = resourcePath.substring(contextPath.length());
        }
        if ((resourceURL = ResourceUtil.getResourceURL((String)resourcePath, (String)httpServletRequest.getRequestURI(), (ServletContext)this._servletContext)) == null) {
            return null;
        }
        String cacheCommonFileName = this.getCacheFileName(httpServletRequest);
        File cacheContentTypeFile = new File(this._tempDir, cacheCommonFileName + "_E_CTYPE");
        File cacheDataFile = new File(this._tempDir, cacheCommonFileName + "_E_DATA");
        if (cacheDataFile.exists()) {
            long fileLastModifiedTime = -1L;
            try (FileReader reader = new FileReader(cacheDataFile);
                 UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)reader);){
                String line = unsyncBufferedReader.readLine();
                if (line != null && line.startsWith(_CSS_COMMENT_BEGIN) && line.endsWith(_CSS_COMMENT_END)) {
                    fileLastModifiedTime = GetterUtil.getLong((String)line.substring(2, line.length() - 2), (long)-1L);
                }
            }
            if (URLUtil.getLastModifiedTime((URL)resourceURL) == fileLastModifiedTime) {
                if (cacheContentTypeFile.exists()) {
                    httpServletResponse.setContentType(FileUtil.read((File)cacheContentTypeFile));
                } else if (resourcePath.endsWith(_CSS_EXTENSION)) {
                    httpServletResponse.setContentType("text/css; charset=UTF-8");
                } else if (resourcePath.endsWith(_JAVASCRIPT_EXTENSION)) {
                    httpServletResponse.setContentType("text/javascript");
                }
                return cacheDataFile;
            }
        }
        try (Closeable closeable = MinifierThreadLocal.disable();){
            Object bufferCacheServletResponse;
            String content = null;
            if (resourcePath.endsWith(_CSS_EXTENSION)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Minifying CSS " + resourcePath));
                }
                content = this.getCssContent(httpServletRequest, httpServletResponse, resourcePath);
                httpServletResponse.setContentType("text/css; charset=UTF-8");
                FileUtil.write((File)cacheContentTypeFile, (String)"text/css; charset=UTF-8");
            } else if (resourcePath.endsWith(_JAVASCRIPT_EXTENSION)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Minifying JavaScript " + resourcePath));
                }
                content = this.getJavaScriptContent(httpServletRequest, httpServletResponse, resourcePath, resourceURL);
                httpServletResponse.setContentType("text/javascript");
                FileUtil.write((File)cacheContentTypeFile, (String)"text/javascript");
            } else if (resourcePath.endsWith(_JSP_EXTENSION)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Minifying JSP " + resourcePath));
                }
                bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
                this.processFilter(AggregateFilter.class.getName(), httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, filterChain);
                content = bufferCacheServletResponse.getString();
                if (minifierType.equals("css")) {
                    content = this.getCssContent(httpServletRequest, httpServletResponse, resourcePath, content);
                } else if (minifierType.equals("js")) {
                    content = AggregateFilter.getJavaScriptContent(resourcePath, content);
                }
                FileUtil.write((File)cacheContentTypeFile, (String)bufferCacheServletResponse.getContentType());
            } else {
                bufferCacheServletResponse = null;
                return bufferCacheServletResponse;
            }
            content = StringBundler.concat((Object[])new Object[]{_CSS_COMMENT_BEGIN, URLUtil.getLastModifiedTime((URL)resourceURL), _CSS_COMMENT_END, "\n", content});
            FileUtil.write((File)cacheDataFile, (String)content);
            if (!PropsValues.MINIFIER_ENABLED) {
                bufferCacheServletResponse = content;
                return bufferCacheServletResponse;
            }
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            String finalContent = content;
            String finalResourcePath = resourcePath;
            NoticeableFuture noticeableFuture = this._noticeableFutures.computeIfAbsent(cacheCommonFileName, key -> {
                PortalExecutorManager portalExecutorManager = (PortalExecutorManager)_portalExecutorManagerSnapshot.get();
                NoticeableExecutorService noticeableExecutorService = portalExecutorManager.getPortalExecutor(AggregateFilter.class.getName());
                return noticeableExecutorService.submit(() -> {
                    String minifiedContent = null;
                    minifiedContent = minifierType.equals("css") ? MinifierUtil.minifyCss(finalContent) : MinifierUtil.minifyJavaScript(finalResourcePath, finalContent);
                    minifiedContent = StringBundler.concat((Object[])new Object[]{_CSS_COMMENT_BEGIN, URLUtil.getLastModifiedTime((URL)resourceURL), _CSS_COMMENT_END, "\n", minifiedContent});
                    File tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (String)minifiedContent);
                    FileUtil.move((File)tempFile, (File)cacheDataFile);
                    return minifiedContent;
                });
            });
            noticeableFuture.addFutureListener(future -> this._noticeableFutures.remove(cacheCommonFileName));
            String string = content;
            return string;
        }
    }

    protected String getCssContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext cssServletContext, String resourcePath, String content) {
        try {
            content = DynamicCSSUtil.replaceToken(cssServletContext, httpServletRequest, content);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to replace tokens in CSS " + resourcePath), (Throwable)exception);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)content);
            }
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        }
        String browserId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"browserId");
        if (!browserId.equals("ie")) {
            Matcher matcher = _pattern.matcher(content);
            content = matcher.replaceAll("");
        }
        return MinifierUtil.minifyCss(content);
    }

    protected String getCssContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String resourcePath) throws Exception {
        String resourcePathRoot = null;
        String requestURI = httpServletRequest.getRequestURI();
        ServletContext cssServletContext = ResourceUtil.getPathServletContext((String)resourcePath, (String)requestURI, (ServletContext)this._servletContext);
        if (PortalWebResourcesUtil.hasContextPath((String)requestURI)) {
            resourcePathRoot = PortalWebResourcesUtil.stripContextPath((ServletContext)cssServletContext, (String)resourcePath);
            if ((resourcePathRoot = ServletPaths.getParentPath(resourcePathRoot)).equals("")) {
                resourcePathRoot = "/";
            }
        } else {
            resourcePathRoot = ServletPaths.getParentPath(resourcePath);
        }
        String content = this._readResource(httpServletRequest, httpServletResponse, resourcePath);
        content = AggregateFilter.aggregateCss(new ServletPaths(cssServletContext, resourcePathRoot), content);
        return this.getCssContent(httpServletRequest, httpServletResponse, cssServletContext, resourcePath, content);
    }

    protected String getCssContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String resourcePath, String content) {
        try {
            ServletContext cssServletContext = ResourceUtil.getPathServletContext((String)resourcePath, (String)httpServletRequest.getRequestURI(), (ServletContext)this._servletContext);
            return this.getCssContent(httpServletRequest, httpServletResponse, cssServletContext, resourcePath, content);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to detect servlet context " + resourcePath), (Throwable)exception);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)content);
            }
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            return content;
        }
    }

    protected String getJavaScriptContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String resourcePath, URL resourceURL) throws Exception {
        String content = this._readResource(httpServletRequest, httpServletResponse, resourcePath);
        return AggregateFilter.getJavaScriptContent(resourceURL.toString(), content);
    }

    @Override
    protected boolean isModuleRequest(HttpServletRequest httpServletRequest) {
        if (PortalWebResourcesUtil.hasContextPath((String)httpServletRequest.getRequestURI())) {
            return false;
        }
        return super.isModuleRequest(httpServletRequest);
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        Object minifiedContent = this.getContent(httpServletRequest, httpServletResponse, filterChain);
        if (minifiedContent == null) {
            minifiedContent = this.getBundleContent(httpServletRequest, httpServletResponse);
        }
        if (minifiedContent == null) {
            this.processFilter(AggregateFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
        } else if (minifiedContent instanceof File) {
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (File)((File)minifiedContent));
        } else if (minifiedContent instanceof String) {
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)((String)minifiedContent));
        }
    }

    private String _readResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String resourcePath) throws Exception {
        URL url = this._servletContext.getResource(resourcePath);
        if (url == null) {
            ObjectValuePair objectValuePair = RequestDispatcherUtil.getContentAndLastModifiedTimeObjectValuePair((RequestDispatcher)httpServletRequest.getRequestDispatcher(resourcePath), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return (String)objectValuePair.getKey();
        }
        URLConnection urlConnection = url.openConnection();
        return StringUtil.read((InputStream)urlConnection.getInputStream());
    }
}

