/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.servlet.filters.secure.BaseAuthFilter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharepointFilter
extends BaseAuthFilter {
    private static final String[] _PREFIXES = new String[]{"/_vti_inf.html", "/_vti_bin", "/sharepoint", "/history", "/resources"};

    @Override
    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.setUsePermissionChecker(true);
    }

    protected boolean isSharepointRequest(String uri) {
        if (uri == null) {
            return false;
        }
        if (uri.endsWith("*.asmx")) {
            return true;
        }
        for (String prefix : _PREFIXES) {
            if (!uri.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected boolean isWebDAVRequest(String uri) {
        return uri.startsWith("/webdav");
    }

    @Override
    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        String method = httpServletRequest.getMethod();
        String userAgent = GetterUtil.getString((String)httpServletRequest.getHeader("User-Agent"));
        if ((userAgent.startsWith("Microsoft Data Access Internet Publishing") || userAgent.startsWith("Microsoft Office Protocol Discovery")) && method.equals("OPTIONS")) {
            this.setOptionsHeaders(httpServletRequest, httpServletResponse);
            return;
        }
        if (!this.isSharepointRequest(httpServletRequest.getRequestURI())) {
            this.processFilter(SharepointFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        if (method.equals("GET") || method.equals("HEAD")) {
            this.setGetHeaders(httpServletResponse);
        } else if (method.equals("POST")) {
            this.setPostHeaders(httpServletResponse);
        }
        super.processFilter(httpServletRequest, httpServletResponse, filterChain);
    }

    protected void setGetHeaders(HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Public-Extension", "http://schemas.microsoft.com/repl-2");
        httpServletResponse.setHeader("MicrosoftSharePointTeamServices", "6.0.2.8117");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
    }

    protected void setOptionsHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.isWebDAVRequest(httpServletRequest.getRequestURI())) {
            httpServletResponse.setHeader("MS-Author-Via", "DAV,MS-FP/4.0");
        } else {
            httpServletResponse.setHeader("MS-Author-Via", "MS-FP/4.0,DAV");
        }
        httpServletResponse.setHeader("MicrosoftOfficeWebServer", "5.0_Collab");
        httpServletResponse.setHeader("MicrosoftSharePointTeamServices", "6.0.2.8117");
        httpServletResponse.setHeader("DAV", "1,2");
        httpServletResponse.setHeader("Accept-Ranges", "none");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setHeader("Allow", "COPY, DELETE, GET, GETLIB, HEAD, LOCK, MKCOL, MOVE, OPTIONS, POST, PROPFIND, PROPPATCH, PUT, UNLOCK");
    }

    protected void setPostHeaders(HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("application/x-vermeer-rpc");
        httpServletResponse.setHeader("MicrosoftSharePointTeamServices", "6.0.2.8117");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setHeader("Connection", "close");
    }
}

