/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.spring.aop.InvocationHandlerFactory;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.BeanMatcher;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class DynamicProxyCreator
implements BeanPostProcessor,
Ordered {
    private static final DynamicProxyCreator _dynamicProxyCreator = new DynamicProxyCreator();
    private final List<ObjectValuePair<BeanMatcher, InvocationHandlerFactory>> _beanMatcherInvocationHandlerFactories = new ArrayList<ObjectValuePair<BeanMatcher, InvocationHandlerFactory>>();

    public static DynamicProxyCreator getDynamicProxyCreator() {
        return _dynamicProxyCreator;
    }

    public void clear() {
        this._beanMatcherInvocationHandlerFactories.clear();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        for (ObjectValuePair<BeanMatcher, InvocationHandlerFactory> objectValuePair : this._beanMatcherInvocationHandlerFactories) {
            BeanMatcher beanMatcher = (BeanMatcher)objectValuePair.getKey();
            if (!beanMatcher.match(beanClass, beanName)) continue;
            InvocationHandlerFactory invocationHandlerFactory = (InvocationHandlerFactory)objectValuePair.getValue();
            InvocationHandler invocationHandler = invocationHandlerFactory.createInvocationHandler(bean);
            bean = ProxyUtil.newProxyInstance((ClassLoader)contextClassLoader, (Class[])beanClass.getInterfaces(), (InvocationHandler)invocationHandler);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public static class Register {
        public Register(BeanMatcher beanMatcher, InvocationHandlerFactory invocationHandlerFactory) {
            ObjectValuePair objectValuePair = new ObjectValuePair((Object)beanMatcher, (Object)invocationHandlerFactory);
            DynamicProxyCreator._dynamicProxyCreator._beanMatcherInvocationHandlerFactories.add((ObjectValuePair<BeanMatcher, InvocationHandlerFactory>)objectValuePair);
        }
    }
}

