/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.hibernate.LastSessionRecorderUtil;
import com.liferay.portal.spring.hibernate.SpringHibernateThreadLocalUtil;
import java.sql.Connection;
import java.util.Map;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class PortalTransactionManager
extends AbstractPlatformTransactionManager {
    private static final Log _log = LogFactoryUtil.getLog(PortalTransactionManager.class);
    private final DataSource _dataSource;
    private final SessionFactory _sessionFactory;

    public PortalTransactionManager(DataSource dataSource, SessionFactory sessionFactory) {
        this._dataSource = dataSource;
        this._sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this._sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBegin(Object transactionObject, TransactionDefinition transactionDefinition) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)transactionObject;
        ConnectionHolder connectionHolder = hibernateTransactionObject.getConnectionHolder();
        if (connectionHolder != null && connectionHolder.isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Found prebound JDBC connection");
        }
        SessionImplementor sessionImplementor = null;
        try {
            SessionHolder sessionHolder = hibernateTransactionObject.getSessionHolder();
            if (sessionHolder == null || sessionHolder.isSynchronizedWithTransaction()) {
                hibernateTransactionObject.setSession(this._sessionFactory.openSession());
                sessionHolder = hibernateTransactionObject.getSessionHolder();
            }
            Session session = sessionHolder.getSession();
            sessionImplementor = (SessionImplementor)session.unwrap(SessionImplementor.class);
            if (transactionDefinition.getIsolationLevel() != -1 || transactionDefinition.isReadOnly()) {
                Connection connection = sessionImplementor.connection();
                hibernateTransactionObject.markConnectionModified();
                hibernateTransactionObject.setPreviousIsolationLevel(DataSourceUtils.prepareConnectionForTransaction((Connection)connection, (TransactionDefinition)transactionDefinition));
                hibernateTransactionObject.setReadOnly(transactionDefinition.isReadOnly());
            }
            if (transactionDefinition.isReadOnly()) {
                if (hibernateTransactionObject.isNewSession()) {
                    sessionImplementor.setDefaultReadOnly(true);
                    sessionImplementor.setHibernateFlushMode(FlushMode.MANUAL);
                } else {
                    FlushMode flushMode = sessionImplementor.getHibernateFlushMode();
                    if (FlushMode.MANUAL == flushMode) {
                        sessionHolder.setPreviousFlushMode(flushMode);
                        sessionImplementor.setHibernateFlushMode(FlushMode.AUTO);
                    }
                }
            }
            ConnectionHolder newConnectionHolder = new ConnectionHolder(() -> ((SessionImplementor)sessionImplementor).connection());
            Transaction transaction = null;
            int timeout = this.determineTimeout(transactionDefinition);
            if (timeout == -1) {
                transaction = sessionImplementor.beginTransaction();
            } else {
                transaction = sessionImplementor.getTransaction();
                transaction.setTimeout(timeout);
                transaction.begin();
                newConnectionHolder.setTimeoutInSeconds(timeout);
            }
            sessionHolder.setTransaction(transaction);
            Map<Object, Object> resources = SpringHibernateThreadLocalUtil.getResources(true);
            SpringHibernateThreadLocalUtil.setResource(this._dataSource, newConnectionHolder, resources);
            hibernateTransactionObject.setConnectionHolder(newConnectionHolder);
            if (hibernateTransactionObject.isNewSessionHolder()) {
                SpringHibernateThreadLocalUtil.setResource(this._sessionFactory, sessionHolder, resources);
            }
            sessionHolder.setSynchronizedWithTransaction(true);
        }
        catch (Throwable throwable1) {
            if (hibernateTransactionObject.isNewSession()) {
                try {
                    Transaction transaction;
                    if (sessionImplementor != null && (transaction = sessionImplementor.getTransaction()).getStatus() == TransactionStatus.ACTIVE) {
                        transaction.rollback();
                    }
                }
                catch (Throwable throwable2) {
                    throwable1.addSuppressed(throwable2);
                }
                finally {
                    if (sessionImplementor != null && sessionImplementor.isOpen()) {
                        sessionImplementor.close();
                    }
                    hibernateTransactionObject.setSessionHolder(null);
                }
            }
            throw new CannotCreateTransactionException("Unable to open Hibernate session for transaction", throwable1);
        }
    }

    protected void doCleanupAfterCompletion(Object transactionObject) {
        SessionImplementor sessionImplementor;
        SessionHolder sessionHolder;
        HibernateTransactionObject hibernateTransactionObject;
        block9: {
            hibernateTransactionObject = (HibernateTransactionObject)transactionObject;
            Map<Object, Object> resources = SpringHibernateThreadLocalUtil.getResources(false);
            if (hibernateTransactionObject.isNewSessionHolder()) {
                SpringHibernateThreadLocalUtil.setResource(this._sessionFactory, null, resources);
            }
            SpringHibernateThreadLocalUtil.setResource(this._dataSource, null, resources);
            sessionHolder = hibernateTransactionObject.getSessionHolder();
            Session session = sessionHolder.getSession();
            sessionImplementor = (SessionImplementor)session.unwrap(SessionImplementor.class);
            JdbcCoordinator jdbcCoordinator = sessionImplementor.getJdbcCoordinator();
            LogicalConnectionImplementor logicalConnectionImplementor = jdbcCoordinator.getLogicalConnection();
            if (hibernateTransactionObject.isConnectionModified() && logicalConnectionImplementor.isPhysicallyConnected()) {
                try {
                    Connection connection = sessionImplementor.connection();
                    DataSourceUtils.resetConnectionAfterTransaction((Connection)connection, (Integer)hibernateTransactionObject.getPreviousIsolationLevel(), (boolean)hibernateTransactionObject.isReadOnly());
                }
                catch (HibernateException hibernateException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Unable to get JDBC connection from Hibernate session", (Throwable)hibernateException);
                    }
                }
                catch (Throwable throwable) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug((Object)"Unable to reset JDBC connection after transaction", throwable);
                }
            }
        }
        if (hibernateTransactionObject.isNewSession()) {
            sessionImplementor.close();
        } else {
            FlushMode flushMode = sessionHolder.getPreviousFlushMode();
            if (flushMode != null) {
                sessionImplementor.setHibernateFlushMode(flushMode);
            }
            sessionImplementor.disconnect();
        }
        sessionHolder.clear();
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)defaultTransactionStatus.getTransaction();
        SessionHolder sessionHolder = hibernateTransactionObject.getSessionHolder();
        Transaction transaction = sessionHolder.getTransaction();
        try {
            transaction.commit();
        }
        catch (TransactionException transactionException) {
            throw new TransactionSystemException("Unable to commit Hibernate transaction", (Throwable)transactionException);
        }
        catch (HibernateException hibernateException) {
            throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)hibernateException);
        }
        catch (PersistenceException persistenceException) {
            Throwable throwable = persistenceException.getCause();
            if (throwable instanceof HibernateException) {
                throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)((HibernateException)throwable));
            }
            throw persistenceException;
        }
    }

    protected Object doGetTransaction() {
        HibernateTransactionObject hibernateTransactionObject = new HibernateTransactionObject();
        Map<Object, Object> resources = SpringHibernateThreadLocalUtil.getResources(false);
        SessionHolder sessionHolder = (SessionHolder)SpringHibernateThreadLocalUtil.getResource(this._sessionFactory, resources);
        if (sessionHolder != null) {
            LastSessionRecorderUtil.setLastSession(sessionHolder.getSession());
            hibernateTransactionObject.setSessionHolder(sessionHolder);
        }
        hibernateTransactionObject.setConnectionHolder((ConnectionHolder)SpringHibernateThreadLocalUtil.getResource(this._dataSource, resources));
        return hibernateTransactionObject;
    }

    protected void doResume(Object transactionObject, Object suspendedResources) {
        SuspendedResourcesHolder suspendedResourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        Map<Object, Object> resources = SpringHibernateThreadLocalUtil.getResources(true);
        SpringHibernateThreadLocalUtil.setResource(this._sessionFactory, suspendedResourcesHolder._sessionHolder, resources);
        if (suspendedResourcesHolder._connectionHolder != null) {
            SpringHibernateThreadLocalUtil.setResource(this._dataSource, suspendedResourcesHolder._connectionHolder, resources);
        }
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)defaultTransactionStatus.getTransaction();
        SessionHolder sessionHolder = hibernateTransactionObject.getSessionHolder();
        Transaction transaction = sessionHolder.getTransaction();
        try {
            transaction.rollback();
        }
        catch (TransactionException transactionException) {
            throw new TransactionSystemException("Unable to roll back Hibernate transaction", (Throwable)transactionException);
        }
        catch (HibernateException hibernateException) {
            throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)hibernateException);
        }
        catch (PersistenceException persistenceException) {
            Throwable throwable = persistenceException.getCause();
            if (throwable instanceof HibernateException) {
                throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)((HibernateException)throwable));
            }
            throw persistenceException;
        }
        finally {
            if (!hibernateTransactionObject.isNewSession()) {
                Session session = sessionHolder.getSession();
                session.clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus defaultTransactionStatus) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)defaultTransactionStatus.getTransaction();
        SessionHolder sessionHolder = hibernateTransactionObject.getSessionHolder();
        sessionHolder.setRollbackOnly();
        ConnectionHolder connectionHolder = hibernateTransactionObject.getConnectionHolder();
        if (connectionHolder != null) {
            connectionHolder.setRollbackOnly();
        }
    }

    protected Object doSuspend(Object transactionObject) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)transactionObject;
        hibernateTransactionObject.setConnectionHolder(null);
        hibernateTransactionObject.setSessionHolder(null);
        Map<Object, Object> resources = SpringHibernateThreadLocalUtil.getResources(false);
        return new SuspendedResourcesHolder((ConnectionHolder)SpringHibernateThreadLocalUtil.setResource(this._dataSource, null, resources), (SessionHolder)SpringHibernateThreadLocalUtil.setResource(this._sessionFactory, null, resources));
    }

    protected boolean isExistingTransaction(Object transactionObject) {
        HibernateTransactionObject hibernateTransactionObject = (HibernateTransactionObject)transactionObject;
        SessionHolder sessionHolder = hibernateTransactionObject.getSessionHolder();
        return sessionHolder != null && sessionHolder.getTransaction() != null;
    }

    private class HibernateTransactionObject {
        private ConnectionHolder _connectionHolder;
        private boolean _connectionModified;
        private boolean _newSession;
        private boolean _newSessionHolder;
        private Integer _previousIsolationLevel;
        private boolean _readOnly;
        private SessionHolder _sessionHolder;

        private HibernateTransactionObject() {
        }

        public ConnectionHolder getConnectionHolder() {
            return this._connectionHolder;
        }

        public Integer getPreviousIsolationLevel() {
            return this._previousIsolationLevel;
        }

        public SessionHolder getSessionHolder() {
            return this._sessionHolder;
        }

        public boolean isConnectionModified() {
            return this._connectionModified;
        }

        public boolean isNewSession() {
            return this._newSession;
        }

        public boolean isNewSessionHolder() {
            return this._newSessionHolder;
        }

        public boolean isReadOnly() {
            return this._readOnly;
        }

        public void markConnectionModified() {
            this._connectionModified = true;
        }

        public void setConnectionHolder(ConnectionHolder connectionHolder) {
            this._connectionHolder = connectionHolder;
        }

        public void setPreviousIsolationLevel(Integer previousIsolationLevel) {
            this._previousIsolationLevel = previousIsolationLevel;
        }

        public void setReadOnly(boolean readOnly) {
            this._readOnly = readOnly;
        }

        public void setSession(Session session) {
            this._sessionHolder = new SessionHolder(session);
            this._newSessionHolder = true;
            this._newSession = true;
        }

        public void setSessionHolder(SessionHolder sessionHolder) {
            this._sessionHolder = sessionHolder;
            this._newSessionHolder = false;
            this._newSession = false;
        }
    }

    private static final class SuspendedResourcesHolder {
        private final ConnectionHolder _connectionHolder;
        private final SessionHolder _sessionHolder;

        private SuspendedResourcesHolder(ConnectionHolder connectionHolder, SessionHolder sessionHolder) {
            this._connectionHolder = connectionHolder;
            this._sessionHolder = sessionHolder;
        }
    }
}

