/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONFactoryImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolsUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationEnvBuilder {
    private static final Pattern _attributeDefaultValuePattern = Pattern.compile("\\bdeflt = \"(?<defaultValue>[^\"]*)\"");
    private static final Pattern _attributeDeprecatedPattern = Pattern.compile("\\b(?<deprecated>@Deprecated)");
    private static final Pattern _attributeDescriptionPattern = Pattern.compile("\\bdescription = \"(?<description>[^\"]*)\"");
    private static final Pattern _attributeMaxPattern = Pattern.compile("\\bmax = \"(?<max>[^\"]+)\"");
    private static final Pattern _attributeMinPattern = Pattern.compile("\\bmin = \"(?<min>[^\"]+)\"");
    private static final Pattern _attributeOptionLabelsPattern = Pattern.compile("\\boptionLabels = \\{(?<optionLabels>[^{}]*)}");
    private static final Pattern _attributeOptionValuesPattern = Pattern.compile("\\boptionValues = \\{(?<optionValues>[^{}]*)}");
    private static final Pattern _attributeRequiredInputPattern = Pattern.compile("\\brequiredInput = (?<requiredInput>true|false)");
    private static final Pattern _attributeRequiredPattern = Pattern.compile("\\brequired = (?<required>true|false)");
    private static final Pattern _attributeTitlePattern = Pattern.compile("\\bname = \"(?<title>[^\"]*)\"");
    private static final Pattern _attributeTypeNamePattern = Pattern.compile("\\s+public(default)? (?<type>\\w+|\\S+) (?<name>\\w+)\\(\\)");
    private static final Properties _languageProperties = new Properties();
    private static final JSONFactory _jsonFactory = new JSONFactoryImpl();
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationEnvBuilder.class);
    private static final Pattern _objectDefCategoryPattern = Pattern.compile("\\bcategory = \"(?<category>[^\"]*)\"");
    private static final Pattern _objectDefDescriptionPattern = Pattern.compile("\\bdescription = \"(?<description>[^\"]*)\"");
    private static final Pattern _objectDefScopePattern = Pattern.compile("\\bscope = ExtendedObjectClassDefinition\\.Scope\\.(?<scope>SYSTEM|COMPANY|GROUP|PORTLET_INSTANCE)\\b");
    private static final Pattern _objectDefInterfaceNamePattern = Pattern.compile(" @?interface (?<interfaceName>[A-Z][A-Za-z\\d]+)\\b");
    private static final Pattern _objectDefExtendsInterfaceNamePattern = Pattern.compile("\\bextends (?<extendsInterfaceName>[A-Z][A-Za-z\\d]+)\\b");
    private static final Pattern _objectDefPidPattern = Pattern.compile("\\bid = \"?(?<pid>[\\w.]+)\"?");
    private static final Pattern _objectDefTitlePattern = Pattern.compile("\\bname = \"(?<title>[^\"]*)\"");
    private static final Pattern _objectDefMetaAnnotationPattern = Pattern.compile("@Meta.OCD\\b");
    private static final Pattern _attributeDefMetaAnnotationPattern = Pattern.compile("@Meta.AD\\b");
    private static final Map<String, String> _schemaDataTypes = HashMapBuilder.put((Object)"boolean", (Object)"boolean").put((Object)"float", (Object)"number").put((Object)"int", (Object)"number").put((Object)"LocalizedValuesMap", (Object)"object").put((Object)"long", (Object)"number").put((Object)"String", (Object)"string").put((Object)"String[]", (Object)"array").build();

    public static void main(String[] args) throws IOException {
        String jsonSchemaOutputFile;
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        Path languagePropertiesPath = Paths.get(arguments.get("language.properties.file"), new String[0]);
        File languagePropertiesFile = languagePropertiesPath.toFile();
        if (languagePropertiesFile.exists()) {
            _languageProperties.load(new FileReader(languagePropertiesFile));
        }
        Path basePath = Paths.get(".", new String[0]);
        List<ObjectDef> objectDefs = ConfigurationEnvBuilder.getObjectDefs(basePath.toRealPath(new LinkOption[0]), StringUtil.split((String)arguments.get("configuration.java.files"), (char)'\n'));
        String propertiesOutputFile = arguments.get("properties.output.file");
        if (Validator.isNotNull((String)propertiesOutputFile)) {
            Path propertiesOutputPath = Paths.get(propertiesOutputFile, new String[0]);
            String content = new String(Files.readAllBytes(propertiesOutputPath));
            int index = content.indexOf("##\n## OSGi Configuration Overrides");
            content = content.substring(0, index);
            content = content.concat(ConfigurationEnvBuilder.buildContent(objectDefs));
            Files.write(propertiesOutputPath, content.getBytes(), new OpenOption[0]);
        }
        if (Validator.isNotNull((String)(jsonSchemaOutputFile = arguments.get("json.schema.output.file")))) {
            String json = ConfigurationEnvBuilder._generateJSON(objectDefs);
            Files.write(Paths.get(jsonSchemaOutputFile, new String[0]), json.getBytes(), new OpenOption[0]);
        }
    }

    protected static String buildContent(List<ObjectDef> objectDefs) {
        StringBundler sb = new StringBundler();
        sb.append("##\n## OSGi Configuration Overrides\n##\n");
        for (ObjectDef objectDef : objectDefs) {
            String fullyQualifiedName = objectDef.pid;
            for (AttributeDef attributeDef : objectDef.attributeDefs) {
                String configurationKey = StringBundler.concat((String[])new String[]{"configuration.override.", fullyQualifiedName, "_", attributeDef.name});
                sb.append("\n");
                sb.append("    #\n");
                sb.append("    # Env: ");
                sb.append(ToolsUtil.encodeEnvironmentProperty(configurationKey));
                sb.append("\n");
                sb.append("    #\n");
                sb.append("    #");
                sb.append(configurationKey);
                sb.append("=");
            }
        }
        return sb.toString();
    }

    private static String _lang(String key) {
        return _languageProperties.getProperty(key, key);
    }

    private static ObjectDef _createObjectDef(Path basePath, String configurationFilePath) {
        List<String> lines = null;
        try {
            String realString = basePath.toString();
            lines = Files.readAllLines(Paths.get(realString, configurationFilePath));
        }
        catch (IOException ioException) {
            _log.error((Object)String.format("Could not read configuration file %s%n", configurationFilePath), (Throwable)ioException);
            return null;
        }
        ObjectDef objectDef = new ObjectDef();
        AttributeDef attributeDef = new AttributeDef();
        for (String line : lines) {
            if (objectDef.interfaceName == null) {
                ConfigurationEnvBuilder._withMatcher(line, objectDef, _objectDefCategoryPattern);
                ConfigurationEnvBuilder._withMatcher(line, objectDef, _objectDefDescriptionPattern, curObjectDef -> {
                    curObjectDef.description = ConfigurationEnvBuilder._lang(curObjectDef.description);
                });
                ConfigurationEnvBuilder._withMatcher(line, objectDef, _objectDefMetaAnnotationPattern, curObjectDef -> {
                    curObjectDef.hasMetaAnnotation = true;
                });
                ConfigurationEnvBuilder._withMatcher(line, objectDef, _objectDefPidPattern);
                ConfigurationEnvBuilder._withMatcher(line, objectDef, _objectDefScopePattern, curObjectDef -> {
                    curObjectDef.scope = StringUtil.lowerCase((String)curObjectDef.scope);
                });
                ConfigurationEnvBuilder._withMatcher(line, objectDef, _objectDefTitlePattern, curObjectDef -> {
                    curObjectDef.title = ConfigurationEnvBuilder._lang(curObjectDef.title);
                });
                ConfigurationEnvBuilder._withMatcher(line, objectDef, _objectDefInterfaceNamePattern);
                continue;
            }
            ConfigurationEnvBuilder._withMatcher(line, objectDef, _objectDefExtendsInterfaceNamePattern);
            if (!StringUtil.startsWith((String)objectDef.pid, (String)"com.liferay")) {
                String fullyQualifiedName = configurationFilePath.substring(configurationFilePath.indexOf(StringBundler.concat((String[])new String[]{"com", File.separator, "liferay"})), configurationFilePath.indexOf(".java"));
                objectDef.pid = fullyQualifiedName = StringUtil.replace((String)fullyQualifiedName, (String)File.separator, (String)".");
            }
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeDefaultValuePattern);
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeDeprecatedPattern, curAttributeDef -> {
                curAttributeDef.deprecated = true;
            });
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeDescriptionPattern, curAttributeDef -> {
                curAttributeDef.description = ConfigurationEnvBuilder._lang(curAttributeDef.description);
            });
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeMaxPattern);
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeDefMetaAnnotationPattern, curAttributeDef -> {
                curAttributeDef.hasMetaAnnotation = true;
            });
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeMinPattern);
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeOptionLabelsPattern);
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeOptionValuesPattern);
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeRequiredInputPattern);
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeRequiredPattern);
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeTitlePattern, curAttributeDef -> {
                curAttributeDef.title = ConfigurationEnvBuilder._lang(curAttributeDef.title);
            });
            ConfigurationEnvBuilder._withMatcher(line, attributeDef, _attributeTypeNamePattern);
            if (attributeDef.name == null) continue;
            if (attributeDef.requiredInput) {
                attributeDef.required = true;
            }
            if (attributeDef.defaultValue != null) {
                if (attributeDef.isBoolean()) {
                    attributeDef.defaultValue = ConfigurationEnvBuilder._toBoolean(attributeDef.defaultValue);
                }
                if (attributeDef.isNumber()) {
                    attributeDef.defaultValue = ConfigurationEnvBuilder._toNumber(String.valueOf(attributeDef.defaultValue));
                }
                if (StringUtil.startsWith((String)String.valueOf(attributeDef.defaultValue), (String)"${")) {
                    attributeDef.defaultValue = null;
                }
            }
            if (ArrayUtil.isNotEmpty((Object[])attributeDef.optionValues) && attributeDef.isNumber()) {
                Object[] optionValues = new Number[]{};
                for (Object optionValue : attributeDef.optionValues) {
                    optionValues = (Number[])ArrayUtil.append((Object[])optionValues, (Object)ConfigurationEnvBuilder._toNumber(String.valueOf(optionValue)));
                }
                attributeDef.optionValues = optionValues;
            }
            if (objectDef.hasMetaAnnotation || attributeDef.hasMetaAnnotation) {
                objectDef.attributeDefs.add(attributeDef);
            }
            attributeDef = new AttributeDef();
        }
        if (ListUtil.isEmpty(objectDef.attributeDefs)) {
            return null;
        }
        return objectDef;
    }

    private static String _generateJSON(List<ObjectDef> objectDefs) {
        JSONObject schemaJSONObject = ConfigurationEnvBuilder._toJSONObject(jsonObject -> jsonObject.put("oneOf", ConfigurationEnvBuilder._toJSONArray(new Object[0])).put("properties", ConfigurationEnvBuilder._toJSONObject("pid", ConfigurationEnvBuilder._toJSONObject("enum", ConfigurationEnvBuilder._toJSONArray(new Object[0])))));
        for (ObjectDef objectDef : objectDefs) {
            if (!Objects.equals(objectDef.scope, "company")) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)String.format("Scope for %s is %s, SKIPPING %n", objectDef.pid, objectDef.scope));
                continue;
            }
            schemaJSONObject.getJSONArray("oneOf").put(objectDef.toJSONObject());
            schemaJSONObject.getJSONObject("properties").getJSONObject("pid").getJSONArray("enum").put(objectDef.pid);
        }
        return schemaJSONObject.toString();
    }

    protected static List<ObjectDef> getObjectDefs(Path basePath, String[] configurationFilePaths) throws IOException {
        ArrayList<ObjectDef> objectDefs = new ArrayList<ObjectDef>();
        Path realPath = basePath.toRealPath(new LinkOption[0]);
        for (String configurationFilePath : configurationFilePaths) {
            ObjectDef objectDef = ConfigurationEnvBuilder._createObjectDef(realPath, configurationFilePath);
            if (objectDef == null) continue;
            objectDefs.add(objectDef);
        }
        return ConfigurationEnvBuilder._postProcessObjectDefs(objectDefs);
    }

    private static List<ObjectDef> _postProcessObjectDefs(List<ObjectDef> objectDefs) {
        ArrayList<ObjectDef> newObjectDefs = new ArrayList<ObjectDef>();
        for (ObjectDef objectDef : objectDefs) {
            if (!objectDef.hasMetaAnnotation) continue;
            if (!Validator.isBlank((String)objectDef.extendsInterfaceName)) {
                objectDefs.stream().filter(objectDef::extendsObjectDef).limit(1L).flatMap(objectDef1 -> objectDef1.attributeDefs.stream()).filter(attributeDef -> !objectDef.attributeDefs.contains(attributeDef)).forEach(objectDef.attributeDefs::add);
            }
            Collections.sort(objectDef.attributeDefs);
            newObjectDefs.add(objectDef);
        }
        Collections.sort(newObjectDefs);
        return newObjectDefs;
    }

    private static JSONArray _toJSONArray(Object ... items) {
        return _jsonFactory.createJSONArray(items);
    }

    private static JSONObject _toJSONObject(Consumer<JSONObject> consumer) {
        JSONObject jsonObject = _jsonFactory.createJSONObject();
        consumer.accept(jsonObject);
        return jsonObject;
    }

    private static JSONObject _toJSONObject(String key, Object value) {
        return ConfigurationEnvBuilder._toJSONObject(jsonObject -> jsonObject.put(key, value));
    }

    private static JSONObject _toJSONObject(String key, UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
        return ConfigurationEnvBuilder._toJSONObject(jsonObject -> jsonObject.put(key, valueUnsafeSupplier));
    }

    private static void _setFieldValue(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private static boolean _toBoolean(Object object) {
        return Objects.equals(String.valueOf(object), String.valueOf(Boolean.TRUE));
    }

    private static Number _toNumber(Object object) {
        String s = String.valueOf(object);
        if (Validator.isBlank((String)s)) {
            return 0;
        }
        if (s.contains(".")) {
            return Float.valueOf(GetterUtil.getFloat((String)s));
        }
        return GetterUtil.getInteger((String)s);
    }

    private static void _withMatcher(String s, Object object, Pattern pattern) {
        ConfigurationEnvBuilder._withMatcher(s, object, pattern, null);
    }

    private static <T> void _withMatcher(String s, T target, Pattern pattern, Consumer<T> consumer) {
        Matcher matcher = pattern.matcher(s);
        if (!matcher.find()) {
            return;
        }
        Class<?> clazz = target.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            String value;
            try {
                value = matcher.group(field.getName());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
                continue;
            }
            Class<?> typeClass = field.getType();
            if (ArrayUtil.contains((Object[])new Class[]{Object[].class, String[].class}, typeClass)) {
                ConfigurationEnvBuilder._setFieldValue(field, target, value.replaceAll("[ \"]", "").split(","));
                continue;
            }
            if (Objects.equals(typeClass, Number.class)) {
                ConfigurationEnvBuilder._setFieldValue(field, target, ConfigurationEnvBuilder._toNumber(value));
                continue;
            }
            if (Objects.equals(typeClass, Boolean.TYPE)) {
                ConfigurationEnvBuilder._setFieldValue(field, target, ConfigurationEnvBuilder._toBoolean(value));
                continue;
            }
            if (Objects.equals(field.getName(), "type")) {
                ConfigurationEnvBuilder._setFieldValue(field, target, _schemaDataTypes.get(value));
                continue;
            }
            ConfigurationEnvBuilder._setFieldValue(field, target, value);
        }
        if (consumer != null) {
            consumer.accept(target);
        }
    }

    protected static class ObjectDef
    implements Comparable<ObjectDef> {
        protected List<AttributeDef> attributeDefs = new ArrayList<AttributeDef>();
        protected String category;
        protected String description;
        protected String extendsInterfaceName;
        protected boolean hasMetaAnnotation;
        protected String interfaceName;
        protected String pid;
        protected String scope = "system";
        protected String title;

        protected ObjectDef() {
        }

        @Override
        public int compareTo(ObjectDef objectDef) {
            return this.pid.compareTo(objectDef.pid);
        }

        protected boolean extendsObjectDef(ObjectDef superObjectDef) {
            return Objects.equals(this.extendsInterfaceName, superObjectDef.interfaceName);
        }

        protected JSONObject toJSONObject() {
            JSONObject jsonObject = ConfigurationEnvBuilder._toJSONObject("description", (UnsafeSupplier<Object, Exception>)((UnsafeSupplier)() -> this.description)).put("properties", ConfigurationEnvBuilder._toJSONObject("pid", ConfigurationEnvBuilder._toJSONObject("const", this.pid).put("description", () -> this.description).put("title", () -> this.title))).put("required", ConfigurationEnvBuilder._toJSONArray("pid")).put("title", () -> this.title);
            for (AttributeDef attributeDef : this.attributeDefs) {
                if (attributeDef.required) {
                    jsonObject.getJSONArray("required").put(attributeDef.name);
                }
                jsonObject.getJSONObject("properties").put(attributeDef.name, attributeDef.toJSONObject());
            }
            return jsonObject;
        }
    }

    protected static class AttributeDef
    implements Comparable<AttributeDef> {
        protected Object defaultValue;
        protected Boolean deprecated;
        protected String description;
        protected boolean hasMetaAnnotation;
        protected Number max;
        protected Number min;
        protected String name;
        protected String[] optionLabels;
        protected Object[] optionValues;
        protected boolean required = true;
        protected boolean requiredInput;
        protected String title;
        protected String type;

        protected AttributeDef() {
        }

        @Override
        public int compareTo(AttributeDef attributeDef) {
            return this.name.compareTo(attributeDef.name);
        }

        public boolean equals(Object object) {
            if (!Objects.equals(AttributeDef.class, object.getClass())) {
                return false;
            }
            AttributeDef attributeDef = (AttributeDef)object;
            return Objects.equals(this.name, attributeDef.name);
        }

        public int hashCode() {
            String string = this.toJSONObject().toString();
            return string.hashCode();
        }

        protected boolean isArray() {
            return Objects.equals(this.type, "array");
        }

        protected boolean isBoolean() {
            return Objects.equals(this.type, "boolean");
        }

        protected boolean isNumber() {
            return Objects.equals(this.type, "number");
        }

        protected boolean isObject() {
            return Objects.equals(this.type, "object");
        }

        protected boolean isString() {
            return Objects.equals(this.type, "string");
        }

        protected JSONObject toJSONObject() {
            JSONObject jsonObject = ConfigurationEnvBuilder._toJSONObject("default", (UnsafeSupplier<Object, Exception>)((UnsafeSupplier)() -> this.defaultValue)).put("deprecated", () -> this.deprecated).put("description", () -> this.description).put("title", () -> this.title).put("type", () -> this.type);
            if (this.isArray()) {
                jsonObject.put("items", ConfigurationEnvBuilder._toJSONObject("type", "string"));
            }
            if (this.isObject()) {
                jsonObject.put("properties", _jsonFactory.createJSONObject());
            }
            if (this.isNumber()) {
                jsonObject.put("max", () -> this.max).put("min", () -> this.min);
            }
            if (this.isString()) {
                jsonObject.put("maxLength", () -> this.max).put("minLength", () -> this.min);
            }
            if (ArrayUtil.isNotEmpty((Object[])this.optionValues)) {
                JSONArray optionValuesJSONArray = ConfigurationEnvBuilder._toJSONArray(this.optionValues);
                if (this.isArray()) {
                    jsonObject.getJSONObject("items").put("enum", optionValuesJSONArray);
                } else {
                    jsonObject.put("enum", optionValuesJSONArray);
                }
            }
            return jsonObject;
        }
    }
}

