/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.change.tracking.store.CTStoreFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.upgrade.v6_2_0.util.DLValidatorImpl;
import com.liferay.portal.upgrade.v6_2_0.util.DummyCTStoreFactoryImpl;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class BaseAttachmentsUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_LIFERAY_REPOSITORY = "com.liferay.portal.repository.liferayrepository.LiferayRepository";
    private static final Log _log = LogFactoryUtil.getLog(BaseAttachmentsUpgradeProcess.class);
    private final Map<String, Map<String, Long>> _bitwiseValues = new HashMap<String, Map<String, Long>>();
    private final Map<String, Long> _roleIds = new HashMap<String, Long>();

    protected long addDLFileEntry(long groupId, long companyId, long userId, String className, long classPK, String userName, Timestamp createDate, long repositoryId, long folderId, String name, String extension, String mimeType, String title, long size) throws Exception {
        long l;
        block9: {
            long fileEntryId = this.increment();
            PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into DLFileEntry (uuid_, fileEntryId, groupId, ", "companyId, userId, userName, createDate, modifiedDate, ", "classNameId, classPK, repositoryId, folderId, name, ", "extension, mimeType, title, description, extraSettings, ", "fileEntryTypeId, version, size_, smallImageId, ", "largeImageId, custom1ImageId, custom2ImageId) values (?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?)"}));
            try {
                preparedStatement.setString(1, PortalUUIDUtil.generate());
                preparedStatement.setLong(2, fileEntryId);
                preparedStatement.setLong(3, groupId);
                preparedStatement.setLong(4, companyId);
                preparedStatement.setLong(5, userId);
                preparedStatement.setString(6, userName);
                preparedStatement.setTimestamp(7, createDate);
                preparedStatement.setTimestamp(8, createDate);
                preparedStatement.setLong(9, PortalUtil.getClassNameId((String)className));
                preparedStatement.setLong(10, classPK);
                preparedStatement.setLong(11, repositoryId);
                preparedStatement.setLong(12, folderId);
                preparedStatement.setString(13, name);
                preparedStatement.setString(14, extension);
                preparedStatement.setString(15, mimeType);
                preparedStatement.setString(16, title);
                preparedStatement.setString(17, "");
                preparedStatement.setString(18, "");
                preparedStatement.setLong(19, 0L);
                preparedStatement.setString(20, "1.0");
                preparedStatement.setLong(21, size);
                preparedStatement.setInt(22, 0);
                preparedStatement.setLong(23, 0L);
                preparedStatement.setLong(24, 0L);
                preparedStatement.setLong(25, 0L);
                preparedStatement.executeUpdate();
                long bitwiseValue = this.getBitwiseValue(this.getBitwiseValues("com.liferay.portlet.documentlibrary.model.DLFileEntry"), ListUtil.fromArray((Object[])new String[]{"VIEW"}));
                this.addResourcePermission(companyId, "com.liferay.portlet.documentlibrary.model.DLFileEntry", fileEntryId, this.getRoleId(companyId, "Guest"), bitwiseValue);
                this.addResourcePermission(companyId, "com.liferay.portlet.documentlibrary.model.DLFileEntry", fileEntryId, this.getRoleId(companyId, "Site Member"), bitwiseValue);
                l = fileEntryId;
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to add file entry " + name), (Throwable)exception);
                    }
                    return -1L;
                }
            }
            preparedStatement.close();
        }
        return l;
    }

    protected void addDLFileVersion(long fileVersionId, long groupId, long companyId, long userId, String userName, Timestamp createDate, long repositoryId, long folderId, long fileEntryId, String extension, String mimeType, String title, long size) throws Exception {
        block8: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into DLFileVersion (uuid_, fileVersionId, ", "groupId, companyId, userId, userName, createDate, ", "modifiedDate, repositoryId, folderId, fileEntryId, ", "extension, mimeType, title, description, changeLog, ", "extraSettings, fileEntryTypeId, version, size_, status, ", "statusByUserId, statusByUserName, statusDate) values (?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?)"}));){
                preparedStatement.setString(1, PortalUUIDUtil.generate());
                preparedStatement.setLong(2, fileVersionId);
                preparedStatement.setLong(3, groupId);
                preparedStatement.setLong(4, companyId);
                preparedStatement.setLong(5, userId);
                preparedStatement.setString(6, userName);
                preparedStatement.setTimestamp(7, createDate);
                preparedStatement.setTimestamp(8, createDate);
                preparedStatement.setLong(9, repositoryId);
                preparedStatement.setLong(10, folderId);
                preparedStatement.setLong(11, fileEntryId);
                preparedStatement.setString(12, extension);
                preparedStatement.setString(13, mimeType);
                preparedStatement.setString(14, title);
                preparedStatement.setString(15, "");
                preparedStatement.setString(16, "");
                preparedStatement.setString(17, "");
                preparedStatement.setLong(18, 0L);
                preparedStatement.setString(19, "1.0");
                preparedStatement.setLong(20, size);
                preparedStatement.setInt(21, 0);
                preparedStatement.setLong(22, userId);
                preparedStatement.setString(23, userName);
                preparedStatement.setTimestamp(24, createDate);
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to add file version 1.0 for file entry " + title), (Throwable)exception);
            }
        }
    }

    protected long addDLFolder(long folderId, long groupId, long companyId, long userId, String userName, Timestamp createDate, long repositoryId, boolean mountPoint, long parentFolderId, String name, boolean hidden) throws Exception {
        long l;
        block9: {
            PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into DLFolder (uuid_, folderId, groupId, ", "companyId, userId, userName, createDate, modifiedDate, ", "repositoryId, mountPoint, parentFolderId, name, ", "description, lastPostDate, defaultFileEntryTypeId, ", "hidden_, overrideFileEntryTypes, status, statusByUserId, ", "statusByUserName, statusDate) values (?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"}));
            try {
                preparedStatement.setString(1, PortalUUIDUtil.generate());
                preparedStatement.setLong(2, folderId);
                preparedStatement.setLong(3, groupId);
                preparedStatement.setLong(4, companyId);
                preparedStatement.setLong(5, userId);
                preparedStatement.setString(6, userName);
                preparedStatement.setTimestamp(7, createDate);
                preparedStatement.setTimestamp(8, createDate);
                preparedStatement.setLong(9, repositoryId);
                preparedStatement.setBoolean(10, mountPoint);
                preparedStatement.setLong(11, parentFolderId);
                preparedStatement.setString(12, name);
                preparedStatement.setString(13, "");
                preparedStatement.setTimestamp(14, createDate);
                preparedStatement.setLong(15, 0L);
                preparedStatement.setBoolean(16, hidden);
                preparedStatement.setBoolean(17, false);
                preparedStatement.setLong(18, 0L);
                preparedStatement.setLong(19, userId);
                preparedStatement.setString(20, userName);
                preparedStatement.setTimestamp(21, createDate);
                preparedStatement.executeUpdate();
                Map<String, Long> bitwiseValues = this.getBitwiseValues("com.liferay.portlet.documentlibrary.model.DLFolder");
                long guestBitwiseValue = this.getBitwiseValue(bitwiseValues, ListUtil.fromArray((Object[])new String[]{"VIEW"}));
                this.addResourcePermission(companyId, "com.liferay.portlet.documentlibrary.model.DLFolder", folderId, this.getRoleId(companyId, "Guest"), guestBitwiseValue);
                ArrayList<String> siteMemberActionIds = new ArrayList<String>();
                siteMemberActionIds.add("ADD_DOCUMENT");
                siteMemberActionIds.add("ADD_SUBFOLDER");
                siteMemberActionIds.add("VIEW");
                long siteMemberBitwiseValue = this.getBitwiseValue(bitwiseValues, siteMemberActionIds);
                this.addResourcePermission(companyId, "com.liferay.portlet.documentlibrary.model.DLFolder", folderId, this.getRoleId(companyId, "Site Member"), siteMemberBitwiseValue);
                l = folderId;
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to add folder " + name), (Throwable)exception);
                    }
                    return -1L;
                }
            }
            preparedStatement.close();
        }
        return l;
    }

    protected long addRepository(long groupId, long companyId, long userId, String userName, Timestamp createDate, long classNameId, String portletId) throws Exception {
        long l;
        block10: {
            long repositoryId = this.increment();
            long folderId = this.addDLFolder(this.increment(), groupId, companyId, userId, userName, createDate, repositoryId, true, 0L, portletId, true);
            if (folderId < 0L) {
                return -1L;
            }
            PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into Repository (uuid_, repositoryId, groupId, ", "companyId, userId, userName, createDate, modifiedDate, ", "classNameId, name, description, portletId, typeSettings, ", "dlFolderId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?)"}));
            try {
                preparedStatement.setString(1, PortalUUIDUtil.generate());
                preparedStatement.setLong(2, repositoryId);
                preparedStatement.setLong(3, groupId);
                preparedStatement.setLong(4, companyId);
                preparedStatement.setLong(5, userId);
                preparedStatement.setString(6, userName);
                preparedStatement.setTimestamp(7, createDate);
                preparedStatement.setTimestamp(8, createDate);
                preparedStatement.setLong(9, classNameId);
                preparedStatement.setString(10, portletId);
                preparedStatement.setString(11, "");
                preparedStatement.setString(12, portletId);
                preparedStatement.setString(13, "");
                preparedStatement.setLong(14, folderId);
                preparedStatement.executeUpdate();
                l = repositoryId;
                if (preparedStatement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to add repository for portlet " + portletId), (Throwable)exception);
                    }
                    return -1L;
                }
            }
            preparedStatement.close();
        }
        return l;
    }

    protected void addResourcePermission(long companyId, String className, long primKey, long roleId, long actionIds) throws Exception {
        block8: {
            long resourcePermissionId = this.increment(ResourcePermission.class.getName());
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into ResourcePermission (resourcePermissionId, ", "companyId, name, scope, primKey, roleId, ownerId, ", "actionIds) values (?, ?, ?, ?, ?, ?, ?, ?)"}));){
                preparedStatement.setLong(1, resourcePermissionId);
                preparedStatement.setLong(2, companyId);
                preparedStatement.setString(3, className);
                preparedStatement.setInt(4, 4);
                preparedStatement.setLong(5, primKey);
                preparedStatement.setLong(6, roleId);
                preparedStatement.setLong(7, 0L);
                preparedStatement.setLong(8, actionIds);
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to add resource permission " + className), (Throwable)exception);
            }
        }
    }

    protected void doUpgrade() throws Exception {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        ServiceRegistration ctStoreFactoryServiceRegistration = bundleContext.registerService(CTStoreFactory.class, (Object)new DummyCTStoreFactoryImpl(), null);
        ServiceRegistration dlValidatorServiceRegistration = bundleContext.registerService(DLValidator.class, (Object)new DLValidatorImpl(), null);
        this.updateAttachments();
        ctStoreFactoryServiceRegistration.unregister();
        dlValidatorServiceRegistration.unregister();
    }

    protected String[] getAttachments(long companyId, long containerModelId, long resourcePrimKey) throws Exception {
        return DLStoreUtil.getFileNames((long)companyId, (long)0L, (String)this.getDirName(containerModelId, resourcePrimKey));
    }

    protected long getBitwiseValue(Map<String, Long> bitwiseValues, List<String> actionIds) {
        long bitwiseValue = 0L;
        for (String actionId : actionIds) {
            Long actionIdBitwiseValue = bitwiseValues.get(actionId);
            if (actionIdBitwiseValue == null) continue;
            bitwiseValue |= actionIdBitwiseValue.longValue();
        }
        return bitwiseValue;
    }

    protected Map<String, Long> getBitwiseValues(String name) throws Exception {
        Map<String, Long> bitwiseValues = this._bitwiseValues.get(name);
        if (bitwiseValues != null) {
            return bitwiseValues;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select actionId, bitwiseValue from ResourceAction where name = ?");){
            Map<String, Long> map;
            block14: {
                preparedStatement.setString(1, name);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    bitwiseValues = new HashMap<String, Long>();
                    while (resultSet.next()) {
                        String actionId = resultSet.getString("actionId");
                        long bitwiseValue = resultSet.getLong("bitwiseValue");
                        bitwiseValues.put(actionId, bitwiseValue);
                    }
                    this._bitwiseValues.put(name, bitwiseValues);
                    map = bitwiseValues;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return map;
        }
    }

    protected abstract String getClassName();

    protected long getClassNameId() {
        return PortalUtil.getClassNameId((String)this.getClassName());
    }

    protected long getContainerModelFolderId(long groupId, long companyId, long resourcePrimKey, long containerModelId, long userId, String userName, Timestamp createDate) throws Exception {
        return 0L;
    }

    protected abstract String getDirName(long var1, long var3);

    protected long getFolderId(long groupId, long companyId, long userId, String userName, Timestamp createDate, long repositoryId, long parentFolderId, String name, boolean hidden) throws Exception {
        if (repositoryId < 0L || parentFolderId < 0L) {
            return -1L;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select folderId from DLFolder where repositoryId = ? and parentFolderId = ? and name = ?");){
            preparedStatement.setLong(1, repositoryId);
            preparedStatement.setLong(2, parentFolderId);
            preparedStatement.setString(3, name);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    return l;
                }
            }
        }
        return this.addDLFolder(this.increment(), groupId, companyId, userId, userName, createDate, repositoryId, false, parentFolderId, name, hidden);
    }

    protected abstract String getPortletId();

    protected long getRepositoryId(long groupId, long companyId, long userId, String userName, Timestamp createDate, long classNameId, String portletId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select repositoryId from Repository where groupId = ? and name = ? and portletId = ?");){
            preparedStatement.setLong(1, groupId);
            preparedStatement.setString(2, portletId);
            preparedStatement.setString(3, portletId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    return l;
                }
            }
        }
        return this.addRepository(groupId, companyId, userId, userName, createDate, classNameId, portletId);
    }

    protected long getRoleId(long companyId, String name) throws Exception {
        String roleIdsKey = companyId + "#" + name;
        Long roleId = this._roleIds.get(roleIdsKey);
        if (roleId != null) {
            return roleId;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select roleId from Role_ where companyId = ? and name = ?");){
            long l;
            block14: {
                preparedStatement.setLong(1, companyId);
                preparedStatement.setString(2, name);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (resultSet.next()) {
                        roleId = resultSet.getLong("roleId");
                    }
                    this._roleIds.put(roleIdsKey, roleId);
                    l = roleId;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
    }

    protected abstract void updateAttachments() throws Exception;

    protected void updateEntryAttachments(long companyId, long groupId, long resourcePrimKey, long containerModelId, long userId, String userName) throws Exception {
        Object[] attachments = this.getAttachments(companyId, containerModelId, resourcePrimKey);
        if (ArrayUtil.isEmpty((Object[])attachments)) {
            return;
        }
        Timestamp createDate = new Timestamp(System.currentTimeMillis());
        long repositoryId = this.getRepositoryId(groupId, companyId, userId, userName, createDate, PortalUtil.getClassNameId((String)_CLASS_NAME_LIFERAY_REPOSITORY), this.getPortletId());
        if (repositoryId < 0L) {
            return;
        }
        long containerModelFolderId = this.getContainerModelFolderId(groupId, companyId, resourcePrimKey, containerModelId, userId, userName, createDate);
        if (containerModelFolderId < 0L) {
            return;
        }
        for (Object attachment : attachments) {
            block8: {
                String name = String.valueOf(this.increment("com.liferay.portlet.documentlibrary.model.DLFileEntry"));
                String title = FileUtil.getShortFileName((String)attachment);
                String extension = FileUtil.getExtension((String)title);
                String mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
                try {
                    long size = DLStoreUtil.getFileSize((long)companyId, (long)0L, (String)attachment);
                    long fileEntryId = this.addDLFileEntry(groupId, companyId, userId, this.getClassName(), resourcePrimKey, userName, createDate, repositoryId, containerModelFolderId, name, extension, mimeType, title, size);
                    if (fileEntryId < 0L) continue;
                    this.addDLFileVersion(this.increment(), groupId, companyId, userId, userName, createDate, repositoryId, containerModelFolderId, fileEntryId, extension, mimeType, title, size);
                    byte[] bytes = StreamUtil.toByteArray((InputStream)DLStoreUtil.getFileAsStream((long)companyId, (long)0L, (String)attachment, (String)""));
                    DLStoreUtil.addFile((DLStoreRequest)DLStoreRequest.builder((long)companyId, (long)containerModelFolderId, (String)name).className((Object)this).size((long)bytes.length).build(), (byte[])bytes);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)("Unable to add attachment " + (String)attachment), (Throwable)exception);
                }
            }
            try {
                DLStoreUtil.deleteFile((long)companyId, (long)0L, (String)attachment);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to delete attachment " + (String)attachment), (Throwable)exception);
            }
        }
    }
}

