/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.BasePortletPreferencesUpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public abstract class BaseUpgradePortletPreferences
extends BasePortletPreferencesUpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseUpgradePortletPreferences.class);

    protected void deletePortletPreferencesByOwnerType(int ownerType, String whereClause, String leftColumnName, String[] ... joinTables) throws Exception {
        StringBundler sb = new StringBundler(9 * joinTables.length + 5);
        sb.append("delete from PortletPreferences where ownerType = ");
        sb.append(String.valueOf(ownerType));
        for (String[] joinTable : joinTables) {
            sb.append(" and not exists (select 1 from ");
            sb.append(joinTable[1]);
            sb.append(" where PortletPreferences.");
            sb.append(leftColumnName);
            sb.append(" = ");
            sb.append(joinTable[1]);
            sb.append(".");
            sb.append(joinTable[0]);
            sb.append(")");
        }
        if (Validator.isNotNull((String)whereClause)) {
            sb.append(" and (");
            sb.append(whereClause);
            sb.append(")");
        }
        this.runSQL(sb.toString());
    }

    protected void updatePortletPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String whereClause = this.getUpdatePortletPreferencesWhereClause();
            this.deletePortletPreferencesByOwnerType(5, whereClause, "ownerId", new String[][]{{"portletItemId", "PortletItem"}});
            this.deletePortletPreferencesByOwnerType(1, whereClause, "ownerId", new String[][]{{"companyId", "Company"}});
            this.deletePortletPreferencesByOwnerType(2, whereClause, "ownerId", new String[][]{{"groupId", "Group_"}});
            this.deletePortletPreferencesByOwnerType(3, whereClause, "plid", {"plid", "Layout"}, {"layoutRevisionId", "LayoutRevision"});
            this.deletePortletPreferencesByOwnerType(6, whereClause, "ownerId", new String[][]{{"organizationId", "Organization_"}});
            this.deletePortletPreferencesByOwnerType(4, whereClause, "ownerId", new String[][]{{"userId", "User_"}});
            this.updatePortletPreferencesWithOwnerType(5, whereClause, "ownerId", "PortletItem", "portletItemId");
            this.updatePortletPreferencesWithOwnerType(1, whereClause, "ownerId", "Company", "companyId");
            this.updatePortletPreferencesWithOwnerType(2, whereClause, "ownerId", "Group_", "groupId");
            this.updatePortletPreferencesWithOwnerType(3, whereClause, "plid", "Layout", "plid");
            this.updatePortletPreferencesWithOwnerType(3, whereClause, "plid", "LayoutRevision", "layoutRevisionId");
            this.updatePortletPreferencesWithOwnerType(6, whereClause, "ownerId", "Organization_", "organizationId");
            this.updatePortletPreferencesWithOwnerType(4, whereClause, "ownerId", "User_", "userId");
        }
    }

    protected void updatePortletPreferencesWithOwnerType(int ownerType, String whereClause, String leftColumnName, String rightTableName, String rightColumnName) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append(" where PortletPreferences.ownerType = ");
        sb.append(String.valueOf(ownerType));
        if (Validator.isNotNull((String)whereClause)) {
            sb.append(" and (");
            sb.append(whereClause);
            sb.append(")");
        }
        String sql = StringBundler.concat((Object[])new Object[]{"select PortletPreferences.portletPreferencesId as ", "portletPreferencesId, PortletPreferences.ownerId as ownerId, ", "PortletPreferences.plid as plid, PortletPreferences.portletId as ", "portletId, PortletPreferences.preferences as preferences, ", rightTableName, ".companyId as companyId from PortletPreferences inner join ", rightTableName, " on PortletPreferences.", leftColumnName, " = ", rightTableName, ".", rightColumnName, sb});
        if (_log.isDebugEnabled()) {
            _log.debug((Object)sql);
        }
        try (LoggingTimer loggingTimer = new LoggingTimer(rightTableName);
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(sql);
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update PortletPreferences set preferences = ? where portletPreferencesId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String newPreferences;
                long companyId = resultSet.getLong("companyId");
                long ownerId = resultSet.getLong("ownerId");
                long plid = resultSet.getLong("plid");
                String portletId = resultSet.getString("portletId");
                String preferences = GetterUtil.getString((String)resultSet.getString("preferences"));
                if (preferences.equals(newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences))) continue;
                preparedStatement2.setString(1, newPreferences);
                preparedStatement2.setLong(2, resultSet.getLong("portletPreferencesId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

