/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.encryptor.EncryptorUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.security.Key;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeCompany
extends UpgradeProcess {
    private static final String _KEY_ALGORITHM = StringUtil.toUpperCase((String)GetterUtil.getString((String)PropsUtil.get((String)"company.encryption.algorithm")));

    protected void doUpgrade() throws Exception {
        String keyAlgorithm = _KEY_ALGORITHM;
        if (keyAlgorithm.equals("DES")) {
            return;
        }
        this.upgradeKey();
    }

    protected void upgradeKey() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId, key_ from Company");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                String key = resultSet.getString("key_");
                this.upgradeKey(companyId, key);
            }
        }
    }

    protected void upgradeKey(long companyId, String key) throws Exception {
        String algorithm;
        Key keyObj = null;
        if (Validator.isNotNull((String)key)) {
            keyObj = (Key)Base64.stringToObjectSilent((String)key);
        }
        if (keyObj != null && !(algorithm = keyObj.getAlgorithm()).equals("DES")) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update Company set key_ = ? where companyId = ?");){
            preparedStatement.setString(1, Base64.objectToString((Object)EncryptorUtil.generateKey()));
            preparedStatement.setLong(2, companyId);
            preparedStatement.executeUpdate();
        }
    }
}

