/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;

public class UpgradeAsset
extends UpgradeProcess {
    protected void deleteOrphanedAssetEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long classNameId = PortalUtil.getClassNameId((String)DLFileEntryConstants.getClassName());
            DBTypeToSQLMap dbTypeToSQLMap = new DBTypeToSQLMap(StringBundler.concat((Object[])new Object[]{"delete from AssetEntry where classNameId = ", classNameId, " and classPK not in (select fileVersionId from ", "DLFileVersion) and classPK not in (select fileEntryId ", "from DLFileEntry)"}));
            dbTypeToSQLMap.add(DBType.POSTGRESQL, StringBundler.concat((Object[])new Object[]{"delete from AssetEntry where classNameId = ", classNameId, " and not exists (select null from DLFileVersion where ", "fileVersionId = AssetEntry.classPK) and not exists ", "(select null from DLFileEntry where fileEntryId = ", "AssetEntry.classPK)"}));
            this.runSQL(dbTypeToSQLMap);
        }
    }

    protected void doUpgrade() throws Exception {
        this.alterColumnType("AssetEntry", "description", "TEXT null");
        this.alterColumnType("AssetEntry", "summary", "TEXT null");
        this.deleteOrphanedAssetEntries();
        this.updateAssetEntries();
        this.updateAssetVocabularies();
    }

    protected long getDDMStructureId(String structureKey) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select structureId from DDMStructure where structureKey = ?");){
            long l;
            block16: {
                ResultSet resultSet;
                block14: {
                    long l2;
                    block15: {
                        preparedStatement.setString(1, structureKey);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            l2 = resultSet.getLong("structureId");
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return l2;
                }
                l = 0L;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return l;
        }
    }

    protected void updateAssetEntries() throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update AssetEntry set listable = ? where classNameId = ? ", "and classPK in (select JournalArticle.resourcePrimKey as ", "resourcePrimKey from (select ", "JournalArticle.resourcePrimKey as primKey, ", "max(JournalArticle.version) as maxVersion from ", "JournalArticle group by JournalArticle.resourcePrimKey) ", "TEMP_TABLE inner join JournalArticle on ", "(JournalArticle.resourcePrimKey = TEMP_TABLE.primKey and ", "JournalArticle.indexable = ? and JournalArticle.status = ", "0 and JournalArticle.version = ", "TEMP_TABLE.maxVersion))"}));){
            preparedStatement1.setBoolean(1, false);
            preparedStatement1.setLong(2, classNameId);
            preparedStatement1.setBoolean(3, false);
            preparedStatement1.execute();
        }
    }

    protected void updateAssetVocabularies() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select vocabularyId, settings_ from AssetVocabulary");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update AssetVocabulary set settings_ = ? where vocabularyId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long vocabularyId = resultSet.getLong("vocabularyId");
                String settings = resultSet.getString("settings_");
                preparedStatement2.setString(1, this.upgradeVocabularySettings(settings));
                preparedStatement2.setLong(2, vocabularyId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected String upgradeVocabularySettings(String settings) {
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(settings).build();
        AssetVocabularySettingsHelper vocabularySettingsHelper = new AssetVocabularySettingsHelper();
        vocabularySettingsHelper.setMultiValued(GetterUtil.getBoolean((String)unicodeProperties.getProperty("multiValued"), (boolean)true));
        long[] classNameIds = StringUtil.split((String)unicodeProperties.getProperty("selectedClassNameIds"), (long)0L);
        long[] classTypePKs = new long[classNameIds.length];
        Arrays.fill(classTypePKs, -1L);
        long[] requiredClassNameIds = StringUtil.split((String)unicodeProperties.getProperty("requiredClassNameIds"), (long)0L);
        boolean[] requireds = new boolean[classNameIds.length];
        for (int i = 0; i < classNameIds.length; ++i) {
            requireds[i] = ArrayUtil.contains((long[])requiredClassNameIds, (long)classNameIds[i]);
        }
        vocabularySettingsHelper.setClassNameIdsAndClassTypePKs(classNameIds, classTypePKs, requireds);
        return vocabularySettingsHelper.toString();
    }
}

