/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BasePortletPreferencesUpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class UpgradePortletDisplayTemplatePreferences
extends BasePortletPreferencesUpgradeProcess {
    protected static final String DISPLAY_STYLE_PREFIX_6_2 = "ddmTemplate_";
    protected static final String UPDATE_PORTLET_PREFERENCES_WHERE_CLAUSE = "(preferences like '%ddmTemplate_%')";
    private long _companyGroupId = 0L;
    private final Map<Long, Long> _companyGroupIds = new HashMap<Long, Long>();

    protected long getCompanyGroupId(long companyId) throws Exception {
        Long companyGroupId = this._companyGroupIds.get(companyId);
        if (companyGroupId != null) {
            return companyGroupId;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId from Group_ where classNameId = ? and classPK = ?");){
            long l;
            block13: {
                preparedStatement.setLong(1, PortalUtil.getClassNameId(Company.class));
                preparedStatement.setLong(2, companyId);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    companyGroupId = resultSet.next() ? Long.valueOf(resultSet.getLong("groupId")) : Long.valueOf(0L);
                    this._companyGroupIds.put(companyId, companyGroupId);
                    l = companyGroupId;
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
    }

    protected ObjectValuePair<Long, String> getTemplateGroupAndKey(long displayStyleGroupId, String displayStyle) throws Exception {
        String uuid = displayStyle.substring(DISPLAY_STYLE_PREFIX_6_2.length());
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId, templateKey from DDMTemplate where (groupId = ? or groupId = ?) and uuid_ = ?");){
            preparedStatement.setLong(1, displayStyleGroupId);
            preparedStatement.setLong(2, this._companyGroupId);
            preparedStatement.setString(3, uuid);
            ObjectValuePair objectValuePair = null;
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (true) {
                    if (resultSet.next()) {
                        long groupId = resultSet.getLong("groupId");
                        objectValuePair = new ObjectValuePair((Object)groupId, (Object)resultSet.getString("templateKey"));
                        if (groupId != displayStyleGroupId) continue;
                        ObjectValuePair objectValuePair2 = objectValuePair;
                        return objectValuePair2;
                        continue;
                    }
                    break;
                }
            }
            ObjectValuePair objectValuePair3 = objectValuePair;
            return objectValuePair3;
        }
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        return UPDATE_PORTLET_PREFERENCES_WHERE_CLAUSE;
    }

    protected void upgradeDisplayStyle(PortletPreferences portletPreferences) throws Exception {
        String displayStyle = GetterUtil.getString((String)portletPreferences.getValue("displayStyle", null));
        if (Validator.isNull((String)displayStyle) || !displayStyle.startsWith(DISPLAY_STYLE_PREFIX_6_2)) {
            return;
        }
        long displayStyleGroupId = GetterUtil.getLong((String)portletPreferences.getValue("displayStyleGroupId", null));
        ObjectValuePair<Long, String> objectValuePair = this.getTemplateGroupAndKey(displayStyleGroupId, displayStyle);
        if (objectValuePair != null) {
            portletPreferences.setValue("displayStyleGroupId", String.valueOf(objectValuePair.getKey()));
            portletPreferences.setValue("displayStyle", DISPLAY_STYLE_PREFIX_6_2 + (String)objectValuePair.getValue());
        }
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        this._companyGroupId = this.getCompanyGroupId(companyId);
        this.upgradeDisplayStyle(portletPreferences);
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }
}

